// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineGovernancePoliciesClassificationCategoryCreateReader is a Reader for the DataEngineGovernancePoliciesClassificationCategoryCreate structure.
type DataEngineGovernancePoliciesClassificationCategoryCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewDataEngineGovernancePoliciesClassificationCategoryCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineGovernancePoliciesClassificationCategoryCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineGovernancePoliciesClassificationCategoryCreateCreated creates a DataEngineGovernancePoliciesClassificationCategoryCreateCreated with default headers values
func NewDataEngineGovernancePoliciesClassificationCategoryCreateCreated() *DataEngineGovernancePoliciesClassificationCategoryCreateCreated {
	return &DataEngineGovernancePoliciesClassificationCategoryCreateCreated{}
}

/*
DataEngineGovernancePoliciesClassificationCategoryCreateCreated describes a response with status code 201, with default header values.

Created
*/
type DataEngineGovernancePoliciesClassificationCategoryCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DataEngineGovernancePoliciesClassificationCategoryResponse
}

// IsSuccess returns true when this data engine governance policies classification category create created response has a 2xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine governance policies classification category create created response has a 3xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine governance policies classification category create created response has a 4xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine governance policies classification category create created response has a 5xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine governance policies classification category create created response a status code equal to that given
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the data engine governance policies classification category create created response
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateCreated) Code() int {
	return 201
}

func (o *DataEngineGovernancePoliciesClassificationCategoryCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/governance/policies/classification/categories][%d] dataEngineGovernancePoliciesClassificationCategoryCreateCreated %s", 201, payload)
}

func (o *DataEngineGovernancePoliciesClassificationCategoryCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/governance/policies/classification/categories][%d] dataEngineGovernancePoliciesClassificationCategoryCreateCreated %s", 201, payload)
}

func (o *DataEngineGovernancePoliciesClassificationCategoryCreateCreated) GetPayload() *models.DataEngineGovernancePoliciesClassificationCategoryResponse {
	return o.Payload
}

func (o *DataEngineGovernancePoliciesClassificationCategoryCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DataEngineGovernancePoliciesClassificationCategoryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineGovernancePoliciesClassificationCategoryCreateDefault creates a DataEngineGovernancePoliciesClassificationCategoryCreateDefault with default headers values
func NewDataEngineGovernancePoliciesClassificationCategoryCreateDefault(code int) *DataEngineGovernancePoliciesClassificationCategoryCreateDefault {
	return &DataEngineGovernancePoliciesClassificationCategoryCreateDefault{
		_statusCode: code,
	}
}

/*
DataEngineGovernancePoliciesClassificationCategoryCreateDefault describes a response with status code -1, with default header values.

Error in creating the category.
*/
type DataEngineGovernancePoliciesClassificationCategoryCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine governance policies classification category create default response has a 2xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine governance policies classification category create default response has a 3xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine governance policies classification category create default response has a 4xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine governance policies classification category create default response has a 5xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine governance policies classification category create default response a status code equal to that given
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine governance policies classification category create default response
func (o *DataEngineGovernancePoliciesClassificationCategoryCreateDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineGovernancePoliciesClassificationCategoryCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/governance/policies/classification/categories][%d] data_engine_governance_policies_classification_category_create default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesClassificationCategoryCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/governance/policies/classification/categories][%d] data_engine_governance_policies_classification_category_create default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesClassificationCategoryCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineGovernancePoliciesClassificationCategoryCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
