// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionReader is a Reader for the DataEngineGovernancePoliciesClassificationCategoryDeleteCollection structure.
type DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK creates a DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK with default headers values
func NewDataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK() *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK {
	return &DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK{}
}

/*
DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK struct {
}

// IsSuccess returns true when this data engine governance policies classification category delete collection o k response has a 2xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine governance policies classification category delete collection o k response has a 3xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine governance policies classification category delete collection o k response has a 4xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine governance policies classification category delete collection o k response has a 5xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine governance policies classification category delete collection o k response a status code equal to that given
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine governance policies classification category delete collection o k response
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK) Code() int {
	return 200
}

func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/governance/policies/classification/categories][%d] dataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK", 200)
}

func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/governance/policies/classification/categories][%d] dataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK", 200)
}

func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault creates a DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault with default headers values
func NewDataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault(code int) *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault {
	return &DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault describes a response with status code -1, with default header values.

Error in deleting the category.
*/
type DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine governance policies classification category delete collection default response has a 2xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine governance policies classification category delete collection default response has a 3xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine governance policies classification category delete collection default response has a 4xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine governance policies classification category delete collection default response has a 5xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine governance policies classification category delete collection default response a status code equal to that given
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine governance policies classification category delete collection default response
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/governance/policies/classification/categories][%d] data_engine_governance_policies_classification_category_delete_collection default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/governance/policies/classification/categories][%d] data_engine_governance_policies_classification_category_delete_collection default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionBody Defines the structure of the response for classification categories.
swagger:model DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionBody
*/
type DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionBody struct {

	// data engine governance policies classification category response inline records
	DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords []*models.DataEngineGovernancePoliciesClassificationCategory `json:"records,omitempty"`

	// The total number of classification categories available.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`
}

// Validate validates this data engine governance policies classification category delete collection body
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionBody) validateDataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords); i++ {
		if swag.IsZero(o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i] != nil {
			if err := o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this data engine governance policies classification category delete collection body based on the context it is used
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionBody) contextValidateDataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords); i++ {

		if o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i] != nil {
			if err := o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesClassificationCategoryDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
