// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionReader is a Reader for the DataEngineGovernancePoliciesClassificationCategoryModifyCollection structure.
type DataEngineGovernancePoliciesClassificationCategoryModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK creates a DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK with default headers values
func NewDataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK() *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK {
	return &DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK{}
}

/*
DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK struct {
}

// IsSuccess returns true when this data engine governance policies classification category modify collection o k response has a 2xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine governance policies classification category modify collection o k response has a 3xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine governance policies classification category modify collection o k response has a 4xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine governance policies classification category modify collection o k response has a 5xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine governance policies classification category modify collection o k response a status code equal to that given
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine governance policies classification category modify collection o k response
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK) Code() int {
	return 200
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /data-engine/governance/policies/classification/categories][%d] dataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK", 200)
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /data-engine/governance/policies/classification/categories][%d] dataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK", 200)
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault creates a DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault with default headers values
func NewDataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault(code int) *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault {
	return &DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault describes a response with status code -1, with default header values.

Error in updating the category.
*/
type DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine governance policies classification category modify collection default response has a 2xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine governance policies classification category modify collection default response has a 3xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine governance policies classification category modify collection default response has a 4xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine governance policies classification category modify collection default response has a 5xx status code
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine governance policies classification category modify collection default response a status code equal to that given
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine governance policies classification category modify collection default response
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/governance/policies/classification/categories][%d] data_engine_governance_policies_classification_category_modify_collection default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/governance/policies/classification/categories][%d] data_engine_governance_policies_classification_category_modify_collection default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody Defines the structure of the response for classification categories.
swagger:model DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody
*/
type DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The timestamp indicating when the category was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Indicates if the classification category is custom or predefined.
	// Example: false
	Custom *bool `json:"custom,omitempty"`

	// data engine governance policies classification category inline classifiers
	DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers []*models.DataEngineGovernancePoliciesClassifier `json:"classifiers,omitempty"`

	// data engine governance policies classification category response inline records
	DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords []*models.DataEngineGovernancePoliciesClassificationCategory `json:"records,omitempty"`

	// Description of the classification category.
	// Example: General privacy classification category
	Description *string `json:"description,omitempty"`

	// Name of the classification category.
	// Example: General privacy
	Name *string `json:"name,omitempty"`

	// State of the classification category. Possible values are:
	// * <i>enabled</i>: Classification category is enabled.
	// * <i>disabled</i>: Classification category is disabled.
	// * <i>simulate</i>: Classification category is in simulation mode.
	//
	// Example: enabled
	// Enum: ["enabled","disabled","simulate"]
	State *string `json:"state,omitempty"`

	// Tag associated with the classification category.
	// Example: CAT_GP00000
	Tag *string `json:"tag,omitempty"`

	// The total number of classification categories available.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`

	// Specifies the type of classification category. Possible values are:
	// * <i>data</i>: Classification category for data entities.
	// * <i>document</i>: Classification category for document entities.
	//
	// Example: data
	// Enum: ["data","document"]
	Type *string `json:"type,omitempty"`

	// The timestamp indicating when the category was last updated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// Unique identifier of the classification category.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance policies classification category modify collection body
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataEngineGovernancePoliciesClassificationCategoryInlineClassifiers(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) validateDataEngineGovernancePoliciesClassificationCategoryInlineClassifiers(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers); i++ {
		if swag.IsZero(o.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers[i]) { // not required
			continue
		}

		if o.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers[i] != nil {
			if err := o.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "classifiers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) validateDataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords); i++ {
		if swag.IsZero(o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i] != nil {
			if err := o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var dataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled","simulate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyTypeStatePropEnum = append(dataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody
	// state
	// State
	// enabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyStateEnabled captures enum value "enabled"
	DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody
	// state
	// State
	// disabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyStateDisabled captures enum value "disabled"
	DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody
	// state
	// State
	// simulate
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyStateSimulate captures enum value "simulate"
	DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyStateSimulate string = "simulate"
)

// prop value enum
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

var dataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","document"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyTypeTypePropEnum = append(dataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody
	// type
	// Type
	// data
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyTypeData captures enum value "data"
	DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyTypeData string = "data"

	// BEGIN DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody
	// type
	// Type
	// document
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyTypeDocument captures enum value "document"
	DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyTypeDocument string = "document"
)

// prop value enum
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesClassificationCategoryModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"update_time", "body", "date-time", o.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance policies classification category modify collection body based on the context it is used
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataEngineGovernancePoliciesClassificationCategoryInlineClassifiers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) contextValidateDataEngineGovernancePoliciesClassificationCategoryInlineClassifiers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers); i++ {

		if o.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers[i] != nil {
			if err := o.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "classifiers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) contextValidateDataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords); i++ {

		if o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i] != nil {
			if err := o.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"update_time", "body", o.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesClassificationCategoryModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
