// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineGovernancePoliciesClassificationClassifierGetReader is a Reader for the DataEngineGovernancePoliciesClassificationClassifierGet structure.
type DataEngineGovernancePoliciesClassificationClassifierGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineGovernancePoliciesClassificationClassifierGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineGovernancePoliciesClassificationClassifierGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineGovernancePoliciesClassificationClassifierGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineGovernancePoliciesClassificationClassifierGetOK creates a DataEngineGovernancePoliciesClassificationClassifierGetOK with default headers values
func NewDataEngineGovernancePoliciesClassificationClassifierGetOK() *DataEngineGovernancePoliciesClassificationClassifierGetOK {
	return &DataEngineGovernancePoliciesClassificationClassifierGetOK{}
}

/*
DataEngineGovernancePoliciesClassificationClassifierGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineGovernancePoliciesClassificationClassifierGetOK struct {
	Payload *models.DataEngineGovernancePoliciesClassificationClassifier
}

// IsSuccess returns true when this data engine governance policies classification classifier get o k response has a 2xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine governance policies classification classifier get o k response has a 3xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine governance policies classification classifier get o k response has a 4xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine governance policies classification classifier get o k response has a 5xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine governance policies classification classifier get o k response a status code equal to that given
func (o *DataEngineGovernancePoliciesClassificationClassifierGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine governance policies classification classifier get o k response
func (o *DataEngineGovernancePoliciesClassificationClassifierGetOK) Code() int {
	return 200
}

func (o *DataEngineGovernancePoliciesClassificationClassifierGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/policies/classification/classifiers/{uuid}][%d] dataEngineGovernancePoliciesClassificationClassifierGetOK %s", 200, payload)
}

func (o *DataEngineGovernancePoliciesClassificationClassifierGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/policies/classification/classifiers/{uuid}][%d] dataEngineGovernancePoliciesClassificationClassifierGetOK %s", 200, payload)
}

func (o *DataEngineGovernancePoliciesClassificationClassifierGetOK) GetPayload() *models.DataEngineGovernancePoliciesClassificationClassifier {
	return o.Payload
}

func (o *DataEngineGovernancePoliciesClassificationClassifierGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineGovernancePoliciesClassificationClassifier)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineGovernancePoliciesClassificationClassifierGetDefault creates a DataEngineGovernancePoliciesClassificationClassifierGetDefault with default headers values
func NewDataEngineGovernancePoliciesClassificationClassifierGetDefault(code int) *DataEngineGovernancePoliciesClassificationClassifierGetDefault {
	return &DataEngineGovernancePoliciesClassificationClassifierGetDefault{
		_statusCode: code,
	}
}

/*
	DataEngineGovernancePoliciesClassificationClassifierGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4 | The specified classifier does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type DataEngineGovernancePoliciesClassificationClassifierGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine governance policies classification classifier get default response has a 2xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine governance policies classification classifier get default response has a 3xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine governance policies classification classifier get default response has a 4xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine governance policies classification classifier get default response has a 5xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine governance policies classification classifier get default response a status code equal to that given
func (o *DataEngineGovernancePoliciesClassificationClassifierGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine governance policies classification classifier get default response
func (o *DataEngineGovernancePoliciesClassificationClassifierGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineGovernancePoliciesClassificationClassifierGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/policies/classification/classifiers/{uuid}][%d] data_engine_governance_policies_classification_classifier_get default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesClassificationClassifierGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/policies/classification/classifiers/{uuid}][%d] data_engine_governance_policies_classification_classifier_get default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesClassificationClassifierGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineGovernancePoliciesClassificationClassifierGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
