// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionReader is a Reader for the DataEngineGovernancePoliciesClassificationClassifierModifyCollection structure.
type DataEngineGovernancePoliciesClassificationClassifierModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK creates a DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK with default headers values
func NewDataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK() *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK {
	return &DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK{}
}

/*
DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK struct {
}

// IsSuccess returns true when this data engine governance policies classification classifier modify collection o k response has a 2xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine governance policies classification classifier modify collection o k response has a 3xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine governance policies classification classifier modify collection o k response has a 4xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine governance policies classification classifier modify collection o k response has a 5xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine governance policies classification classifier modify collection o k response a status code equal to that given
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine governance policies classification classifier modify collection o k response
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK) Code() int {
	return 200
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /data-engine/governance/policies/classification/classifiers][%d] dataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK", 200)
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /data-engine/governance/policies/classification/classifiers][%d] dataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK", 200)
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault creates a DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault with default headers values
func NewDataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault(code int) *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault {
	return &DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault describes a response with status code -1, with default header values.

Error in updating the classifier.
*/
type DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine governance policies classification classifier modify collection default response has a 2xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine governance policies classification classifier modify collection default response has a 3xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine governance policies classification classifier modify collection default response has a 4xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine governance policies classification classifier modify collection default response has a 5xx status code
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine governance policies classification classifier modify collection default response a status code equal to that given
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine governance policies classification classifier modify collection default response
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/governance/policies/classification/classifiers][%d] data_engine_governance_policies_classification_classifier_modify_collection default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/governance/policies/classification/classifiers][%d] data_engine_governance_policies_classification_classifier_modify_collection default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody Defines the structure of the response for classifiers.
swagger:model DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody
*/
type DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The timestamp indicating when the classifier was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Indicates if the classifier is custom or predefined.
	// Example: false
	Custom *bool `json:"custom,omitempty"`

	// data engine governance policies classification classifier response inline records
	DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords []*models.DataEngineGovernancePoliciesClassificationClassifier `json:"records,omitempty"`

	// Description of the classifier.
	// Example: classifier for data subjects(i.e., person names)
	Description *string `json:"description,omitempty"`

	// Name of the classifier.
	// Example: data subjects classifier
	Name *string `json:"name,omitempty"`

	// State of the classifier. Possible values are:
	// * <i>enabled</i>: Classifier is enabled.
	// * <i>disabled</i>: Classifier is disabled.
	// * <i>simulate</i>: Classifier is in simulation mode.
	//
	// Example: enabled
	// Enum: ["enabled","disabled","simulate"]
	State *string `json:"state,omitempty"`

	// Tag associated with the classifier.
	// Example: CLS_ENTD00000
	Tag *string `json:"tag,omitempty"`

	// The total number of classifiers available.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`

	// Specifies the type of classifier. Possible values are:
	// * <i>data</i>: Classifier for data entities.
	// * <i>document</i>: Classifier for document entities.
	//
	// Example: data
	// Enum: ["data","document"]
	Type *string `json:"type,omitempty"`

	// The timestamp indicating when the classifier was last updated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// Unique identifier of the classifier.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance policies classification classifier modify collection body
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) validateDataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords); i++ {
		if swag.IsZero(o.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords[i] != nil {
			if err := o.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var dataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled","simulate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyTypeStatePropEnum = append(dataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody
	// state
	// State
	// enabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyStateEnabled captures enum value "enabled"
	DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody
	// state
	// State
	// disabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyStateDisabled captures enum value "disabled"
	DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody
	// state
	// State
	// simulate
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyStateSimulate captures enum value "simulate"
	DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyStateSimulate string = "simulate"
)

// prop value enum
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

var dataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","document"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyTypeTypePropEnum = append(dataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody
	// type
	// Type
	// data
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyTypeData captures enum value "data"
	DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyTypeData string = "data"

	// BEGIN DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody
	// type
	// Type
	// document
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyTypeDocument captures enum value "document"
	DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyTypeDocument string = "document"
)

// prop value enum
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesClassificationClassifierModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"update_time", "body", "date-time", o.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance policies classification classifier modify collection body based on the context it is used
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) contextValidateDataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords); i++ {

		if o.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords[i] != nil {
			if err := o.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"update_time", "body", o.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesClassificationClassifierModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
