// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineGovernancePoliciesGuardrailCreateReader is a Reader for the DataEngineGovernancePoliciesGuardrailCreate structure.
type DataEngineGovernancePoliciesGuardrailCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineGovernancePoliciesGuardrailCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewDataEngineGovernancePoliciesGuardrailCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineGovernancePoliciesGuardrailCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineGovernancePoliciesGuardrailCreateCreated creates a DataEngineGovernancePoliciesGuardrailCreateCreated with default headers values
func NewDataEngineGovernancePoliciesGuardrailCreateCreated() *DataEngineGovernancePoliciesGuardrailCreateCreated {
	return &DataEngineGovernancePoliciesGuardrailCreateCreated{}
}

/*
DataEngineGovernancePoliciesGuardrailCreateCreated describes a response with status code 201, with default header values.

Created
*/
type DataEngineGovernancePoliciesGuardrailCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DataEngineGovernancePoliciesGuardrailResponse
}

// IsSuccess returns true when this data engine governance policies guardrail create created response has a 2xx status code
func (o *DataEngineGovernancePoliciesGuardrailCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine governance policies guardrail create created response has a 3xx status code
func (o *DataEngineGovernancePoliciesGuardrailCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine governance policies guardrail create created response has a 4xx status code
func (o *DataEngineGovernancePoliciesGuardrailCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine governance policies guardrail create created response has a 5xx status code
func (o *DataEngineGovernancePoliciesGuardrailCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine governance policies guardrail create created response a status code equal to that given
func (o *DataEngineGovernancePoliciesGuardrailCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the data engine governance policies guardrail create created response
func (o *DataEngineGovernancePoliciesGuardrailCreateCreated) Code() int {
	return 201
}

func (o *DataEngineGovernancePoliciesGuardrailCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/governance/policies/guardrails][%d] dataEngineGovernancePoliciesGuardrailCreateCreated %s", 201, payload)
}

func (o *DataEngineGovernancePoliciesGuardrailCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/governance/policies/guardrails][%d] dataEngineGovernancePoliciesGuardrailCreateCreated %s", 201, payload)
}

func (o *DataEngineGovernancePoliciesGuardrailCreateCreated) GetPayload() *models.DataEngineGovernancePoliciesGuardrailResponse {
	return o.Payload
}

func (o *DataEngineGovernancePoliciesGuardrailCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DataEngineGovernancePoliciesGuardrailResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineGovernancePoliciesGuardrailCreateDefault creates a DataEngineGovernancePoliciesGuardrailCreateDefault with default headers values
func NewDataEngineGovernancePoliciesGuardrailCreateDefault(code int) *DataEngineGovernancePoliciesGuardrailCreateDefault {
	return &DataEngineGovernancePoliciesGuardrailCreateDefault{
		_statusCode: code,
	}
}

/*
DataEngineGovernancePoliciesGuardrailCreateDefault describes a response with status code -1, with default header values.

Error in creating the guardrail.
*/
type DataEngineGovernancePoliciesGuardrailCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine governance policies guardrail create default response has a 2xx status code
func (o *DataEngineGovernancePoliciesGuardrailCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine governance policies guardrail create default response has a 3xx status code
func (o *DataEngineGovernancePoliciesGuardrailCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine governance policies guardrail create default response has a 4xx status code
func (o *DataEngineGovernancePoliciesGuardrailCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine governance policies guardrail create default response has a 5xx status code
func (o *DataEngineGovernancePoliciesGuardrailCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine governance policies guardrail create default response a status code equal to that given
func (o *DataEngineGovernancePoliciesGuardrailCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine governance policies guardrail create default response
func (o *DataEngineGovernancePoliciesGuardrailCreateDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineGovernancePoliciesGuardrailCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/governance/policies/guardrails][%d] data_engine_governance_policies_guardrail_create default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesGuardrailCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/governance/policies/guardrails][%d] data_engine_governance_policies_guardrail_create default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesGuardrailCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineGovernancePoliciesGuardrailCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
