// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineGovernancePoliciesGuardrailDeleteCollectionReader is a Reader for the DataEngineGovernancePoliciesGuardrailDeleteCollection structure.
type DataEngineGovernancePoliciesGuardrailDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineGovernancePoliciesGuardrailDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineGovernancePoliciesGuardrailDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineGovernancePoliciesGuardrailDeleteCollectionOK creates a DataEngineGovernancePoliciesGuardrailDeleteCollectionOK with default headers values
func NewDataEngineGovernancePoliciesGuardrailDeleteCollectionOK() *DataEngineGovernancePoliciesGuardrailDeleteCollectionOK {
	return &DataEngineGovernancePoliciesGuardrailDeleteCollectionOK{}
}

/*
DataEngineGovernancePoliciesGuardrailDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineGovernancePoliciesGuardrailDeleteCollectionOK struct {
}

// IsSuccess returns true when this data engine governance policies guardrail delete collection o k response has a 2xx status code
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine governance policies guardrail delete collection o k response has a 3xx status code
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine governance policies guardrail delete collection o k response has a 4xx status code
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine governance policies guardrail delete collection o k response has a 5xx status code
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine governance policies guardrail delete collection o k response a status code equal to that given
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine governance policies guardrail delete collection o k response
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionOK) Code() int {
	return 200
}

func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/governance/policies/guardrails][%d] dataEngineGovernancePoliciesGuardrailDeleteCollectionOK", 200)
}

func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/governance/policies/guardrails][%d] dataEngineGovernancePoliciesGuardrailDeleteCollectionOK", 200)
}

func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDataEngineGovernancePoliciesGuardrailDeleteCollectionDefault creates a DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault with default headers values
func NewDataEngineGovernancePoliciesGuardrailDeleteCollectionDefault(code int) *DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault {
	return &DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault describes a response with status code -1, with default header values.

Error in deleting the guardrail.
*/
type DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine governance policies guardrail delete collection default response has a 2xx status code
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine governance policies guardrail delete collection default response has a 3xx status code
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine governance policies guardrail delete collection default response has a 4xx status code
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine governance policies guardrail delete collection default response has a 5xx status code
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine governance policies guardrail delete collection default response a status code equal to that given
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine governance policies guardrail delete collection default response
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/governance/policies/guardrails][%d] data_engine_governance_policies_guardrail_delete_collection default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/governance/policies/guardrails][%d] data_engine_governance_policies_guardrail_delete_collection default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DataEngineGovernancePoliciesGuardrailDeleteCollectionBody Defines the structure of the response for guardrails.
swagger:model DataEngineGovernancePoliciesGuardrailDeleteCollectionBody
*/
type DataEngineGovernancePoliciesGuardrailDeleteCollectionBody struct {

	// data engine governance policies guardrail response inline records
	DataEngineGovernancePoliciesGuardrailResponseInlineRecords []*models.DataEngineGovernancePoliciesGuardrail `json:"records,omitempty"`

	// The total number of guardrails available.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`
}

// Validate validates this data engine governance policies guardrail delete collection body
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDataEngineGovernancePoliciesGuardrailResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionBody) validateDataEngineGovernancePoliciesGuardrailResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords); i++ {
		if swag.IsZero(o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords[i] != nil {
			if err := o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this data engine governance policies guardrail delete collection body based on the context it is used
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDataEngineGovernancePoliciesGuardrailResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionBody) contextValidateDataEngineGovernancePoliciesGuardrailResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords); i++ {

		if o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords[i] != nil {
			if err := o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesGuardrailDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesGuardrailDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
