// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineGovernancePoliciesGuardrailGetReader is a Reader for the DataEngineGovernancePoliciesGuardrailGet structure.
type DataEngineGovernancePoliciesGuardrailGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineGovernancePoliciesGuardrailGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineGovernancePoliciesGuardrailGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineGovernancePoliciesGuardrailGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineGovernancePoliciesGuardrailGetOK creates a DataEngineGovernancePoliciesGuardrailGetOK with default headers values
func NewDataEngineGovernancePoliciesGuardrailGetOK() *DataEngineGovernancePoliciesGuardrailGetOK {
	return &DataEngineGovernancePoliciesGuardrailGetOK{}
}

/*
DataEngineGovernancePoliciesGuardrailGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineGovernancePoliciesGuardrailGetOK struct {
	Payload *models.DataEngineGovernancePoliciesGuardrail
}

// IsSuccess returns true when this data engine governance policies guardrail get o k response has a 2xx status code
func (o *DataEngineGovernancePoliciesGuardrailGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine governance policies guardrail get o k response has a 3xx status code
func (o *DataEngineGovernancePoliciesGuardrailGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine governance policies guardrail get o k response has a 4xx status code
func (o *DataEngineGovernancePoliciesGuardrailGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine governance policies guardrail get o k response has a 5xx status code
func (o *DataEngineGovernancePoliciesGuardrailGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine governance policies guardrail get o k response a status code equal to that given
func (o *DataEngineGovernancePoliciesGuardrailGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine governance policies guardrail get o k response
func (o *DataEngineGovernancePoliciesGuardrailGetOK) Code() int {
	return 200
}

func (o *DataEngineGovernancePoliciesGuardrailGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/policies/guardrails/{uuid}][%d] dataEngineGovernancePoliciesGuardrailGetOK %s", 200, payload)
}

func (o *DataEngineGovernancePoliciesGuardrailGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/policies/guardrails/{uuid}][%d] dataEngineGovernancePoliciesGuardrailGetOK %s", 200, payload)
}

func (o *DataEngineGovernancePoliciesGuardrailGetOK) GetPayload() *models.DataEngineGovernancePoliciesGuardrail {
	return o.Payload
}

func (o *DataEngineGovernancePoliciesGuardrailGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineGovernancePoliciesGuardrail)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineGovernancePoliciesGuardrailGetDefault creates a DataEngineGovernancePoliciesGuardrailGetDefault with default headers values
func NewDataEngineGovernancePoliciesGuardrailGetDefault(code int) *DataEngineGovernancePoliciesGuardrailGetDefault {
	return &DataEngineGovernancePoliciesGuardrailGetDefault{
		_statusCode: code,
	}
}

/*
	DataEngineGovernancePoliciesGuardrailGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4 | The specified guardrail does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type DataEngineGovernancePoliciesGuardrailGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine governance policies guardrail get default response has a 2xx status code
func (o *DataEngineGovernancePoliciesGuardrailGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine governance policies guardrail get default response has a 3xx status code
func (o *DataEngineGovernancePoliciesGuardrailGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine governance policies guardrail get default response has a 4xx status code
func (o *DataEngineGovernancePoliciesGuardrailGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine governance policies guardrail get default response has a 5xx status code
func (o *DataEngineGovernancePoliciesGuardrailGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine governance policies guardrail get default response a status code equal to that given
func (o *DataEngineGovernancePoliciesGuardrailGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine governance policies guardrail get default response
func (o *DataEngineGovernancePoliciesGuardrailGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineGovernancePoliciesGuardrailGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/policies/guardrails/{uuid}][%d] data_engine_governance_policies_guardrail_get default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesGuardrailGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/governance/policies/guardrails/{uuid}][%d] data_engine_governance_policies_guardrail_get default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesGuardrailGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineGovernancePoliciesGuardrailGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
