// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineGovernancePoliciesGuardrailModifyCollectionReader is a Reader for the DataEngineGovernancePoliciesGuardrailModifyCollection structure.
type DataEngineGovernancePoliciesGuardrailModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineGovernancePoliciesGuardrailModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineGovernancePoliciesGuardrailModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineGovernancePoliciesGuardrailModifyCollectionOK creates a DataEngineGovernancePoliciesGuardrailModifyCollectionOK with default headers values
func NewDataEngineGovernancePoliciesGuardrailModifyCollectionOK() *DataEngineGovernancePoliciesGuardrailModifyCollectionOK {
	return &DataEngineGovernancePoliciesGuardrailModifyCollectionOK{}
}

/*
DataEngineGovernancePoliciesGuardrailModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineGovernancePoliciesGuardrailModifyCollectionOK struct {
}

// IsSuccess returns true when this data engine governance policies guardrail modify collection o k response has a 2xx status code
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine governance policies guardrail modify collection o k response has a 3xx status code
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine governance policies guardrail modify collection o k response has a 4xx status code
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine governance policies guardrail modify collection o k response has a 5xx status code
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine governance policies guardrail modify collection o k response a status code equal to that given
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine governance policies guardrail modify collection o k response
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionOK) Code() int {
	return 200
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /data-engine/governance/policies/guardrails][%d] dataEngineGovernancePoliciesGuardrailModifyCollectionOK", 200)
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /data-engine/governance/policies/guardrails][%d] dataEngineGovernancePoliciesGuardrailModifyCollectionOK", 200)
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDataEngineGovernancePoliciesGuardrailModifyCollectionDefault creates a DataEngineGovernancePoliciesGuardrailModifyCollectionDefault with default headers values
func NewDataEngineGovernancePoliciesGuardrailModifyCollectionDefault(code int) *DataEngineGovernancePoliciesGuardrailModifyCollectionDefault {
	return &DataEngineGovernancePoliciesGuardrailModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
DataEngineGovernancePoliciesGuardrailModifyCollectionDefault describes a response with status code -1, with default header values.

Error in updating the guardrail.
*/
type DataEngineGovernancePoliciesGuardrailModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine governance policies guardrail modify collection default response has a 2xx status code
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine governance policies guardrail modify collection default response has a 3xx status code
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine governance policies guardrail modify collection default response has a 4xx status code
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine governance policies guardrail modify collection default response has a 5xx status code
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine governance policies guardrail modify collection default response a status code equal to that given
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine governance policies guardrail modify collection default response
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/governance/policies/guardrails][%d] data_engine_governance_policies_guardrail_modify_collection default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/governance/policies/guardrails][%d] data_engine_governance_policies_guardrail_modify_collection default %s", o._statusCode, payload)
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DataEngineGovernancePoliciesGuardrailModifyCollectionBody Defines the structure of the response for guardrails.
swagger:model DataEngineGovernancePoliciesGuardrailModifyCollectionBody
*/
type DataEngineGovernancePoliciesGuardrailModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The timestamp indicating when the guardrail was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// List of actions associated with the guardrail.
	DataEngineGovernancePoliciesGuardrailInlineActions []*models.DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem `json:"actions,omitempty"`

	// List of conditions associated with the guardrail.
	DataEngineGovernancePoliciesGuardrailInlineConditions []*models.DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem `json:"conditions,omitempty"`

	// List of classifier or category tags which has issues.
	DataEngineGovernancePoliciesGuardrailInlineIssueTags []*models.DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem `json:"issue_tags,omitempty"`

	// List of workspaces associated with the guardrail.
	DataEngineGovernancePoliciesGuardrailInlineWorkspaces []*models.DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem `json:"workspaces,omitempty"`

	// data engine governance policies guardrail response inline records
	DataEngineGovernancePoliciesGuardrailResponseInlineRecords []*models.DataEngineGovernancePoliciesGuardrail `json:"records,omitempty"`

	// Description of the guardrail.
	// Example: exclude credit card number from data
	Description *string `json:"description,omitempty"`

	// Indicates if the guardrail has any issues.
	// Example: false
	// Read Only: true
	HasIssue *bool `json:"has_issue,omitempty"`

	// The number of files impacted by the guardrail.
	// Example: 100
	// Read Only: true
	ImpactedFilesCount *int64 `json:"impacted_files_count,omitempty"`

	// Name of the guardrail.
	// Example: exclude credit card number
	Name *string `json:"name,omitempty"`

	// State of the guardrail. Possible values are:
	// * <i>enabled</i>: Guardrail is enabled.
	// * <i>disabled</i>: Guardrail is disabled.
	// * <i>simulate</i>: Guardrail is in simulation mode.
	//
	// Example: enabled
	// Enum: ["enabled","disabled","simulate"]
	State *string `json:"state,omitempty"`

	// The total number of guardrails available.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`

	// The timestamp indicating when the guardrail was last updated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// UUID of the guardrail.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance policies guardrail modify collection body
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataEngineGovernancePoliciesGuardrailInlineActions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataEngineGovernancePoliciesGuardrailInlineConditions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataEngineGovernancePoliciesGuardrailInlineIssueTags(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataEngineGovernancePoliciesGuardrailInlineWorkspaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataEngineGovernancePoliciesGuardrailResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) validateDataEngineGovernancePoliciesGuardrailInlineActions(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEngineGovernancePoliciesGuardrailInlineActions) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEngineGovernancePoliciesGuardrailInlineActions); i++ {
		if swag.IsZero(o.DataEngineGovernancePoliciesGuardrailInlineActions[i]) { // not required
			continue
		}

		if o.DataEngineGovernancePoliciesGuardrailInlineActions[i] != nil {
			if err := o.DataEngineGovernancePoliciesGuardrailInlineActions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "actions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) validateDataEngineGovernancePoliciesGuardrailInlineConditions(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEngineGovernancePoliciesGuardrailInlineConditions) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEngineGovernancePoliciesGuardrailInlineConditions); i++ {
		if swag.IsZero(o.DataEngineGovernancePoliciesGuardrailInlineConditions[i]) { // not required
			continue
		}

		if o.DataEngineGovernancePoliciesGuardrailInlineConditions[i] != nil {
			if err := o.DataEngineGovernancePoliciesGuardrailInlineConditions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) validateDataEngineGovernancePoliciesGuardrailInlineIssueTags(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEngineGovernancePoliciesGuardrailInlineIssueTags) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEngineGovernancePoliciesGuardrailInlineIssueTags); i++ {
		if swag.IsZero(o.DataEngineGovernancePoliciesGuardrailInlineIssueTags[i]) { // not required
			continue
		}

		if o.DataEngineGovernancePoliciesGuardrailInlineIssueTags[i] != nil {
			if err := o.DataEngineGovernancePoliciesGuardrailInlineIssueTags[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "issue_tags" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) validateDataEngineGovernancePoliciesGuardrailInlineWorkspaces(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEngineGovernancePoliciesGuardrailInlineWorkspaces) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEngineGovernancePoliciesGuardrailInlineWorkspaces); i++ {
		if swag.IsZero(o.DataEngineGovernancePoliciesGuardrailInlineWorkspaces[i]) { // not required
			continue
		}

		if o.DataEngineGovernancePoliciesGuardrailInlineWorkspaces[i] != nil {
			if err := o.DataEngineGovernancePoliciesGuardrailInlineWorkspaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "workspaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) validateDataEngineGovernancePoliciesGuardrailResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords); i++ {
		if swag.IsZero(o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords[i] != nil {
			if err := o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var dataEngineGovernancePoliciesGuardrailModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled","simulate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesGuardrailModifyCollectionBodyTypeStatePropEnum = append(dataEngineGovernancePoliciesGuardrailModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DataEngineGovernancePoliciesGuardrailModifyCollectionBody
	// DataEngineGovernancePoliciesGuardrailModifyCollectionBody
	// state
	// State
	// enabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailModifyCollectionBodyStateEnabled captures enum value "enabled"
	DataEngineGovernancePoliciesGuardrailModifyCollectionBodyStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// DataEngineGovernancePoliciesGuardrailModifyCollectionBody
	// DataEngineGovernancePoliciesGuardrailModifyCollectionBody
	// state
	// State
	// disabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailModifyCollectionBodyStateDisabled captures enum value "disabled"
	DataEngineGovernancePoliciesGuardrailModifyCollectionBodyStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// DataEngineGovernancePoliciesGuardrailModifyCollectionBody
	// DataEngineGovernancePoliciesGuardrailModifyCollectionBody
	// state
	// State
	// simulate
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailModifyCollectionBodyStateSimulate captures enum value "simulate"
	DataEngineGovernancePoliciesGuardrailModifyCollectionBodyStateSimulate string = "simulate"
)

// prop value enum
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesGuardrailModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"update_time", "body", "date-time", o.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance policies guardrail modify collection body based on the context it is used
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataEngineGovernancePoliciesGuardrailInlineActions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataEngineGovernancePoliciesGuardrailInlineConditions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataEngineGovernancePoliciesGuardrailInlineIssueTags(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataEngineGovernancePoliciesGuardrailInlineWorkspaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataEngineGovernancePoliciesGuardrailResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHasIssue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateImpactedFilesCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) contextValidateDataEngineGovernancePoliciesGuardrailInlineActions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEngineGovernancePoliciesGuardrailInlineActions); i++ {

		if o.DataEngineGovernancePoliciesGuardrailInlineActions[i] != nil {
			if err := o.DataEngineGovernancePoliciesGuardrailInlineActions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "actions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) contextValidateDataEngineGovernancePoliciesGuardrailInlineConditions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEngineGovernancePoliciesGuardrailInlineConditions); i++ {

		if o.DataEngineGovernancePoliciesGuardrailInlineConditions[i] != nil {
			if err := o.DataEngineGovernancePoliciesGuardrailInlineConditions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) contextValidateDataEngineGovernancePoliciesGuardrailInlineIssueTags(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEngineGovernancePoliciesGuardrailInlineIssueTags); i++ {

		if o.DataEngineGovernancePoliciesGuardrailInlineIssueTags[i] != nil {
			if err := o.DataEngineGovernancePoliciesGuardrailInlineIssueTags[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "issue_tags" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) contextValidateDataEngineGovernancePoliciesGuardrailInlineWorkspaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEngineGovernancePoliciesGuardrailInlineWorkspaces); i++ {

		if o.DataEngineGovernancePoliciesGuardrailInlineWorkspaces[i] != nil {
			if err := o.DataEngineGovernancePoliciesGuardrailInlineWorkspaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "workspaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) contextValidateDataEngineGovernancePoliciesGuardrailResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords); i++ {

		if o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords[i] != nil {
			if err := o.DataEngineGovernancePoliciesGuardrailResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) contextValidateHasIssue(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"has_issue", "body", o.HasIssue); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) contextValidateImpactedFilesCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"impacted_files_count", "body", o.ImpactedFilesCount); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"update_time", "body", o.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesGuardrailModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesGuardrailModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem data engine governance policies guardrail inline actions inline array item
swagger:model data_engine_governance_policies_guardrail_inline_actions_inline_array_item
*/
type DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem struct {

	// specifies type of action. Possible values are:
	// * <i>exclude</i>: Exclude data.
	// * <i>exclude_pre_existing</i>: Exclude pre-existing data.
	// * <i>anonymize</i>: Anonymize data.
	//
	// Example: exclude
	// Enum: ["exclude","exclude_pre_existing","anonymize"]
	ActionType *string `json:"action_type,omitempty"`
}

// Validate validates this data engine governance policies guardrail inline actions inline array item
func (o *DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateActionType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemTypeActionTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["exclude","exclude_pre_existing","anonymize"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemTypeActionTypePropEnum = append(dataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemTypeActionTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_actions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem
	// action_type
	// ActionType
	// exclude
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemActionTypeExclude captures enum value "exclude"
	DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemActionTypeExclude string = "exclude"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_actions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem
	// action_type
	// ActionType
	// exclude_pre_existing
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemActionTypeExcludePreExisting captures enum value "exclude_pre_existing"
	DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemActionTypeExcludePreExisting string = "exclude_pre_existing"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_actions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem
	// action_type
	// ActionType
	// anonymize
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemActionTypeAnonymize captures enum value "anonymize"
	DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemActionTypeAnonymize string = "anonymize"
)

// prop value enum
func (o *DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem) validateActionTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemTypeActionTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem) validateActionType(formats strfmt.Registry) error {
	if swag.IsZero(o.ActionType) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionTypeEnum("action_type", "body", *o.ActionType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this data engine governance policies guardrail inline actions inline array item based on context it is used
func (o *DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem data engine governance policies guardrail inline conditions inline array item
swagger:model data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
*/
type DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem struct {

	// List of classifier or category tags associated with the condition.
	Items []*string `json:"items"`

	// specifies operator for condition. Possible values are:
	// * <i>all</i>: All conditions must be met.
	// * <i>any</i>: Any one of the conditions must be met.
	//
	// Example: all
	// Enum: ["all","any"]
	Operator *string `json:"operator,omitempty"`

	// specifies type of condition. Possible values are:
	// * <i>data_classifier_category</i>: Condition based on data classifier category.
	// * <i>document_classifier_category</i>: Condition based on document classifier category.
	// * <i>data_classifier</i>: Condition based on data classifier.
	// * <i>document_classifier</i>: Condition based on document classifier.
	//
	// Example: data_classifier_category
	// Enum: ["data_classifier_category","document_classifier_category","data_classifier","document_classifier"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this data engine governance policies guardrail inline conditions inline array item
func (o *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateOperator(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeOperatorPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","any"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeOperatorPropEnum = append(dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeOperatorPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	// operator
	// Operator
	// all
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemOperatorAll captures enum value "all"
	DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemOperatorAll string = "all"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	// operator
	// Operator
	// any
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemOperatorAny captures enum value "any"
	DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemOperatorAny string = "any"
)

// prop value enum
func (o *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) validateOperatorEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeOperatorPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) validateOperator(formats strfmt.Registry) error {
	if swag.IsZero(o.Operator) { // not required
		return nil
	}

	// value enum
	if err := o.validateOperatorEnum("operator", "body", *o.Operator); err != nil {
		return err
	}

	return nil
}

var dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data_classifier_category","document_classifier_category","data_classifier","document_classifier"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeTypePropEnum = append(dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	// type
	// Type
	// data_classifier_category
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDataClassifierCategory captures enum value "data_classifier_category"
	DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDataClassifierCategory string = "data_classifier_category"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	// type
	// Type
	// document_classifier_category
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDocumentClassifierCategory captures enum value "document_classifier_category"
	DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDocumentClassifierCategory string = "document_classifier_category"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	// type
	// Type
	// data_classifier
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDataClassifier captures enum value "data_classifier"
	DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDataClassifier string = "data_classifier"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	// type
	// Type
	// document_classifier
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDocumentClassifier captures enum value "document_classifier"
	DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDocumentClassifier string = "document_classifier"
)

// prop value enum
func (o *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this data engine governance policies guardrail inline conditions inline array item based on context it is used
func (o *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem data engine governance policies guardrail inline issue tags inline array item
swagger:model data_engine_governance_policies_guardrail_inline_issue_tags_inline_array_item
*/
type DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem struct {

	// Type of the tag. Possible values are:
	// * <i>data_classifier</i>: Data classifier tag.
	// * <i>document_classifier</i>: Document classifier tag.
	// * <i>data_classifier_category</i>: Data classifier category tag.
	// * <i>document_classifier_category</i>: Document classifier category tag.
	//
	// Example: data_classifier
	// Read Only: true
	// Enum: ["data_classifier","document_classifier","data_classifier_category","document_classifier_category"]
	ClassificationType *string `json:"classification_type,omitempty"`

	// Tag of the classifier or category.
	// Example: CLS_ENTD00000
	// Read Only: true
	Tag *string `json:"tag,omitempty"`
}

// Validate validates this data engine governance policies guardrail inline issue tags inline array item
func (o *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateClassificationType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemTypeClassificationTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data_classifier","document_classifier","data_classifier_category","document_classifier_category"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemTypeClassificationTypePropEnum = append(dataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemTypeClassificationTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_issue_tags_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem
	// classification_type
	// ClassificationType
	// data_classifier
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDataClassifier captures enum value "data_classifier"
	DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDataClassifier string = "data_classifier"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_issue_tags_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem
	// classification_type
	// ClassificationType
	// document_classifier
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDocumentClassifier captures enum value "document_classifier"
	DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDocumentClassifier string = "document_classifier"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_issue_tags_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem
	// classification_type
	// ClassificationType
	// data_classifier_category
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDataClassifierCategory captures enum value "data_classifier_category"
	DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDataClassifierCategory string = "data_classifier_category"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_issue_tags_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem
	// classification_type
	// ClassificationType
	// document_classifier_category
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDocumentClassifierCategory captures enum value "document_classifier_category"
	DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDocumentClassifierCategory string = "document_classifier_category"
)

// prop value enum
func (o *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) validateClassificationTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemTypeClassificationTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) validateClassificationType(formats strfmt.Registry) error {
	if swag.IsZero(o.ClassificationType) { // not required
		return nil
	}

	// value enum
	if err := o.validateClassificationTypeEnum("classification_type", "body", *o.ClassificationType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance policies guardrail inline issue tags inline array item based on the context it is used
func (o *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateClassificationType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTag(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) contextValidateClassificationType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "classification_type", "body", o.ClassificationType); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) contextValidateTag(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tag", "body", o.Tag); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem data engine governance policies guardrail inline workspaces inline array item
swagger:model data_engine_governance_policies_guardrail_inline_workspaces_inline_array_item
*/
type DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem struct {

	// Name of the workspace.
	// Example: workspace1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// UUID of the workspace.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance policies guardrail inline workspaces inline array item
func (o *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance policies guardrail inline workspaces inline array item based on the context it is used
func (o *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
