// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineJobCollectionGetParams creates a new DataEngineJobCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineJobCollectionGetParams() *DataEngineJobCollectionGetParams {
	return &DataEngineJobCollectionGetParams{
		requestTimeout: cr.DefaultTimeout,
	}
}

// NewDataEngineJobCollectionGetParamsWithTimeout creates a new DataEngineJobCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDataEngineJobCollectionGetParamsWithTimeout(timeout time.Duration) *DataEngineJobCollectionGetParams {
	return &DataEngineJobCollectionGetParams{
		requestTimeout: timeout,
	}
}

// NewDataEngineJobCollectionGetParamsWithContext creates a new DataEngineJobCollectionGetParams object
// with the ability to set a context for a request.
func NewDataEngineJobCollectionGetParamsWithContext(ctx context.Context) *DataEngineJobCollectionGetParams {
	return &DataEngineJobCollectionGetParams{
		Context: ctx,
	}
}

// NewDataEngineJobCollectionGetParamsWithHTTPClient creates a new DataEngineJobCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineJobCollectionGetParamsWithHTTPClient(client *http.Client) *DataEngineJobCollectionGetParams {
	return &DataEngineJobCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DataEngineJobCollectionGetParams contains all the parameters to send to the API endpoint

	for the data engine job collection get operation.

	Typically these are written to a http.Request.
*/
type DataEngineJobCollectionGetParams struct {

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Description.

	   Filter by description
	*/
	Description *string

	/* EndTime.

	   Filter by end_time
	*/
	EndTime *string

	/* ErrorCode.

	   Filter by error.code
	*/
	ErrorCode *string

	/* ErrorMessage.

	   Filter by error.message
	*/
	ErrorMessage *string

	/* ErrorTarget.

	   Filter by error.target
	*/
	ErrorTarget *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ParentJobUUID.

	   Filter by parent_job.uuid
	*/
	ParentJobUUID *string

	/* PercentComplete.

	   Filter by percent_complete
	*/
	PercentComplete *int64

	/* ResourceName.

	   Filter by resource.name
	*/
	ResourceName *string

	/* ResourceType.

	   Filter by resource.type
	*/
	ResourceType *string

	/* ResourceUUID.

	   Filter by resource.uuid
	*/
	ResourceUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* StartTime.

	   Filter by start_time
	*/
	StartTime *string

	/* State.

	   Filter by state
	*/
	State *string

	/* SubJobsCreateTime.

	   Filter by sub_jobs.create_time
	*/
	SubJobsCreateTime *string

	/* SubJobsDescription.

	   Filter by sub_jobs.description
	*/
	SubJobsDescription *string

	/* SubJobsEndTime.

	   Filter by sub_jobs.end_time
	*/
	SubJobsEndTime *string

	/* SubJobsErrorCode.

	   Filter by sub_jobs.error.code
	*/
	SubJobsErrorCode *string

	/* SubJobsErrorMessage.

	   Filter by sub_jobs.error.message
	*/
	SubJobsErrorMessage *string

	/* SubJobsErrorTarget.

	   Filter by sub_jobs.error.target
	*/
	SubJobsErrorTarget *string

	/* SubJobsName.

	   Filter by sub_jobs.name
	*/
	SubJobsName *string

	/* SubJobsParentJobUUID.

	   Filter by sub_jobs.parent_job.uuid
	*/
	SubJobsParentJobUUID *string

	/* SubJobsPercentComplete.

	   Filter by sub_jobs.percent_complete
	*/
	SubJobsPercentComplete *int64

	/* SubJobsResourceName.

	   Filter by sub_jobs.resource.name
	*/
	SubJobsResourceName *string

	/* SubJobsResourceType.

	   Filter by sub_jobs.resource.type
	*/
	SubJobsResourceType *string

	/* SubJobsResourceUUID.

	   Filter by sub_jobs.resource.uuid
	*/
	SubJobsResourceUUID *string

	/* SubJobsStartTime.

	   Filter by sub_jobs.start_time
	*/
	SubJobsStartTime *string

	/* SubJobsState.

	   Filter by sub_jobs.state
	*/
	SubJobsState *string

	/* SubJobsTags.

	   Filter by sub_jobs.tags
	*/
	SubJobsTags *string

	/* SubJobsTimeout.

	   Filter by sub_jobs.timeout
	*/
	SubJobsTimeout *int64

	/* SubJobsType.

	   Filter by sub_jobs.type
	*/
	SubJobsType *string

	/* SubJobsUpdateTime.

	   Filter by sub_jobs.update_time
	*/
	SubJobsUpdateTime *string

	/* SubJobsUUID.

	   Filter by sub_jobs.uuid
	*/
	SubJobsUUID *string

	/* Tags.

	   Filter by tags
	*/
	Tags *string

	/* Timeout.

	   Filter by timeout
	*/
	Timeout *int64

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UpdateTime.

	   Filter by update_time
	*/
	UpdateTime *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	requestTimeout time.Duration
	Context        context.Context
	HTTPClient     *http.Client
}

// WithDefaults hydrates default values in the data engine job collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineJobCollectionGetParams) WithDefaults() *DataEngineJobCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine job collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineJobCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DataEngineJobCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.requestTimeout = o.requestTimeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithRequestTimeout adds the timeout to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithRequestTimeout(timeout time.Duration) *DataEngineJobCollectionGetParams {
	o.SetRequestTimeout(timeout)
	return o
}

// SetRequestTimeout adds the timeout to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetRequestTimeout(timeout time.Duration) {
	o.requestTimeout = timeout
}

// WithContext adds the context to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithContext(ctx context.Context) *DataEngineJobCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithHTTPClient(client *http.Client) *DataEngineJobCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCreateTime adds the createTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithCreateTime(createTime *string) *DataEngineJobCollectionGetParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithDescription adds the description to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithDescription(description *string) *DataEngineJobCollectionGetParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetDescription(description *string) {
	o.Description = description
}

// WithEndTime adds the endTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithEndTime(endTime *string) *DataEngineJobCollectionGetParams {
	o.SetEndTime(endTime)
	return o
}

// SetEndTime adds the endTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetEndTime(endTime *string) {
	o.EndTime = endTime
}

// WithErrorCode adds the errorCode to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithErrorCode(errorCode *string) *DataEngineJobCollectionGetParams {
	o.SetErrorCode(errorCode)
	return o
}

// SetErrorCode adds the errorCode to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetErrorCode(errorCode *string) {
	o.ErrorCode = errorCode
}

// WithErrorMessage adds the errorMessage to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithErrorMessage(errorMessage *string) *DataEngineJobCollectionGetParams {
	o.SetErrorMessage(errorMessage)
	return o
}

// SetErrorMessage adds the errorMessage to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetErrorMessage(errorMessage *string) {
	o.ErrorMessage = errorMessage
}

// WithErrorTarget adds the errorTarget to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithErrorTarget(errorTarget *string) *DataEngineJobCollectionGetParams {
	o.SetErrorTarget(errorTarget)
	return o
}

// SetErrorTarget adds the errorTarget to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetErrorTarget(errorTarget *string) {
	o.ErrorTarget = errorTarget
}

// WithFields adds the fields to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithFields(fields []string) *DataEngineJobCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithMaxRecords(maxRecords *int64) *DataEngineJobCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithName(name *string) *DataEngineJobCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithOrderBy(orderBy []string) *DataEngineJobCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithParentJobUUID adds the parentJobUUID to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithParentJobUUID(parentJobUUID *string) *DataEngineJobCollectionGetParams {
	o.SetParentJobUUID(parentJobUUID)
	return o
}

// SetParentJobUUID adds the parentJobUuid to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetParentJobUUID(parentJobUUID *string) {
	o.ParentJobUUID = parentJobUUID
}

// WithPercentComplete adds the percentComplete to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithPercentComplete(percentComplete *int64) *DataEngineJobCollectionGetParams {
	o.SetPercentComplete(percentComplete)
	return o
}

// SetPercentComplete adds the percentComplete to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetPercentComplete(percentComplete *int64) {
	o.PercentComplete = percentComplete
}

// WithResourceName adds the resourceName to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithResourceName(resourceName *string) *DataEngineJobCollectionGetParams {
	o.SetResourceName(resourceName)
	return o
}

// SetResourceName adds the resourceName to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetResourceName(resourceName *string) {
	o.ResourceName = resourceName
}

// WithResourceType adds the resourceType to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithResourceType(resourceType *string) *DataEngineJobCollectionGetParams {
	o.SetResourceType(resourceType)
	return o
}

// SetResourceType adds the resourceType to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetResourceType(resourceType *string) {
	o.ResourceType = resourceType
}

// WithResourceUUID adds the resourceUUID to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithResourceUUID(resourceUUID *string) *DataEngineJobCollectionGetParams {
	o.SetResourceUUID(resourceUUID)
	return o
}

// SetResourceUUID adds the resourceUuid to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetResourceUUID(resourceUUID *string) {
	o.ResourceUUID = resourceUUID
}

// WithReturnRecords adds the returnRecords to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithReturnRecords(returnRecords *bool) *DataEngineJobCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DataEngineJobCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithStartTime adds the startTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithStartTime(startTime *string) *DataEngineJobCollectionGetParams {
	o.SetStartTime(startTime)
	return o
}

// SetStartTime adds the startTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetStartTime(startTime *string) {
	o.StartTime = startTime
}

// WithState adds the state to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithState(state *string) *DataEngineJobCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithSubJobsCreateTime adds the subJobsCreateTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsCreateTime(subJobsCreateTime *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsCreateTime(subJobsCreateTime)
	return o
}

// SetSubJobsCreateTime adds the subJobsCreateTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsCreateTime(subJobsCreateTime *string) {
	o.SubJobsCreateTime = subJobsCreateTime
}

// WithSubJobsDescription adds the subJobsDescription to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsDescription(subJobsDescription *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsDescription(subJobsDescription)
	return o
}

// SetSubJobsDescription adds the subJobsDescription to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsDescription(subJobsDescription *string) {
	o.SubJobsDescription = subJobsDescription
}

// WithSubJobsEndTime adds the subJobsEndTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsEndTime(subJobsEndTime *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsEndTime(subJobsEndTime)
	return o
}

// SetSubJobsEndTime adds the subJobsEndTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsEndTime(subJobsEndTime *string) {
	o.SubJobsEndTime = subJobsEndTime
}

// WithSubJobsErrorCode adds the subJobsErrorCode to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsErrorCode(subJobsErrorCode *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsErrorCode(subJobsErrorCode)
	return o
}

// SetSubJobsErrorCode adds the subJobsErrorCode to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsErrorCode(subJobsErrorCode *string) {
	o.SubJobsErrorCode = subJobsErrorCode
}

// WithSubJobsErrorMessage adds the subJobsErrorMessage to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsErrorMessage(subJobsErrorMessage *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsErrorMessage(subJobsErrorMessage)
	return o
}

// SetSubJobsErrorMessage adds the subJobsErrorMessage to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsErrorMessage(subJobsErrorMessage *string) {
	o.SubJobsErrorMessage = subJobsErrorMessage
}

// WithSubJobsErrorTarget adds the subJobsErrorTarget to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsErrorTarget(subJobsErrorTarget *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsErrorTarget(subJobsErrorTarget)
	return o
}

// SetSubJobsErrorTarget adds the subJobsErrorTarget to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsErrorTarget(subJobsErrorTarget *string) {
	o.SubJobsErrorTarget = subJobsErrorTarget
}

// WithSubJobsName adds the subJobsName to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsName(subJobsName *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsName(subJobsName)
	return o
}

// SetSubJobsName adds the subJobsName to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsName(subJobsName *string) {
	o.SubJobsName = subJobsName
}

// WithSubJobsParentJobUUID adds the subJobsParentJobUUID to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsParentJobUUID(subJobsParentJobUUID *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsParentJobUUID(subJobsParentJobUUID)
	return o
}

// SetSubJobsParentJobUUID adds the subJobsParentJobUuid to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsParentJobUUID(subJobsParentJobUUID *string) {
	o.SubJobsParentJobUUID = subJobsParentJobUUID
}

// WithSubJobsPercentComplete adds the subJobsPercentComplete to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsPercentComplete(subJobsPercentComplete *int64) *DataEngineJobCollectionGetParams {
	o.SetSubJobsPercentComplete(subJobsPercentComplete)
	return o
}

// SetSubJobsPercentComplete adds the subJobsPercentComplete to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsPercentComplete(subJobsPercentComplete *int64) {
	o.SubJobsPercentComplete = subJobsPercentComplete
}

// WithSubJobsResourceName adds the subJobsResourceName to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsResourceName(subJobsResourceName *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsResourceName(subJobsResourceName)
	return o
}

// SetSubJobsResourceName adds the subJobsResourceName to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsResourceName(subJobsResourceName *string) {
	o.SubJobsResourceName = subJobsResourceName
}

// WithSubJobsResourceType adds the subJobsResourceType to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsResourceType(subJobsResourceType *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsResourceType(subJobsResourceType)
	return o
}

// SetSubJobsResourceType adds the subJobsResourceType to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsResourceType(subJobsResourceType *string) {
	o.SubJobsResourceType = subJobsResourceType
}

// WithSubJobsResourceUUID adds the subJobsResourceUUID to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsResourceUUID(subJobsResourceUUID *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsResourceUUID(subJobsResourceUUID)
	return o
}

// SetSubJobsResourceUUID adds the subJobsResourceUuid to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsResourceUUID(subJobsResourceUUID *string) {
	o.SubJobsResourceUUID = subJobsResourceUUID
}

// WithSubJobsStartTime adds the subJobsStartTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsStartTime(subJobsStartTime *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsStartTime(subJobsStartTime)
	return o
}

// SetSubJobsStartTime adds the subJobsStartTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsStartTime(subJobsStartTime *string) {
	o.SubJobsStartTime = subJobsStartTime
}

// WithSubJobsState adds the subJobsState to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsState(subJobsState *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsState(subJobsState)
	return o
}

// SetSubJobsState adds the subJobsState to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsState(subJobsState *string) {
	o.SubJobsState = subJobsState
}

// WithSubJobsTags adds the subJobsTags to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsTags(subJobsTags *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsTags(subJobsTags)
	return o
}

// SetSubJobsTags adds the subJobsTags to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsTags(subJobsTags *string) {
	o.SubJobsTags = subJobsTags
}

// WithSubJobsTimeout adds the subJobsTimeout to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsTimeout(subJobsTimeout *int64) *DataEngineJobCollectionGetParams {
	o.SetSubJobsTimeout(subJobsTimeout)
	return o
}

// SetSubJobsTimeout adds the subJobsTimeout to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsTimeout(subJobsTimeout *int64) {
	o.SubJobsTimeout = subJobsTimeout
}

// WithSubJobsType adds the subJobsType to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsType(subJobsType *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsType(subJobsType)
	return o
}

// SetSubJobsType adds the subJobsType to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsType(subJobsType *string) {
	o.SubJobsType = subJobsType
}

// WithSubJobsUpdateTime adds the subJobsUpdateTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsUpdateTime(subJobsUpdateTime *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsUpdateTime(subJobsUpdateTime)
	return o
}

// SetSubJobsUpdateTime adds the subJobsUpdateTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsUpdateTime(subJobsUpdateTime *string) {
	o.SubJobsUpdateTime = subJobsUpdateTime
}

// WithSubJobsUUID adds the subJobsUUID to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithSubJobsUUID(subJobsUUID *string) *DataEngineJobCollectionGetParams {
	o.SetSubJobsUUID(subJobsUUID)
	return o
}

// SetSubJobsUUID adds the subJobsUuid to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetSubJobsUUID(subJobsUUID *string) {
	o.SubJobsUUID = subJobsUUID
}

// WithTags adds the tags to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithTags(tags *string) *DataEngineJobCollectionGetParams {
	o.SetTags(tags)
	return o
}

// SetTags adds the tags to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetTags(tags *string) {
	o.Tags = tags
}

// WithTimeout adds the timeout to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithTimeout(timeout *int64) *DataEngineJobCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetTimeout(timeout *int64) {
	o.Timeout = timeout
}

// WithType adds the typeVar to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithType(typeVar *string) *DataEngineJobCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUpdateTime adds the updateTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithUpdateTime(updateTime *string) *DataEngineJobCollectionGetParams {
	o.SetUpdateTime(updateTime)
	return o
}

// SetUpdateTime adds the updateTime to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetUpdateTime(updateTime *string) {
	o.UpdateTime = updateTime
}

// WithUUID adds the uuid to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) WithUUID(uuid *string) *DataEngineJobCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the data engine job collection get params
func (o *DataEngineJobCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineJobCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.requestTimeout); err != nil {
		return err
	}
	var res []error

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.EndTime != nil {

		// query param end_time
		var qrEndTime string

		if o.EndTime != nil {
			qrEndTime = *o.EndTime
		}
		qEndTime := qrEndTime
		if qEndTime != "" {

			if err := r.SetQueryParam("end_time", qEndTime); err != nil {
				return err
			}
		}
	}

	if o.ErrorCode != nil {

		// query param error.code
		var qrErrorCode string

		if o.ErrorCode != nil {
			qrErrorCode = *o.ErrorCode
		}
		qErrorCode := qrErrorCode
		if qErrorCode != "" {

			if err := r.SetQueryParam("error.code", qErrorCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorMessage != nil {

		// query param error.message
		var qrErrorMessage string

		if o.ErrorMessage != nil {
			qrErrorMessage = *o.ErrorMessage
		}
		qErrorMessage := qrErrorMessage
		if qErrorMessage != "" {

			if err := r.SetQueryParam("error.message", qErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorTarget != nil {

		// query param error.target
		var qrErrorTarget string

		if o.ErrorTarget != nil {
			qrErrorTarget = *o.ErrorTarget
		}
		qErrorTarget := qrErrorTarget
		if qErrorTarget != "" {

			if err := r.SetQueryParam("error.target", qErrorTarget); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ParentJobUUID != nil {

		// query param parent_job.uuid
		var qrParentJobUUID string

		if o.ParentJobUUID != nil {
			qrParentJobUUID = *o.ParentJobUUID
		}
		qParentJobUUID := qrParentJobUUID
		if qParentJobUUID != "" {

			if err := r.SetQueryParam("parent_job.uuid", qParentJobUUID); err != nil {
				return err
			}
		}
	}

	if o.PercentComplete != nil {

		// query param percent_complete
		var qrPercentComplete int64

		if o.PercentComplete != nil {
			qrPercentComplete = *o.PercentComplete
		}
		qPercentComplete := swag.FormatInt64(qrPercentComplete)
		if qPercentComplete != "" {

			if err := r.SetQueryParam("percent_complete", qPercentComplete); err != nil {
				return err
			}
		}
	}

	if o.ResourceName != nil {

		// query param resource.name
		var qrResourceName string

		if o.ResourceName != nil {
			qrResourceName = *o.ResourceName
		}
		qResourceName := qrResourceName
		if qResourceName != "" {

			if err := r.SetQueryParam("resource.name", qResourceName); err != nil {
				return err
			}
		}
	}

	if o.ResourceType != nil {

		// query param resource.type
		var qrResourceType string

		if o.ResourceType != nil {
			qrResourceType = *o.ResourceType
		}
		qResourceType := qrResourceType
		if qResourceType != "" {

			if err := r.SetQueryParam("resource.type", qResourceType); err != nil {
				return err
			}
		}
	}

	if o.ResourceUUID != nil {

		// query param resource.uuid
		var qrResourceUUID string

		if o.ResourceUUID != nil {
			qrResourceUUID = *o.ResourceUUID
		}
		qResourceUUID := qrResourceUUID
		if qResourceUUID != "" {

			if err := r.SetQueryParam("resource.uuid", qResourceUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.StartTime != nil {

		// query param start_time
		var qrStartTime string

		if o.StartTime != nil {
			qrStartTime = *o.StartTime
		}
		qStartTime := qrStartTime
		if qStartTime != "" {

			if err := r.SetQueryParam("start_time", qStartTime); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.SubJobsCreateTime != nil {

		// query param sub_jobs.create_time
		var qrSubJobsCreateTime string

		if o.SubJobsCreateTime != nil {
			qrSubJobsCreateTime = *o.SubJobsCreateTime
		}
		qSubJobsCreateTime := qrSubJobsCreateTime
		if qSubJobsCreateTime != "" {

			if err := r.SetQueryParam("sub_jobs.create_time", qSubJobsCreateTime); err != nil {
				return err
			}
		}
	}

	if o.SubJobsDescription != nil {

		// query param sub_jobs.description
		var qrSubJobsDescription string

		if o.SubJobsDescription != nil {
			qrSubJobsDescription = *o.SubJobsDescription
		}
		qSubJobsDescription := qrSubJobsDescription
		if qSubJobsDescription != "" {

			if err := r.SetQueryParam("sub_jobs.description", qSubJobsDescription); err != nil {
				return err
			}
		}
	}

	if o.SubJobsEndTime != nil {

		// query param sub_jobs.end_time
		var qrSubJobsEndTime string

		if o.SubJobsEndTime != nil {
			qrSubJobsEndTime = *o.SubJobsEndTime
		}
		qSubJobsEndTime := qrSubJobsEndTime
		if qSubJobsEndTime != "" {

			if err := r.SetQueryParam("sub_jobs.end_time", qSubJobsEndTime); err != nil {
				return err
			}
		}
	}

	if o.SubJobsErrorCode != nil {

		// query param sub_jobs.error.code
		var qrSubJobsErrorCode string

		if o.SubJobsErrorCode != nil {
			qrSubJobsErrorCode = *o.SubJobsErrorCode
		}
		qSubJobsErrorCode := qrSubJobsErrorCode
		if qSubJobsErrorCode != "" {

			if err := r.SetQueryParam("sub_jobs.error.code", qSubJobsErrorCode); err != nil {
				return err
			}
		}
	}

	if o.SubJobsErrorMessage != nil {

		// query param sub_jobs.error.message
		var qrSubJobsErrorMessage string

		if o.SubJobsErrorMessage != nil {
			qrSubJobsErrorMessage = *o.SubJobsErrorMessage
		}
		qSubJobsErrorMessage := qrSubJobsErrorMessage
		if qSubJobsErrorMessage != "" {

			if err := r.SetQueryParam("sub_jobs.error.message", qSubJobsErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.SubJobsErrorTarget != nil {

		// query param sub_jobs.error.target
		var qrSubJobsErrorTarget string

		if o.SubJobsErrorTarget != nil {
			qrSubJobsErrorTarget = *o.SubJobsErrorTarget
		}
		qSubJobsErrorTarget := qrSubJobsErrorTarget
		if qSubJobsErrorTarget != "" {

			if err := r.SetQueryParam("sub_jobs.error.target", qSubJobsErrorTarget); err != nil {
				return err
			}
		}
	}

	if o.SubJobsName != nil {

		// query param sub_jobs.name
		var qrSubJobsName string

		if o.SubJobsName != nil {
			qrSubJobsName = *o.SubJobsName
		}
		qSubJobsName := qrSubJobsName
		if qSubJobsName != "" {

			if err := r.SetQueryParam("sub_jobs.name", qSubJobsName); err != nil {
				return err
			}
		}
	}

	if o.SubJobsParentJobUUID != nil {

		// query param sub_jobs.parent_job.uuid
		var qrSubJobsParentJobUUID string

		if o.SubJobsParentJobUUID != nil {
			qrSubJobsParentJobUUID = *o.SubJobsParentJobUUID
		}
		qSubJobsParentJobUUID := qrSubJobsParentJobUUID
		if qSubJobsParentJobUUID != "" {

			if err := r.SetQueryParam("sub_jobs.parent_job.uuid", qSubJobsParentJobUUID); err != nil {
				return err
			}
		}
	}

	if o.SubJobsPercentComplete != nil {

		// query param sub_jobs.percent_complete
		var qrSubJobsPercentComplete int64

		if o.SubJobsPercentComplete != nil {
			qrSubJobsPercentComplete = *o.SubJobsPercentComplete
		}
		qSubJobsPercentComplete := swag.FormatInt64(qrSubJobsPercentComplete)
		if qSubJobsPercentComplete != "" {

			if err := r.SetQueryParam("sub_jobs.percent_complete", qSubJobsPercentComplete); err != nil {
				return err
			}
		}
	}

	if o.SubJobsResourceName != nil {

		// query param sub_jobs.resource.name
		var qrSubJobsResourceName string

		if o.SubJobsResourceName != nil {
			qrSubJobsResourceName = *o.SubJobsResourceName
		}
		qSubJobsResourceName := qrSubJobsResourceName
		if qSubJobsResourceName != "" {

			if err := r.SetQueryParam("sub_jobs.resource.name", qSubJobsResourceName); err != nil {
				return err
			}
		}
	}

	if o.SubJobsResourceType != nil {

		// query param sub_jobs.resource.type
		var qrSubJobsResourceType string

		if o.SubJobsResourceType != nil {
			qrSubJobsResourceType = *o.SubJobsResourceType
		}
		qSubJobsResourceType := qrSubJobsResourceType
		if qSubJobsResourceType != "" {

			if err := r.SetQueryParam("sub_jobs.resource.type", qSubJobsResourceType); err != nil {
				return err
			}
		}
	}

	if o.SubJobsResourceUUID != nil {

		// query param sub_jobs.resource.uuid
		var qrSubJobsResourceUUID string

		if o.SubJobsResourceUUID != nil {
			qrSubJobsResourceUUID = *o.SubJobsResourceUUID
		}
		qSubJobsResourceUUID := qrSubJobsResourceUUID
		if qSubJobsResourceUUID != "" {

			if err := r.SetQueryParam("sub_jobs.resource.uuid", qSubJobsResourceUUID); err != nil {
				return err
			}
		}
	}

	if o.SubJobsStartTime != nil {

		// query param sub_jobs.start_time
		var qrSubJobsStartTime string

		if o.SubJobsStartTime != nil {
			qrSubJobsStartTime = *o.SubJobsStartTime
		}
		qSubJobsStartTime := qrSubJobsStartTime
		if qSubJobsStartTime != "" {

			if err := r.SetQueryParam("sub_jobs.start_time", qSubJobsStartTime); err != nil {
				return err
			}
		}
	}

	if o.SubJobsState != nil {

		// query param sub_jobs.state
		var qrSubJobsState string

		if o.SubJobsState != nil {
			qrSubJobsState = *o.SubJobsState
		}
		qSubJobsState := qrSubJobsState
		if qSubJobsState != "" {

			if err := r.SetQueryParam("sub_jobs.state", qSubJobsState); err != nil {
				return err
			}
		}
	}

	if o.SubJobsTags != nil {

		// query param sub_jobs.tags
		var qrSubJobsTags string

		if o.SubJobsTags != nil {
			qrSubJobsTags = *o.SubJobsTags
		}
		qSubJobsTags := qrSubJobsTags
		if qSubJobsTags != "" {

			if err := r.SetQueryParam("sub_jobs.tags", qSubJobsTags); err != nil {
				return err
			}
		}
	}

	if o.SubJobsTimeout != nil {

		// query param sub_jobs.timeout
		var qrSubJobsTimeout int64

		if o.SubJobsTimeout != nil {
			qrSubJobsTimeout = *o.SubJobsTimeout
		}
		qSubJobsTimeout := swag.FormatInt64(qrSubJobsTimeout)
		if qSubJobsTimeout != "" {

			if err := r.SetQueryParam("sub_jobs.timeout", qSubJobsTimeout); err != nil {
				return err
			}
		}
	}

	if o.SubJobsType != nil {

		// query param sub_jobs.type
		var qrSubJobsType string

		if o.SubJobsType != nil {
			qrSubJobsType = *o.SubJobsType
		}
		qSubJobsType := qrSubJobsType
		if qSubJobsType != "" {

			if err := r.SetQueryParam("sub_jobs.type", qSubJobsType); err != nil {
				return err
			}
		}
	}

	if o.SubJobsUpdateTime != nil {

		// query param sub_jobs.update_time
		var qrSubJobsUpdateTime string

		if o.SubJobsUpdateTime != nil {
			qrSubJobsUpdateTime = *o.SubJobsUpdateTime
		}
		qSubJobsUpdateTime := qrSubJobsUpdateTime
		if qSubJobsUpdateTime != "" {

			if err := r.SetQueryParam("sub_jobs.update_time", qSubJobsUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.SubJobsUUID != nil {

		// query param sub_jobs.uuid
		var qrSubJobsUUID string

		if o.SubJobsUUID != nil {
			qrSubJobsUUID = *o.SubJobsUUID
		}
		qSubJobsUUID := qrSubJobsUUID
		if qSubJobsUUID != "" {

			if err := r.SetQueryParam("sub_jobs.uuid", qSubJobsUUID); err != nil {
				return err
			}
		}
	}

	if o.Tags != nil {

		// query param tags
		var qrTags string

		if o.Tags != nil {
			qrTags = *o.Tags
		}
		qTags := qrTags
		if qTags != "" {

			if err := r.SetQueryParam("tags", qTags); err != nil {
				return err
			}
		}
	}

	if o.Timeout != nil {

		// query param timeout
		var qrTimeout int64

		if o.Timeout != nil {
			qrTimeout = *o.Timeout
		}
		qTimeout := swag.FormatInt64(qrTimeout)
		if qTimeout != "" {

			if err := r.SetQueryParam("timeout", qTimeout); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UpdateTime != nil {

		// query param update_time
		var qrUpdateTime string

		if o.UpdateTime != nil {
			qrUpdateTime = *o.UpdateTime
		}
		qUpdateTime := qrUpdateTime
		if qUpdateTime != "" {

			if err := r.SetQueryParam("update_time", qUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEngineJobCollectionGet binds the parameter fields
func (o *DataEngineJobCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDataEngineJobCollectionGet binds the parameter order_by
func (o *DataEngineJobCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
