// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineJobCollectionGetReader is a Reader for the DataEngineJobCollectionGet structure.
type DataEngineJobCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineJobCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineJobCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineJobCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineJobCollectionGetOK creates a DataEngineJobCollectionGetOK with default headers values
func NewDataEngineJobCollectionGetOK() *DataEngineJobCollectionGetOK {
	return &DataEngineJobCollectionGetOK{}
}

/*
DataEngineJobCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineJobCollectionGetOK struct {
	Payload *models.DataEngineJobResponse
}

// IsSuccess returns true when this data engine job collection get o k response has a 2xx status code
func (o *DataEngineJobCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine job collection get o k response has a 3xx status code
func (o *DataEngineJobCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine job collection get o k response has a 4xx status code
func (o *DataEngineJobCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine job collection get o k response has a 5xx status code
func (o *DataEngineJobCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine job collection get o k response a status code equal to that given
func (o *DataEngineJobCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine job collection get o k response
func (o *DataEngineJobCollectionGetOK) Code() int {
	return 200
}

func (o *DataEngineJobCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/jobs][%d] dataEngineJobCollectionGetOK %s", 200, payload)
}

func (o *DataEngineJobCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/jobs][%d] dataEngineJobCollectionGetOK %s", 200, payload)
}

func (o *DataEngineJobCollectionGetOK) GetPayload() *models.DataEngineJobResponse {
	return o.Payload
}

func (o *DataEngineJobCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJobResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineJobCollectionGetDefault creates a DataEngineJobCollectionGetDefault with default headers values
func NewDataEngineJobCollectionGetDefault(code int) *DataEngineJobCollectionGetDefault {
	return &DataEngineJobCollectionGetDefault{
		_statusCode: code,
	}
}

/*
DataEngineJobCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type DataEngineJobCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine job collection get default response has a 2xx status code
func (o *DataEngineJobCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine job collection get default response has a 3xx status code
func (o *DataEngineJobCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine job collection get default response has a 4xx status code
func (o *DataEngineJobCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine job collection get default response has a 5xx status code
func (o *DataEngineJobCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine job collection get default response a status code equal to that given
func (o *DataEngineJobCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine job collection get default response
func (o *DataEngineJobCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineJobCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/jobs][%d] data_engine_job_collection_get default %s", o._statusCode, payload)
}

func (o *DataEngineJobCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/jobs][%d] data_engine_job_collection_get default %s", o._statusCode, payload)
}

func (o *DataEngineJobCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineJobCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
