// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEngineJobGetParams creates a new DataEngineJobGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEngineJobGetParams() *DataEngineJobGetParams {
	return &DataEngineJobGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEngineJobGetParamsWithTimeout creates a new DataEngineJobGetParams object
// with the ability to set a timeout on a request.
func NewDataEngineJobGetParamsWithTimeout(timeout time.Duration) *DataEngineJobGetParams {
	return &DataEngineJobGetParams{
		timeout: timeout,
	}
}

// NewDataEngineJobGetParamsWithContext creates a new DataEngineJobGetParams object
// with the ability to set a context for a request.
func NewDataEngineJobGetParamsWithContext(ctx context.Context) *DataEngineJobGetParams {
	return &DataEngineJobGetParams{
		Context: ctx,
	}
}

// NewDataEngineJobGetParamsWithHTTPClient creates a new DataEngineJobGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEngineJobGetParamsWithHTTPClient(client *http.Client) *DataEngineJobGetParams {
	return &DataEngineJobGetParams{
		HTTPClient: client,
	}
}

/*
DataEngineJobGetParams contains all the parameters to send to the API endpoint

	for the data engine job get operation.

	Typically these are written to a http.Request.
*/
type DataEngineJobGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   The unique identifier of the DCN job.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine job get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineJobGetParams) WithDefaults() *DataEngineJobGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine job get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEngineJobGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the data engine job get params
func (o *DataEngineJobGetParams) WithTimeout(timeout time.Duration) *DataEngineJobGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine job get params
func (o *DataEngineJobGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine job get params
func (o *DataEngineJobGetParams) WithContext(ctx context.Context) *DataEngineJobGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine job get params
func (o *DataEngineJobGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine job get params
func (o *DataEngineJobGetParams) WithHTTPClient(client *http.Client) *DataEngineJobGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine job get params
func (o *DataEngineJobGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the data engine job get params
func (o *DataEngineJobGetParams) WithFields(fields []string) *DataEngineJobGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine job get params
func (o *DataEngineJobGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the data engine job get params
func (o *DataEngineJobGetParams) WithUUID(uuid string) *DataEngineJobGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the data engine job get params
func (o *DataEngineJobGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *DataEngineJobGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEngineJobGet binds the parameter fields
func (o *DataEngineJobGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
