// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEngineJobGetReader is a Reader for the DataEngineJobGet structure.
type DataEngineJobGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEngineJobGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEngineJobGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEngineJobGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEngineJobGetOK creates a DataEngineJobGetOK with default headers values
func NewDataEngineJobGetOK() *DataEngineJobGetOK {
	return &DataEngineJobGetOK{}
}

/*
DataEngineJobGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEngineJobGetOK struct {
	Payload *models.DataEngineJob
}

// IsSuccess returns true when this data engine job get o k response has a 2xx status code
func (o *DataEngineJobGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine job get o k response has a 3xx status code
func (o *DataEngineJobGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine job get o k response has a 4xx status code
func (o *DataEngineJobGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine job get o k response has a 5xx status code
func (o *DataEngineJobGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine job get o k response a status code equal to that given
func (o *DataEngineJobGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine job get o k response
func (o *DataEngineJobGetOK) Code() int {
	return 200
}

func (o *DataEngineJobGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/jobs/{uuid}][%d] dataEngineJobGetOK %s", 200, payload)
}

func (o *DataEngineJobGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/jobs/{uuid}][%d] dataEngineJobGetOK %s", 200, payload)
}

func (o *DataEngineJobGetOK) GetPayload() *models.DataEngineJob {
	return o.Payload
}

func (o *DataEngineJobGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJob)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEngineJobGetDefault creates a DataEngineJobGetDefault with default headers values
func NewDataEngineJobGetDefault(code int) *DataEngineJobGetDefault {
	return &DataEngineJobGetDefault{
		_statusCode: code,
	}
}

/*
	DataEngineJobGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4 | The job does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type DataEngineJobGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine job get default response has a 2xx status code
func (o *DataEngineJobGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine job get default response has a 3xx status code
func (o *DataEngineJobGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine job get default response has a 4xx status code
func (o *DataEngineJobGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine job get default response has a 5xx status code
func (o *DataEngineJobGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine job get default response a status code equal to that given
func (o *DataEngineJobGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine job get default response
func (o *DataEngineJobGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEngineJobGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/jobs/{uuid}][%d] data_engine_job_get default %s", o._statusCode, payload)
}

func (o *DataEngineJobGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/jobs/{uuid}][%d] data_engine_job_get default %s", o._statusCode, payload)
}

func (o *DataEngineJobGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEngineJobGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
