// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEnginePolicyCollectionGetParams creates a new DataEnginePolicyCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEnginePolicyCollectionGetParams() *DataEnginePolicyCollectionGetParams {
	return &DataEnginePolicyCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEnginePolicyCollectionGetParamsWithTimeout creates a new DataEnginePolicyCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDataEnginePolicyCollectionGetParamsWithTimeout(timeout time.Duration) *DataEnginePolicyCollectionGetParams {
	return &DataEnginePolicyCollectionGetParams{
		timeout: timeout,
	}
}

// NewDataEnginePolicyCollectionGetParamsWithContext creates a new DataEnginePolicyCollectionGetParams object
// with the ability to set a context for a request.
func NewDataEnginePolicyCollectionGetParamsWithContext(ctx context.Context) *DataEnginePolicyCollectionGetParams {
	return &DataEnginePolicyCollectionGetParams{
		Context: ctx,
	}
}

// NewDataEnginePolicyCollectionGetParamsWithHTTPClient creates a new DataEnginePolicyCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEnginePolicyCollectionGetParamsWithHTTPClient(client *http.Client) *DataEnginePolicyCollectionGetParams {
	return &DataEnginePolicyCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DataEnginePolicyCollectionGetParams contains all the parameters to send to the API endpoint

	for the data engine policy collection get operation.

	Typically these are written to a http.Request.
*/
type DataEnginePolicyCollectionGetParams struct {

	/* ActionsEnabled.

	   Filter by actions.enabled
	*/
	ActionsEnabled *bool

	/* ActionsName.

	   Filter by actions.name
	*/
	ActionsName *string

	/* AttributesKey.

	   Filter by attributes.key
	*/
	AttributesKey *string

	/* AttributesValue.

	   Filter by attributes.value
	*/
	AttributesValue *string

	/* ConditionsCondition.

	   Filter by conditions.condition
	*/
	ConditionsCondition *string

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* DeleteTime.

	   Filter by delete_time
	*/
	DeleteTime *string

	/* Description.

	   Filter by description
	*/
	Description *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* Target.

	   Filter by target
	*/
	Target *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UpdateTime.

	   Filter by update_time
	*/
	UpdateTime *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VersionUUID.

	   Filter by version.uuid
	*/
	VersionUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine policy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEnginePolicyCollectionGetParams) WithDefaults() *DataEnginePolicyCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine policy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEnginePolicyCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DataEnginePolicyCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithTimeout(timeout time.Duration) *DataEnginePolicyCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithContext(ctx context.Context) *DataEnginePolicyCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithHTTPClient(client *http.Client) *DataEnginePolicyCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActionsEnabled adds the actionsEnabled to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithActionsEnabled(actionsEnabled *bool) *DataEnginePolicyCollectionGetParams {
	o.SetActionsEnabled(actionsEnabled)
	return o
}

// SetActionsEnabled adds the actionsEnabled to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetActionsEnabled(actionsEnabled *bool) {
	o.ActionsEnabled = actionsEnabled
}

// WithActionsName adds the actionsName to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithActionsName(actionsName *string) *DataEnginePolicyCollectionGetParams {
	o.SetActionsName(actionsName)
	return o
}

// SetActionsName adds the actionsName to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetActionsName(actionsName *string) {
	o.ActionsName = actionsName
}

// WithAttributesKey adds the attributesKey to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithAttributesKey(attributesKey *string) *DataEnginePolicyCollectionGetParams {
	o.SetAttributesKey(attributesKey)
	return o
}

// SetAttributesKey adds the attributesKey to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetAttributesKey(attributesKey *string) {
	o.AttributesKey = attributesKey
}

// WithAttributesValue adds the attributesValue to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithAttributesValue(attributesValue *string) *DataEnginePolicyCollectionGetParams {
	o.SetAttributesValue(attributesValue)
	return o
}

// SetAttributesValue adds the attributesValue to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetAttributesValue(attributesValue *string) {
	o.AttributesValue = attributesValue
}

// WithConditionsCondition adds the conditionsCondition to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithConditionsCondition(conditionsCondition *string) *DataEnginePolicyCollectionGetParams {
	o.SetConditionsCondition(conditionsCondition)
	return o
}

// SetConditionsCondition adds the conditionsCondition to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetConditionsCondition(conditionsCondition *string) {
	o.ConditionsCondition = conditionsCondition
}

// WithCreateTime adds the createTime to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithCreateTime(createTime *string) *DataEnginePolicyCollectionGetParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithDeleteTime adds the deleteTime to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithDeleteTime(deleteTime *string) *DataEnginePolicyCollectionGetParams {
	o.SetDeleteTime(deleteTime)
	return o
}

// SetDeleteTime adds the deleteTime to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetDeleteTime(deleteTime *string) {
	o.DeleteTime = deleteTime
}

// WithDescription adds the description to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithDescription(description *string) *DataEnginePolicyCollectionGetParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetDescription(description *string) {
	o.Description = description
}

// WithEnabled adds the enabled to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithEnabled(enabled *bool) *DataEnginePolicyCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithFields(fields []string) *DataEnginePolicyCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithMaxRecords(maxRecords *int64) *DataEnginePolicyCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithName(name *string) *DataEnginePolicyCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithOrderBy(orderBy []string) *DataEnginePolicyCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithReturnRecords(returnRecords *bool) *DataEnginePolicyCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DataEnginePolicyCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithScope(scope *string) *DataEnginePolicyCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithTarget adds the target to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithTarget(target *string) *DataEnginePolicyCollectionGetParams {
	o.SetTarget(target)
	return o
}

// SetTarget adds the target to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetTarget(target *string) {
	o.Target = target
}

// WithType adds the typeVar to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithType(typeVar *string) *DataEnginePolicyCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUpdateTime adds the updateTime to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithUpdateTime(updateTime *string) *DataEnginePolicyCollectionGetParams {
	o.SetUpdateTime(updateTime)
	return o
}

// SetUpdateTime adds the updateTime to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetUpdateTime(updateTime *string) {
	o.UpdateTime = updateTime
}

// WithUUID adds the uuid to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithUUID(uuid *string) *DataEnginePolicyCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVersionUUID adds the versionUUID to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) WithVersionUUID(versionUUID *string) *DataEnginePolicyCollectionGetParams {
	o.SetVersionUUID(versionUUID)
	return o
}

// SetVersionUUID adds the versionUuid to the data engine policy collection get params
func (o *DataEnginePolicyCollectionGetParams) SetVersionUUID(versionUUID *string) {
	o.VersionUUID = versionUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEnginePolicyCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ActionsEnabled != nil {

		// query param actions.enabled
		var qrActionsEnabled bool

		if o.ActionsEnabled != nil {
			qrActionsEnabled = *o.ActionsEnabled
		}
		qActionsEnabled := swag.FormatBool(qrActionsEnabled)
		if qActionsEnabled != "" {

			if err := r.SetQueryParam("actions.enabled", qActionsEnabled); err != nil {
				return err
			}
		}
	}

	if o.ActionsName != nil {

		// query param actions.name
		var qrActionsName string

		if o.ActionsName != nil {
			qrActionsName = *o.ActionsName
		}
		qActionsName := qrActionsName
		if qActionsName != "" {

			if err := r.SetQueryParam("actions.name", qActionsName); err != nil {
				return err
			}
		}
	}

	if o.AttributesKey != nil {

		// query param attributes.key
		var qrAttributesKey string

		if o.AttributesKey != nil {
			qrAttributesKey = *o.AttributesKey
		}
		qAttributesKey := qrAttributesKey
		if qAttributesKey != "" {

			if err := r.SetQueryParam("attributes.key", qAttributesKey); err != nil {
				return err
			}
		}
	}

	if o.AttributesValue != nil {

		// query param attributes.value
		var qrAttributesValue string

		if o.AttributesValue != nil {
			qrAttributesValue = *o.AttributesValue
		}
		qAttributesValue := qrAttributesValue
		if qAttributesValue != "" {

			if err := r.SetQueryParam("attributes.value", qAttributesValue); err != nil {
				return err
			}
		}
	}

	if o.ConditionsCondition != nil {

		// query param conditions.condition
		var qrConditionsCondition string

		if o.ConditionsCondition != nil {
			qrConditionsCondition = *o.ConditionsCondition
		}
		qConditionsCondition := qrConditionsCondition
		if qConditionsCondition != "" {

			if err := r.SetQueryParam("conditions.condition", qConditionsCondition); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.DeleteTime != nil {

		// query param delete_time
		var qrDeleteTime string

		if o.DeleteTime != nil {
			qrDeleteTime = *o.DeleteTime
		}
		qDeleteTime := qrDeleteTime
		if qDeleteTime != "" {

			if err := r.SetQueryParam("delete_time", qDeleteTime); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.Target != nil {

		// query param target
		var qrTarget string

		if o.Target != nil {
			qrTarget = *o.Target
		}
		qTarget := qrTarget
		if qTarget != "" {

			if err := r.SetQueryParam("target", qTarget); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UpdateTime != nil {

		// query param update_time
		var qrUpdateTime string

		if o.UpdateTime != nil {
			qrUpdateTime = *o.UpdateTime
		}
		qUpdateTime := qrUpdateTime
		if qUpdateTime != "" {

			if err := r.SetQueryParam("update_time", qUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionUUID != nil {

		// query param version.uuid
		var qrVersionUUID string

		if o.VersionUUID != nil {
			qrVersionUUID = *o.VersionUUID
		}
		qVersionUUID := qrVersionUUID
		if qVersionUUID != "" {

			if err := r.SetQueryParam("version.uuid", qVersionUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEnginePolicyCollectionGet binds the parameter fields
func (o *DataEnginePolicyCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDataEnginePolicyCollectionGet binds the parameter order_by
func (o *DataEnginePolicyCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
