// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEnginePolicyCollectionGetReader is a Reader for the DataEnginePolicyCollectionGet structure.
type DataEnginePolicyCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEnginePolicyCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEnginePolicyCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEnginePolicyCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEnginePolicyCollectionGetOK creates a DataEnginePolicyCollectionGetOK with default headers values
func NewDataEnginePolicyCollectionGetOK() *DataEnginePolicyCollectionGetOK {
	return &DataEnginePolicyCollectionGetOK{}
}

/*
DataEnginePolicyCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEnginePolicyCollectionGetOK struct {
	Payload *models.DataEnginePolicyResponse
}

// IsSuccess returns true when this data engine policy collection get o k response has a 2xx status code
func (o *DataEnginePolicyCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine policy collection get o k response has a 3xx status code
func (o *DataEnginePolicyCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine policy collection get o k response has a 4xx status code
func (o *DataEnginePolicyCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine policy collection get o k response has a 5xx status code
func (o *DataEnginePolicyCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine policy collection get o k response a status code equal to that given
func (o *DataEnginePolicyCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine policy collection get o k response
func (o *DataEnginePolicyCollectionGetOK) Code() int {
	return 200
}

func (o *DataEnginePolicyCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/policies][%d] dataEnginePolicyCollectionGetOK %s", 200, payload)
}

func (o *DataEnginePolicyCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/policies][%d] dataEnginePolicyCollectionGetOK %s", 200, payload)
}

func (o *DataEnginePolicyCollectionGetOK) GetPayload() *models.DataEnginePolicyResponse {
	return o.Payload
}

func (o *DataEnginePolicyCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEnginePolicyResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEnginePolicyCollectionGetDefault creates a DataEnginePolicyCollectionGetDefault with default headers values
func NewDataEnginePolicyCollectionGetDefault(code int) *DataEnginePolicyCollectionGetDefault {
	return &DataEnginePolicyCollectionGetDefault{
		_statusCode: code,
	}
}

/*
DataEnginePolicyCollectionGetDefault describes a response with status code -1, with default header values.

Error in retrieving the data engine policies.
*/
type DataEnginePolicyCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine policy collection get default response has a 2xx status code
func (o *DataEnginePolicyCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine policy collection get default response has a 3xx status code
func (o *DataEnginePolicyCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine policy collection get default response has a 4xx status code
func (o *DataEnginePolicyCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine policy collection get default response has a 5xx status code
func (o *DataEnginePolicyCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine policy collection get default response a status code equal to that given
func (o *DataEnginePolicyCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine policy collection get default response
func (o *DataEnginePolicyCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEnginePolicyCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/policies][%d] data_engine_policy_collection_get default %s", o._statusCode, payload)
}

func (o *DataEnginePolicyCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/policies][%d] data_engine_policy_collection_get default %s", o._statusCode, payload)
}

func (o *DataEnginePolicyCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEnginePolicyCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
