// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEnginePolicyGetParams creates a new DataEnginePolicyGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEnginePolicyGetParams() *DataEnginePolicyGetParams {
	return &DataEnginePolicyGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEnginePolicyGetParamsWithTimeout creates a new DataEnginePolicyGetParams object
// with the ability to set a timeout on a request.
func NewDataEnginePolicyGetParamsWithTimeout(timeout time.Duration) *DataEnginePolicyGetParams {
	return &DataEnginePolicyGetParams{
		timeout: timeout,
	}
}

// NewDataEnginePolicyGetParamsWithContext creates a new DataEnginePolicyGetParams object
// with the ability to set a context for a request.
func NewDataEnginePolicyGetParamsWithContext(ctx context.Context) *DataEnginePolicyGetParams {
	return &DataEnginePolicyGetParams{
		Context: ctx,
	}
}

// NewDataEnginePolicyGetParamsWithHTTPClient creates a new DataEnginePolicyGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEnginePolicyGetParamsWithHTTPClient(client *http.Client) *DataEnginePolicyGetParams {
	return &DataEnginePolicyGetParams{
		HTTPClient: client,
	}
}

/*
DataEnginePolicyGetParams contains all the parameters to send to the API endpoint

	for the data engine policy get operation.

	Typically these are written to a http.Request.
*/
type DataEnginePolicyGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Unique identifier of the data engine policy.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine policy get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEnginePolicyGetParams) WithDefaults() *DataEnginePolicyGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine policy get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEnginePolicyGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the data engine policy get params
func (o *DataEnginePolicyGetParams) WithTimeout(timeout time.Duration) *DataEnginePolicyGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine policy get params
func (o *DataEnginePolicyGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine policy get params
func (o *DataEnginePolicyGetParams) WithContext(ctx context.Context) *DataEnginePolicyGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine policy get params
func (o *DataEnginePolicyGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine policy get params
func (o *DataEnginePolicyGetParams) WithHTTPClient(client *http.Client) *DataEnginePolicyGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine policy get params
func (o *DataEnginePolicyGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the data engine policy get params
func (o *DataEnginePolicyGetParams) WithFields(fields []string) *DataEnginePolicyGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data engine policy get params
func (o *DataEnginePolicyGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the data engine policy get params
func (o *DataEnginePolicyGetParams) WithUUID(uuid string) *DataEnginePolicyGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the data engine policy get params
func (o *DataEnginePolicyGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *DataEnginePolicyGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataEnginePolicyGet binds the parameter fields
func (o *DataEnginePolicyGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
