// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEnginePolicyGetReader is a Reader for the DataEnginePolicyGet structure.
type DataEnginePolicyGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEnginePolicyGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEnginePolicyGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEnginePolicyGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEnginePolicyGetOK creates a DataEnginePolicyGetOK with default headers values
func NewDataEnginePolicyGetOK() *DataEnginePolicyGetOK {
	return &DataEnginePolicyGetOK{}
}

/*
DataEnginePolicyGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEnginePolicyGetOK struct {
	Payload *models.DataEnginePolicy
}

// IsSuccess returns true when this data engine policy get o k response has a 2xx status code
func (o *DataEnginePolicyGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine policy get o k response has a 3xx status code
func (o *DataEnginePolicyGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine policy get o k response has a 4xx status code
func (o *DataEnginePolicyGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine policy get o k response has a 5xx status code
func (o *DataEnginePolicyGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine policy get o k response a status code equal to that given
func (o *DataEnginePolicyGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine policy get o k response
func (o *DataEnginePolicyGetOK) Code() int {
	return 200
}

func (o *DataEnginePolicyGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/policies/{uuid}][%d] dataEnginePolicyGetOK %s", 200, payload)
}

func (o *DataEnginePolicyGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/policies/{uuid}][%d] dataEnginePolicyGetOK %s", 200, payload)
}

func (o *DataEnginePolicyGetOK) GetPayload() *models.DataEnginePolicy {
	return o.Payload
}

func (o *DataEnginePolicyGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEnginePolicy)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEnginePolicyGetDefault creates a DataEnginePolicyGetDefault with default headers values
func NewDataEnginePolicyGetDefault(code int) *DataEnginePolicyGetDefault {
	return &DataEnginePolicyGetDefault{
		_statusCode: code,
	}
}

/*
	DataEnginePolicyGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4 | The data engine policy does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type DataEnginePolicyGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine policy get default response has a 2xx status code
func (o *DataEnginePolicyGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine policy get default response has a 3xx status code
func (o *DataEnginePolicyGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine policy get default response has a 4xx status code
func (o *DataEnginePolicyGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine policy get default response has a 5xx status code
func (o *DataEnginePolicyGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine policy get default response a status code equal to that given
func (o *DataEnginePolicyGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine policy get default response
func (o *DataEnginePolicyGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEnginePolicyGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/policies/{uuid}][%d] data_engine_policy_get default %s", o._statusCode, payload)
}

func (o *DataEnginePolicyGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/policies/{uuid}][%d] data_engine_policy_get default %s", o._statusCode, payload)
}

func (o *DataEnginePolicyGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEnginePolicyGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
