// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataEnginePolicyModifyCollectionParams creates a new DataEnginePolicyModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEnginePolicyModifyCollectionParams() *DataEnginePolicyModifyCollectionParams {
	return &DataEnginePolicyModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEnginePolicyModifyCollectionParamsWithTimeout creates a new DataEnginePolicyModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewDataEnginePolicyModifyCollectionParamsWithTimeout(timeout time.Duration) *DataEnginePolicyModifyCollectionParams {
	return &DataEnginePolicyModifyCollectionParams{
		timeout: timeout,
	}
}

// NewDataEnginePolicyModifyCollectionParamsWithContext creates a new DataEnginePolicyModifyCollectionParams object
// with the ability to set a context for a request.
func NewDataEnginePolicyModifyCollectionParamsWithContext(ctx context.Context) *DataEnginePolicyModifyCollectionParams {
	return &DataEnginePolicyModifyCollectionParams{
		Context: ctx,
	}
}

// NewDataEnginePolicyModifyCollectionParamsWithHTTPClient creates a new DataEnginePolicyModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEnginePolicyModifyCollectionParamsWithHTTPClient(client *http.Client) *DataEnginePolicyModifyCollectionParams {
	return &DataEnginePolicyModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
DataEnginePolicyModifyCollectionParams contains all the parameters to send to the API endpoint

	for the data engine policy modify collection operation.

	Typically these are written to a http.Request.
*/
type DataEnginePolicyModifyCollectionParams struct {

	/* ActionsEnabled.

	   Filter by actions.enabled
	*/
	ActionsEnabled *bool

	/* ActionsName.

	   Filter by actions.name
	*/
	ActionsName *string

	/* AttributesKey.

	   Filter by attributes.key
	*/
	AttributesKey *string

	/* AttributesValue.

	   Filter by attributes.value
	*/
	AttributesValue *string

	/* ConditionsCondition.

	   Filter by conditions.condition
	*/
	ConditionsCondition *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* DeleteTime.

	   Filter by delete_time
	*/
	DeleteTime *string

	/* Description.

	   Filter by description
	*/
	Description *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info DataEnginePolicyModifyCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Target.

	   Filter by target
	*/
	Target *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UpdateTime.

	   Filter by update_time
	*/
	UpdateTime *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* ValidateOnly.

	   Validate the operation and its parameters, without actually performing the operation.
	*/
	ValidateOnly *bool

	/* VersionUUID.

	   Filter by version.uuid
	*/
	VersionUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine policy modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEnginePolicyModifyCollectionParams) WithDefaults() *DataEnginePolicyModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine policy modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEnginePolicyModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := DataEnginePolicyModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithTimeout(timeout time.Duration) *DataEnginePolicyModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithContext(ctx context.Context) *DataEnginePolicyModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithHTTPClient(client *http.Client) *DataEnginePolicyModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActionsEnabled adds the actionsEnabled to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithActionsEnabled(actionsEnabled *bool) *DataEnginePolicyModifyCollectionParams {
	o.SetActionsEnabled(actionsEnabled)
	return o
}

// SetActionsEnabled adds the actionsEnabled to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetActionsEnabled(actionsEnabled *bool) {
	o.ActionsEnabled = actionsEnabled
}

// WithActionsName adds the actionsName to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithActionsName(actionsName *string) *DataEnginePolicyModifyCollectionParams {
	o.SetActionsName(actionsName)
	return o
}

// SetActionsName adds the actionsName to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetActionsName(actionsName *string) {
	o.ActionsName = actionsName
}

// WithAttributesKey adds the attributesKey to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithAttributesKey(attributesKey *string) *DataEnginePolicyModifyCollectionParams {
	o.SetAttributesKey(attributesKey)
	return o
}

// SetAttributesKey adds the attributesKey to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetAttributesKey(attributesKey *string) {
	o.AttributesKey = attributesKey
}

// WithAttributesValue adds the attributesValue to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithAttributesValue(attributesValue *string) *DataEnginePolicyModifyCollectionParams {
	o.SetAttributesValue(attributesValue)
	return o
}

// SetAttributesValue adds the attributesValue to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetAttributesValue(attributesValue *string) {
	o.AttributesValue = attributesValue
}

// WithConditionsCondition adds the conditionsCondition to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithConditionsCondition(conditionsCondition *string) *DataEnginePolicyModifyCollectionParams {
	o.SetConditionsCondition(conditionsCondition)
	return o
}

// SetConditionsCondition adds the conditionsCondition to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetConditionsCondition(conditionsCondition *string) {
	o.ConditionsCondition = conditionsCondition
}

// WithContinueOnFailure adds the continueOnFailure to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *DataEnginePolicyModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCreateTime adds the createTime to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithCreateTime(createTime *string) *DataEnginePolicyModifyCollectionParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithDeleteTime adds the deleteTime to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithDeleteTime(deleteTime *string) *DataEnginePolicyModifyCollectionParams {
	o.SetDeleteTime(deleteTime)
	return o
}

// SetDeleteTime adds the deleteTime to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetDeleteTime(deleteTime *string) {
	o.DeleteTime = deleteTime
}

// WithDescription adds the description to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithDescription(description *string) *DataEnginePolicyModifyCollectionParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetDescription(description *string) {
	o.Description = description
}

// WithEnabled adds the enabled to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithEnabled(enabled *bool) *DataEnginePolicyModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithInfo(info DataEnginePolicyModifyCollectionBody) *DataEnginePolicyModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetInfo(info DataEnginePolicyModifyCollectionBody) {
	o.Info = info
}

// WithName adds the name to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithName(name *string) *DataEnginePolicyModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithReturnRecords(returnRecords *bool) *DataEnginePolicyModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *DataEnginePolicyModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithScope(scope *string) *DataEnginePolicyModifyCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithSerialRecords(serialRecords *bool) *DataEnginePolicyModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithTarget adds the target to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithTarget(target *string) *DataEnginePolicyModifyCollectionParams {
	o.SetTarget(target)
	return o
}

// SetTarget adds the target to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetTarget(target *string) {
	o.Target = target
}

// WithType adds the typeVar to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithType(typeVar *string) *DataEnginePolicyModifyCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUpdateTime adds the updateTime to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithUpdateTime(updateTime *string) *DataEnginePolicyModifyCollectionParams {
	o.SetUpdateTime(updateTime)
	return o
}

// SetUpdateTime adds the updateTime to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetUpdateTime(updateTime *string) {
	o.UpdateTime = updateTime
}

// WithUUID adds the uuid to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithUUID(uuid *string) *DataEnginePolicyModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithValidateOnly adds the validateOnly to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithValidateOnly(validateOnly *bool) *DataEnginePolicyModifyCollectionParams {
	o.SetValidateOnly(validateOnly)
	return o
}

// SetValidateOnly adds the validateOnly to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetValidateOnly(validateOnly *bool) {
	o.ValidateOnly = validateOnly
}

// WithVersionUUID adds the versionUUID to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) WithVersionUUID(versionUUID *string) *DataEnginePolicyModifyCollectionParams {
	o.SetVersionUUID(versionUUID)
	return o
}

// SetVersionUUID adds the versionUuid to the data engine policy modify collection params
func (o *DataEnginePolicyModifyCollectionParams) SetVersionUUID(versionUUID *string) {
	o.VersionUUID = versionUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataEnginePolicyModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ActionsEnabled != nil {

		// query param actions.enabled
		var qrActionsEnabled bool

		if o.ActionsEnabled != nil {
			qrActionsEnabled = *o.ActionsEnabled
		}
		qActionsEnabled := swag.FormatBool(qrActionsEnabled)
		if qActionsEnabled != "" {

			if err := r.SetQueryParam("actions.enabled", qActionsEnabled); err != nil {
				return err
			}
		}
	}

	if o.ActionsName != nil {

		// query param actions.name
		var qrActionsName string

		if o.ActionsName != nil {
			qrActionsName = *o.ActionsName
		}
		qActionsName := qrActionsName
		if qActionsName != "" {

			if err := r.SetQueryParam("actions.name", qActionsName); err != nil {
				return err
			}
		}
	}

	if o.AttributesKey != nil {

		// query param attributes.key
		var qrAttributesKey string

		if o.AttributesKey != nil {
			qrAttributesKey = *o.AttributesKey
		}
		qAttributesKey := qrAttributesKey
		if qAttributesKey != "" {

			if err := r.SetQueryParam("attributes.key", qAttributesKey); err != nil {
				return err
			}
		}
	}

	if o.AttributesValue != nil {

		// query param attributes.value
		var qrAttributesValue string

		if o.AttributesValue != nil {
			qrAttributesValue = *o.AttributesValue
		}
		qAttributesValue := qrAttributesValue
		if qAttributesValue != "" {

			if err := r.SetQueryParam("attributes.value", qAttributesValue); err != nil {
				return err
			}
		}
	}

	if o.ConditionsCondition != nil {

		// query param conditions.condition
		var qrConditionsCondition string

		if o.ConditionsCondition != nil {
			qrConditionsCondition = *o.ConditionsCondition
		}
		qConditionsCondition := qrConditionsCondition
		if qConditionsCondition != "" {

			if err := r.SetQueryParam("conditions.condition", qConditionsCondition); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.DeleteTime != nil {

		// query param delete_time
		var qrDeleteTime string

		if o.DeleteTime != nil {
			qrDeleteTime = *o.DeleteTime
		}
		qDeleteTime := qrDeleteTime
		if qDeleteTime != "" {

			if err := r.SetQueryParam("delete_time", qDeleteTime); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Target != nil {

		// query param target
		var qrTarget string

		if o.Target != nil {
			qrTarget = *o.Target
		}
		qTarget := qrTarget
		if qTarget != "" {

			if err := r.SetQueryParam("target", qTarget); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UpdateTime != nil {

		// query param update_time
		var qrUpdateTime string

		if o.UpdateTime != nil {
			qrUpdateTime = *o.UpdateTime
		}
		qUpdateTime := qrUpdateTime
		if qUpdateTime != "" {

			if err := r.SetQueryParam("update_time", qUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.ValidateOnly != nil {

		// query param validate_only
		var qrValidateOnly bool

		if o.ValidateOnly != nil {
			qrValidateOnly = *o.ValidateOnly
		}
		qValidateOnly := swag.FormatBool(qrValidateOnly)
		if qValidateOnly != "" {

			if err := r.SetQueryParam("validate_only", qValidateOnly); err != nil {
				return err
			}
		}
	}

	if o.VersionUUID != nil {

		// query param version.uuid
		var qrVersionUUID string

		if o.VersionUUID != nil {
			qrVersionUUID = *o.VersionUUID
		}
		qVersionUUID := qrVersionUUID
		if qVersionUUID != "" {

			if err := r.SetQueryParam("version.uuid", qVersionUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
