// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEnginePolicyModifyCollectionReader is a Reader for the DataEnginePolicyModifyCollection structure.
type DataEnginePolicyModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEnginePolicyModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEnginePolicyModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEnginePolicyModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEnginePolicyModifyCollectionOK creates a DataEnginePolicyModifyCollectionOK with default headers values
func NewDataEnginePolicyModifyCollectionOK() *DataEnginePolicyModifyCollectionOK {
	return &DataEnginePolicyModifyCollectionOK{}
}

/*
DataEnginePolicyModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DataEnginePolicyModifyCollectionOK struct {
}

// IsSuccess returns true when this data engine policy modify collection o k response has a 2xx status code
func (o *DataEnginePolicyModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine policy modify collection o k response has a 3xx status code
func (o *DataEnginePolicyModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine policy modify collection o k response has a 4xx status code
func (o *DataEnginePolicyModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine policy modify collection o k response has a 5xx status code
func (o *DataEnginePolicyModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine policy modify collection o k response a status code equal to that given
func (o *DataEnginePolicyModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine policy modify collection o k response
func (o *DataEnginePolicyModifyCollectionOK) Code() int {
	return 200
}

func (o *DataEnginePolicyModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /data-engine/policies][%d] dataEnginePolicyModifyCollectionOK", 200)
}

func (o *DataEnginePolicyModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /data-engine/policies][%d] dataEnginePolicyModifyCollectionOK", 200)
}

func (o *DataEnginePolicyModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDataEnginePolicyModifyCollectionDefault creates a DataEnginePolicyModifyCollectionDefault with default headers values
func NewDataEnginePolicyModifyCollectionDefault(code int) *DataEnginePolicyModifyCollectionDefault {
	return &DataEnginePolicyModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
DataEnginePolicyModifyCollectionDefault describes a response with status code -1, with default header values.

Error in updating the data engine policy.
*/
type DataEnginePolicyModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine policy modify collection default response has a 2xx status code
func (o *DataEnginePolicyModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine policy modify collection default response has a 3xx status code
func (o *DataEnginePolicyModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine policy modify collection default response has a 4xx status code
func (o *DataEnginePolicyModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine policy modify collection default response has a 5xx status code
func (o *DataEnginePolicyModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine policy modify collection default response a status code equal to that given
func (o *DataEnginePolicyModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine policy modify collection default response
func (o *DataEnginePolicyModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DataEnginePolicyModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/policies][%d] data_engine_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *DataEnginePolicyModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/policies][%d] data_engine_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *DataEnginePolicyModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEnginePolicyModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DataEnginePolicyModifyCollectionBody Defines the structure of the response for data engine policy requests.
swagger:model DataEnginePolicyModifyCollectionBody
*/
type DataEnginePolicyModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The timestamp indicating when the data engine policy was created. This field is auto-generated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// A list of actions to be performed by the data engine policy.
	DataEnginePolicyInlineActions []*models.DataEnginePolicyInlineActionsInlineArrayItem `json:"actions,omitempty"`

	// The list of attributes associated with the data engine policy.
	DataEnginePolicyInlineAttributes []*models.DataEnginePolicyInlineAttributesInlineArrayItem `json:"attributes,omitempty"`

	// A list of conditions that define how the data engine policy should be applied.
	DataEnginePolicyInlineConditions []*models.DataEnginePolicyInlineConditionsInlineArrayItem `json:"conditions,omitempty"`

	// data engine policy response inline records
	DataEnginePolicyResponseInlineRecords []*models.DataEnginePolicy `json:"records,omitempty"`

	// The timestamp indicating when the data engine policy was deleted. This field is auto-generated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	DeleteTime *strfmt.DateTime `json:"delete_time,omitempty"`

	// A detailed description of the data engine policy.
	// Example: Exclude email addresses from the files.
	Description *string `json:"description,omitempty"`

	// Indicates whether the data engine policy is enabled.
	//
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// Name of the data engine policy. This field is required for POST requests.
	// Example: Exclude email addresses.
	Name *string `json:"name,omitempty"`

	// Specifies the scope of the data engine policy. Possible values are:
	// * <i>global</i> - Applies globally.
	// * <i>workspace</i> - Applies to workspaces.
	// * <i>data_source</i> - Applies to data sources.
	// * <i>data_collection</i> - Applies to data collections.
	//
	// Example: global
	// Enum: ["global","workspace","data_source","data_collection"]
	Scope *string `json:"scope,omitempty"`

	// Target resources for the data engine policy.
	// * <i>workspace</i> - Targets workspaces.
	// * <i>data_source</i> - Targets data sources.
	// * <i>data_collection</i> - Targets data collections.
	//
	// Example: workspace
	// Enum: ["workspace","data_source","data_collection"]
	Target *string `json:"target,omitempty"`

	// The total number of data engine policies available.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`

	// Specifies the type of the data engine policy. Possible values are:
	// * <i>data_source_exclusion</i> - A global data source exclusion policy.
	// * <i>classifier</i> - A global classifier enablement policy.
	// * <i>classification_guardrail</i> - A classification guardrail policy.
	//
	// Example: data_source_exclusion
	// Enum: ["data_source_exclusion","classifier","classification_guardrail"]
	Type *string `json:"type,omitempty"`

	// The timestamp indicating when the data engine policy was last updated. This field is auto-generated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// Unique identifier of the data engine policy.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// version
	Version *models.DataEnginePolicyInlineVersion `json:"version,omitempty"`
}

// Validate validates this data engine policy modify collection body
func (o *DataEnginePolicyModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataEnginePolicyInlineActions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataEnginePolicyInlineAttributes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataEnginePolicyInlineConditions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataEnginePolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDeleteTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTarget(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) validateDataEnginePolicyInlineActions(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEnginePolicyInlineActions) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEnginePolicyInlineActions); i++ {
		if swag.IsZero(o.DataEnginePolicyInlineActions[i]) { // not required
			continue
		}

		if o.DataEnginePolicyInlineActions[i] != nil {
			if err := o.DataEnginePolicyInlineActions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "actions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) validateDataEnginePolicyInlineAttributes(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEnginePolicyInlineAttributes) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEnginePolicyInlineAttributes); i++ {
		if swag.IsZero(o.DataEnginePolicyInlineAttributes[i]) { // not required
			continue
		}

		if o.DataEnginePolicyInlineAttributes[i] != nil {
			if err := o.DataEnginePolicyInlineAttributes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "attributes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) validateDataEnginePolicyInlineConditions(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEnginePolicyInlineConditions) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEnginePolicyInlineConditions); i++ {
		if swag.IsZero(o.DataEnginePolicyInlineConditions[i]) { // not required
			continue
		}

		if o.DataEnginePolicyInlineConditions[i] != nil {
			if err := o.DataEnginePolicyInlineConditions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) validateDataEnginePolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEnginePolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DataEnginePolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.DataEnginePolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DataEnginePolicyResponseInlineRecords[i] != nil {
			if err := o.DataEnginePolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) validateDeleteTime(formats strfmt.Registry) error {
	if swag.IsZero(o.DeleteTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"delete_time", "body", "date-time", o.DeleteTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var dataEnginePolicyModifyCollectionBodyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["global","workspace","data_source","data_collection"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEnginePolicyModifyCollectionBodyTypeScopePropEnum = append(dataEnginePolicyModifyCollectionBodyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DataEnginePolicyModifyCollectionBody
	// DataEnginePolicyModifyCollectionBody
	// scope
	// Scope
	// global
	// END DEBUGGING
	// DataEnginePolicyModifyCollectionBodyScopeGlobal captures enum value "global"
	DataEnginePolicyModifyCollectionBodyScopeGlobal string = "global"

	// BEGIN DEBUGGING
	// DataEnginePolicyModifyCollectionBody
	// DataEnginePolicyModifyCollectionBody
	// scope
	// Scope
	// workspace
	// END DEBUGGING
	// DataEnginePolicyModifyCollectionBodyScopeWorkspace captures enum value "workspace"
	DataEnginePolicyModifyCollectionBodyScopeWorkspace string = "workspace"

	// BEGIN DEBUGGING
	// DataEnginePolicyModifyCollectionBody
	// DataEnginePolicyModifyCollectionBody
	// scope
	// Scope
	// data_source
	// END DEBUGGING
	// DataEnginePolicyModifyCollectionBodyScopeDataSource captures enum value "data_source"
	DataEnginePolicyModifyCollectionBodyScopeDataSource string = "data_source"

	// BEGIN DEBUGGING
	// DataEnginePolicyModifyCollectionBody
	// DataEnginePolicyModifyCollectionBody
	// scope
	// Scope
	// data_collection
	// END DEBUGGING
	// DataEnginePolicyModifyCollectionBodyScopeDataCollection captures enum value "data_collection"
	DataEnginePolicyModifyCollectionBodyScopeDataCollection string = "data_collection"
)

// prop value enum
func (o *DataEnginePolicyModifyCollectionBody) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEnginePolicyModifyCollectionBodyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("info"+"."+"scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

var dataEnginePolicyModifyCollectionBodyTypeTargetPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["workspace","data_source","data_collection"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEnginePolicyModifyCollectionBodyTypeTargetPropEnum = append(dataEnginePolicyModifyCollectionBodyTypeTargetPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DataEnginePolicyModifyCollectionBody
	// DataEnginePolicyModifyCollectionBody
	// target
	// Target
	// workspace
	// END DEBUGGING
	// DataEnginePolicyModifyCollectionBodyTargetWorkspace captures enum value "workspace"
	DataEnginePolicyModifyCollectionBodyTargetWorkspace string = "workspace"

	// BEGIN DEBUGGING
	// DataEnginePolicyModifyCollectionBody
	// DataEnginePolicyModifyCollectionBody
	// target
	// Target
	// data_source
	// END DEBUGGING
	// DataEnginePolicyModifyCollectionBodyTargetDataSource captures enum value "data_source"
	DataEnginePolicyModifyCollectionBodyTargetDataSource string = "data_source"

	// BEGIN DEBUGGING
	// DataEnginePolicyModifyCollectionBody
	// DataEnginePolicyModifyCollectionBody
	// target
	// Target
	// data_collection
	// END DEBUGGING
	// DataEnginePolicyModifyCollectionBodyTargetDataCollection captures enum value "data_collection"
	DataEnginePolicyModifyCollectionBodyTargetDataCollection string = "data_collection"
)

// prop value enum
func (o *DataEnginePolicyModifyCollectionBody) validateTargetEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEnginePolicyModifyCollectionBodyTypeTargetPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) validateTarget(formats strfmt.Registry) error {
	if swag.IsZero(o.Target) { // not required
		return nil
	}

	// value enum
	if err := o.validateTargetEnum("info"+"."+"target", "body", *o.Target); err != nil {
		return err
	}

	return nil
}

var dataEnginePolicyModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data_source_exclusion","classifier","classification_guardrail"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEnginePolicyModifyCollectionBodyTypeTypePropEnum = append(dataEnginePolicyModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DataEnginePolicyModifyCollectionBody
	// DataEnginePolicyModifyCollectionBody
	// type
	// Type
	// data_source_exclusion
	// END DEBUGGING
	// DataEnginePolicyModifyCollectionBodyTypeDataSourceExclusion captures enum value "data_source_exclusion"
	DataEnginePolicyModifyCollectionBodyTypeDataSourceExclusion string = "data_source_exclusion"

	// BEGIN DEBUGGING
	// DataEnginePolicyModifyCollectionBody
	// DataEnginePolicyModifyCollectionBody
	// type
	// Type
	// classifier
	// END DEBUGGING
	// DataEnginePolicyModifyCollectionBodyTypeClassifier captures enum value "classifier"
	DataEnginePolicyModifyCollectionBodyTypeClassifier string = "classifier"

	// BEGIN DEBUGGING
	// DataEnginePolicyModifyCollectionBody
	// DataEnginePolicyModifyCollectionBody
	// type
	// Type
	// classification_guardrail
	// END DEBUGGING
	// DataEnginePolicyModifyCollectionBodyTypeClassificationGuardrail captures enum value "classification_guardrail"
	DataEnginePolicyModifyCollectionBodyTypeClassificationGuardrail string = "classification_guardrail"
)

// prop value enum
func (o *DataEnginePolicyModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEnginePolicyModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"update_time", "body", "date-time", o.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(o.Version) { // not required
		return nil
	}

	if o.Version != nil {
		if err := o.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine policy modify collection body based on the context it is used
func (o *DataEnginePolicyModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataEnginePolicyInlineActions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataEnginePolicyInlineAttributes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataEnginePolicyInlineConditions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataEnginePolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDeleteTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) contextValidateDataEnginePolicyInlineActions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEnginePolicyInlineActions); i++ {

		if o.DataEnginePolicyInlineActions[i] != nil {
			if err := o.DataEnginePolicyInlineActions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "actions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) contextValidateDataEnginePolicyInlineAttributes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEnginePolicyInlineAttributes); i++ {

		if o.DataEnginePolicyInlineAttributes[i] != nil {
			if err := o.DataEnginePolicyInlineAttributes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "attributes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) contextValidateDataEnginePolicyInlineConditions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEnginePolicyInlineConditions); i++ {

		if o.DataEnginePolicyInlineConditions[i] != nil {
			if err := o.DataEnginePolicyInlineConditions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) contextValidateDataEnginePolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DataEnginePolicyResponseInlineRecords); i++ {

		if o.DataEnginePolicyResponseInlineRecords[i] != nil {
			if err := o.DataEnginePolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) contextValidateDeleteTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"delete_time", "body", o.DeleteTime); err != nil {
		return err
	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"update_time", "body", o.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *DataEnginePolicyModifyCollectionBody) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if o.Version != nil {
		if err := o.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DataEnginePolicyModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEnginePolicyModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res DataEnginePolicyModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DataEnginePolicyInlineActionsInlineArrayItem data engine policy inline actions inline array item
swagger:model data_engine_policy_inline_actions_inline_array_item
*/
type DataEnginePolicyInlineActionsInlineArrayItem struct {

	// Indicates whether the action is enabled.
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the name of the action to be performed by the data engine policy.
	// Example: classify_email
	Name *string `json:"name,omitempty"`
}

// Validate validates this data engine policy inline actions inline array item
func (o *DataEnginePolicyInlineActionsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this data engine policy inline actions inline array item based on context it is used
func (o *DataEnginePolicyInlineActionsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *DataEnginePolicyInlineActionsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEnginePolicyInlineActionsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEnginePolicyInlineActionsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DataEnginePolicyInlineAttributesInlineArrayItem data engine policy inline attributes inline array item
swagger:model data_engine_policy_inline_attributes_inline_array_item
*/
type DataEnginePolicyInlineAttributesInlineArrayItem struct {

	// The key of the attribute.
	// Example: attribute_key_1
	Key *string `json:"key,omitempty"`

	// The value of the attribute.
	// Example: attribute_value_1
	Value *string `json:"value,omitempty"`
}

// Validate validates this data engine policy inline attributes inline array item
func (o *DataEnginePolicyInlineAttributesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this data engine policy inline attributes inline array item based on context it is used
func (o *DataEnginePolicyInlineAttributesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *DataEnginePolicyInlineAttributesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEnginePolicyInlineAttributesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEnginePolicyInlineAttributesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DataEnginePolicyInlineConditionsInlineArrayItem data engine policy inline conditions inline array item
swagger:model data_engine_policy_inline_conditions_inline_array_item
*/
type DataEnginePolicyInlineConditionsInlineArrayItem struct {

	// Valid JSON string that defines the condition under which the data engine policy is applied.
	// Example: {'type': 'pdf'}
	Condition *string `json:"condition,omitempty"`
}

// Validate validates this data engine policy inline conditions inline array item
func (o *DataEnginePolicyInlineConditionsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this data engine policy inline conditions inline array item based on context it is used
func (o *DataEnginePolicyInlineConditionsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *DataEnginePolicyInlineConditionsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEnginePolicyInlineConditionsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEnginePolicyInlineConditionsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DataEnginePolicyInlineVersion Details of the latest version of the data engine policy.
swagger:model data_engine_policy_inline_version
*/
type DataEnginePolicyInlineVersion struct {

	// Unique identifier of the version.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine policy inline version
func (o *DataEnginePolicyInlineVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DataEnginePolicyInlineVersion) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"version"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine policy inline version based on the context it is used
func (o *DataEnginePolicyInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *DataEnginePolicyInlineVersion) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DataEnginePolicyInlineVersion) UnmarshalBinary(b []byte) error {
	var res DataEnginePolicyInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
