// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDataEnginePolicyModifyParams creates a new DataEnginePolicyModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataEnginePolicyModifyParams() *DataEnginePolicyModifyParams {
	return &DataEnginePolicyModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataEnginePolicyModifyParamsWithTimeout creates a new DataEnginePolicyModifyParams object
// with the ability to set a timeout on a request.
func NewDataEnginePolicyModifyParamsWithTimeout(timeout time.Duration) *DataEnginePolicyModifyParams {
	return &DataEnginePolicyModifyParams{
		timeout: timeout,
	}
}

// NewDataEnginePolicyModifyParamsWithContext creates a new DataEnginePolicyModifyParams object
// with the ability to set a context for a request.
func NewDataEnginePolicyModifyParamsWithContext(ctx context.Context) *DataEnginePolicyModifyParams {
	return &DataEnginePolicyModifyParams{
		Context: ctx,
	}
}

// NewDataEnginePolicyModifyParamsWithHTTPClient creates a new DataEnginePolicyModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataEnginePolicyModifyParamsWithHTTPClient(client *http.Client) *DataEnginePolicyModifyParams {
	return &DataEnginePolicyModifyParams{
		HTTPClient: client,
	}
}

/*
DataEnginePolicyModifyParams contains all the parameters to send to the API endpoint

	for the data engine policy modify operation.

	Typically these are written to a http.Request.
*/
type DataEnginePolicyModifyParams struct {

	/* Info.

	   Data engine policy specification
	*/
	Info *models.DataEnginePolicy

	/* UUID.

	   Unique identifier of the data engine policy.
	*/
	UUID string

	/* ValidateOnly.

	   Validate the operation and its parameters, without actually performing the operation.
	*/
	ValidateOnly *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data engine policy modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEnginePolicyModifyParams) WithDefaults() *DataEnginePolicyModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data engine policy modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataEnginePolicyModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the data engine policy modify params
func (o *DataEnginePolicyModifyParams) WithTimeout(timeout time.Duration) *DataEnginePolicyModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data engine policy modify params
func (o *DataEnginePolicyModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data engine policy modify params
func (o *DataEnginePolicyModifyParams) WithContext(ctx context.Context) *DataEnginePolicyModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data engine policy modify params
func (o *DataEnginePolicyModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data engine policy modify params
func (o *DataEnginePolicyModifyParams) WithHTTPClient(client *http.Client) *DataEnginePolicyModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data engine policy modify params
func (o *DataEnginePolicyModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the data engine policy modify params
func (o *DataEnginePolicyModifyParams) WithInfo(info *models.DataEnginePolicy) *DataEnginePolicyModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the data engine policy modify params
func (o *DataEnginePolicyModifyParams) SetInfo(info *models.DataEnginePolicy) {
	o.Info = info
}

// WithUUID adds the uuid to the data engine policy modify params
func (o *DataEnginePolicyModifyParams) WithUUID(uuid string) *DataEnginePolicyModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the data engine policy modify params
func (o *DataEnginePolicyModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithValidateOnly adds the validateOnly to the data engine policy modify params
func (o *DataEnginePolicyModifyParams) WithValidateOnly(validateOnly *bool) *DataEnginePolicyModifyParams {
	o.SetValidateOnly(validateOnly)
	return o
}

// SetValidateOnly adds the validateOnly to the data engine policy modify params
func (o *DataEnginePolicyModifyParams) SetValidateOnly(validateOnly *bool) {
	o.ValidateOnly = validateOnly
}

// WriteToRequest writes these params to a swagger request
func (o *DataEnginePolicyModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if o.ValidateOnly != nil {

		// query param validate_only
		var qrValidateOnly bool

		if o.ValidateOnly != nil {
			qrValidateOnly = *o.ValidateOnly
		}
		qValidateOnly := swag.FormatBool(qrValidateOnly)
		if qValidateOnly != "" {

			if err := r.SetQueryParam("validate_only", qValidateOnly); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
