// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEnginePolicyModifyReader is a Reader for the DataEnginePolicyModify structure.
type DataEnginePolicyModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEnginePolicyModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEnginePolicyModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEnginePolicyModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEnginePolicyModifyOK creates a DataEnginePolicyModifyOK with default headers values
func NewDataEnginePolicyModifyOK() *DataEnginePolicyModifyOK {
	return &DataEnginePolicyModifyOK{}
}

/*
DataEnginePolicyModifyOK describes a response with status code 200, with default header values.

OK
*/
type DataEnginePolicyModifyOK struct {
}

// IsSuccess returns true when this data engine policy modify o k response has a 2xx status code
func (o *DataEnginePolicyModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine policy modify o k response has a 3xx status code
func (o *DataEnginePolicyModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine policy modify o k response has a 4xx status code
func (o *DataEnginePolicyModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine policy modify o k response has a 5xx status code
func (o *DataEnginePolicyModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine policy modify o k response a status code equal to that given
func (o *DataEnginePolicyModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine policy modify o k response
func (o *DataEnginePolicyModifyOK) Code() int {
	return 200
}

func (o *DataEnginePolicyModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /data-engine/policies/{uuid}][%d] dataEnginePolicyModifyOK", 200)
}

func (o *DataEnginePolicyModifyOK) String() string {
	return fmt.Sprintf("[PATCH /data-engine/policies/{uuid}][%d] dataEnginePolicyModifyOK", 200)
}

func (o *DataEnginePolicyModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDataEnginePolicyModifyDefault creates a DataEnginePolicyModifyDefault with default headers values
func NewDataEnginePolicyModifyDefault(code int) *DataEnginePolicyModifyDefault {
	return &DataEnginePolicyModifyDefault{
		_statusCode: code,
	}
}

/*
DataEnginePolicyModifyDefault describes a response with status code -1, with default header values.

Error in updating the data engine policy.
*/
type DataEnginePolicyModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine policy modify default response has a 2xx status code
func (o *DataEnginePolicyModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine policy modify default response has a 3xx status code
func (o *DataEnginePolicyModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine policy modify default response has a 4xx status code
func (o *DataEnginePolicyModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine policy modify default response has a 5xx status code
func (o *DataEnginePolicyModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine policy modify default response a status code equal to that given
func (o *DataEnginePolicyModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine policy modify default response
func (o *DataEnginePolicyModifyDefault) Code() int {
	return o._statusCode
}

func (o *DataEnginePolicyModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/policies/{uuid}][%d] data_engine_policy_modify default %s", o._statusCode, payload)
}

func (o *DataEnginePolicyModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/policies/{uuid}][%d] data_engine_policy_modify default %s", o._statusCode, payload)
}

func (o *DataEnginePolicyModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEnginePolicyModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
