// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataEnginePolicyVersionCollectionGetReader is a Reader for the DataEnginePolicyVersionCollectionGet structure.
type DataEnginePolicyVersionCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataEnginePolicyVersionCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataEnginePolicyVersionCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataEnginePolicyVersionCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataEnginePolicyVersionCollectionGetOK creates a DataEnginePolicyVersionCollectionGetOK with default headers values
func NewDataEnginePolicyVersionCollectionGetOK() *DataEnginePolicyVersionCollectionGetOK {
	return &DataEnginePolicyVersionCollectionGetOK{}
}

/*
DataEnginePolicyVersionCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DataEnginePolicyVersionCollectionGetOK struct {
	Payload *models.DataEnginePolicyVersionResponse
}

// IsSuccess returns true when this data engine policy version collection get o k response has a 2xx status code
func (o *DataEnginePolicyVersionCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data engine policy version collection get o k response has a 3xx status code
func (o *DataEnginePolicyVersionCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data engine policy version collection get o k response has a 4xx status code
func (o *DataEnginePolicyVersionCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data engine policy version collection get o k response has a 5xx status code
func (o *DataEnginePolicyVersionCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data engine policy version collection get o k response a status code equal to that given
func (o *DataEnginePolicyVersionCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data engine policy version collection get o k response
func (o *DataEnginePolicyVersionCollectionGetOK) Code() int {
	return 200
}

func (o *DataEnginePolicyVersionCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/policies/{data_engine_policy.uuid}/versions][%d] dataEnginePolicyVersionCollectionGetOK %s", 200, payload)
}

func (o *DataEnginePolicyVersionCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/policies/{data_engine_policy.uuid}/versions][%d] dataEnginePolicyVersionCollectionGetOK %s", 200, payload)
}

func (o *DataEnginePolicyVersionCollectionGetOK) GetPayload() *models.DataEnginePolicyVersionResponse {
	return o.Payload
}

func (o *DataEnginePolicyVersionCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEnginePolicyVersionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataEnginePolicyVersionCollectionGetDefault creates a DataEnginePolicyVersionCollectionGetDefault with default headers values
func NewDataEnginePolicyVersionCollectionGetDefault(code int) *DataEnginePolicyVersionCollectionGetDefault {
	return &DataEnginePolicyVersionCollectionGetDefault{
		_statusCode: code,
	}
}

/*
DataEnginePolicyVersionCollectionGetDefault describes a response with status code -1, with default header values.

Error in retrieving the data engine policy versions.
*/
type DataEnginePolicyVersionCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data engine policy version collection get default response has a 2xx status code
func (o *DataEnginePolicyVersionCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data engine policy version collection get default response has a 3xx status code
func (o *DataEnginePolicyVersionCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data engine policy version collection get default response has a 4xx status code
func (o *DataEnginePolicyVersionCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data engine policy version collection get default response has a 5xx status code
func (o *DataEnginePolicyVersionCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data engine policy version collection get default response a status code equal to that given
func (o *DataEnginePolicyVersionCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data engine policy version collection get default response
func (o *DataEnginePolicyVersionCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DataEnginePolicyVersionCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/policies/{data_engine_policy.uuid}/versions][%d] data_engine_policy_version_collection_get default %s", o._statusCode, payload)
}

func (o *DataEnginePolicyVersionCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/policies/{data_engine_policy.uuid}/versions][%d] data_engine_policy_version_collection_get default %s", o._statusCode, payload)
}

func (o *DataEnginePolicyVersionCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataEnginePolicyVersionCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
