// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDataSourceCollectionGetParams creates a new DataSourceCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDataSourceCollectionGetParams() *DataSourceCollectionGetParams {
	return &DataSourceCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDataSourceCollectionGetParamsWithTimeout creates a new DataSourceCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDataSourceCollectionGetParamsWithTimeout(timeout time.Duration) *DataSourceCollectionGetParams {
	return &DataSourceCollectionGetParams{
		timeout: timeout,
	}
}

// NewDataSourceCollectionGetParamsWithContext creates a new DataSourceCollectionGetParams object
// with the ability to set a context for a request.
func NewDataSourceCollectionGetParamsWithContext(ctx context.Context) *DataSourceCollectionGetParams {
	return &DataSourceCollectionGetParams{
		Context: ctx,
	}
}

// NewDataSourceCollectionGetParamsWithHTTPClient creates a new DataSourceCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDataSourceCollectionGetParamsWithHTTPClient(client *http.Client) *DataSourceCollectionGetParams {
	return &DataSourceCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DataSourceCollectionGetParams contains all the parameters to send to the API endpoint

	for the data source collection get operation.

	Typically these are written to a http.Request.
*/
type DataSourceCollectionGetParams struct {

	/* ErrorsErrorCode.

	   Filter by errors.error.code
	*/
	ErrorsErrorCode *string

	/* ErrorsErrorMessage.

	   Filter by errors.error.message
	*/
	ErrorsErrorMessage *string

	/* ErrorsErrorTarget.

	   Filter by errors.error.target
	*/
	ErrorsErrorTarget *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LastRefreshTime.

	   Filter by last_refresh_time
	*/
	LastRefreshTime *string

	/* LocalStorageName.

	   Filter by local_storage.name
	*/
	LocalStorageName *string

	/* LocalStorageSvmName.

	   Filter by local_storage.svm.name
	*/
	LocalStorageSvmName *string

	/* LocalStorageSvmUUID.

	   Filter by local_storage.svm.uuid
	*/
	LocalStorageSvmUUID *string

	/* LocalStorageUUID.

	   Filter by local_storage.uuid
	*/
	LocalStorageUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Message.

	   Filter by message
	*/
	Message *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* RemoteStorageClusterName.

	   Filter by remote_storage.cluster.name
	*/
	RemoteStorageClusterName *string

	/* RemoteStorageClusterUUID.

	   Filter by remote_storage.cluster.uuid
	*/
	RemoteStorageClusterUUID *string

	/* RemoteStorageName.

	   Filter by remote_storage.name
	*/
	RemoteStorageName *string

	/* RemoteStorageSvmName.

	   Filter by remote_storage.svm.name
	*/
	RemoteStorageSvmName *string

	/* RemoteStorageSvmUUID.

	   Filter by remote_storage.svm.uuid
	*/
	RemoteStorageSvmUUID *string

	/* RemoteStorageUUID.

	   Filter by remote_storage.uuid
	*/
	RemoteStorageUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SpaceAvailable.

	   Filter by space.available
	*/
	SpaceAvailable *int64

	/* SpaceTotal.

	   Filter by space.total
	*/
	SpaceTotal *int64

	/* SpaceUsed.

	   Filter by space.used
	*/
	SpaceUsed *int64

	/* State.

	   Filter by state
	*/
	State *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* WorkspacesName.

	   Filter by workspaces.name
	*/
	WorkspacesName *string

	/* WorkspacesUUID.

	   Filter by workspaces.uuid
	*/
	WorkspacesUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the data source collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataSourceCollectionGetParams) WithDefaults() *DataSourceCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the data source collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DataSourceCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DataSourceCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the data source collection get params
func (o *DataSourceCollectionGetParams) WithTimeout(timeout time.Duration) *DataSourceCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the data source collection get params
func (o *DataSourceCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the data source collection get params
func (o *DataSourceCollectionGetParams) WithContext(ctx context.Context) *DataSourceCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the data source collection get params
func (o *DataSourceCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the data source collection get params
func (o *DataSourceCollectionGetParams) WithHTTPClient(client *http.Client) *DataSourceCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the data source collection get params
func (o *DataSourceCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithErrorsErrorCode adds the errorsErrorCode to the data source collection get params
func (o *DataSourceCollectionGetParams) WithErrorsErrorCode(errorsErrorCode *string) *DataSourceCollectionGetParams {
	o.SetErrorsErrorCode(errorsErrorCode)
	return o
}

// SetErrorsErrorCode adds the errorsErrorCode to the data source collection get params
func (o *DataSourceCollectionGetParams) SetErrorsErrorCode(errorsErrorCode *string) {
	o.ErrorsErrorCode = errorsErrorCode
}

// WithErrorsErrorMessage adds the errorsErrorMessage to the data source collection get params
func (o *DataSourceCollectionGetParams) WithErrorsErrorMessage(errorsErrorMessage *string) *DataSourceCollectionGetParams {
	o.SetErrorsErrorMessage(errorsErrorMessage)
	return o
}

// SetErrorsErrorMessage adds the errorsErrorMessage to the data source collection get params
func (o *DataSourceCollectionGetParams) SetErrorsErrorMessage(errorsErrorMessage *string) {
	o.ErrorsErrorMessage = errorsErrorMessage
}

// WithErrorsErrorTarget adds the errorsErrorTarget to the data source collection get params
func (o *DataSourceCollectionGetParams) WithErrorsErrorTarget(errorsErrorTarget *string) *DataSourceCollectionGetParams {
	o.SetErrorsErrorTarget(errorsErrorTarget)
	return o
}

// SetErrorsErrorTarget adds the errorsErrorTarget to the data source collection get params
func (o *DataSourceCollectionGetParams) SetErrorsErrorTarget(errorsErrorTarget *string) {
	o.ErrorsErrorTarget = errorsErrorTarget
}

// WithFields adds the fields to the data source collection get params
func (o *DataSourceCollectionGetParams) WithFields(fields []string) *DataSourceCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the data source collection get params
func (o *DataSourceCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLastRefreshTime adds the lastRefreshTime to the data source collection get params
func (o *DataSourceCollectionGetParams) WithLastRefreshTime(lastRefreshTime *string) *DataSourceCollectionGetParams {
	o.SetLastRefreshTime(lastRefreshTime)
	return o
}

// SetLastRefreshTime adds the lastRefreshTime to the data source collection get params
func (o *DataSourceCollectionGetParams) SetLastRefreshTime(lastRefreshTime *string) {
	o.LastRefreshTime = lastRefreshTime
}

// WithLocalStorageName adds the localStorageName to the data source collection get params
func (o *DataSourceCollectionGetParams) WithLocalStorageName(localStorageName *string) *DataSourceCollectionGetParams {
	o.SetLocalStorageName(localStorageName)
	return o
}

// SetLocalStorageName adds the localStorageName to the data source collection get params
func (o *DataSourceCollectionGetParams) SetLocalStorageName(localStorageName *string) {
	o.LocalStorageName = localStorageName
}

// WithLocalStorageSvmName adds the localStorageSvmName to the data source collection get params
func (o *DataSourceCollectionGetParams) WithLocalStorageSvmName(localStorageSvmName *string) *DataSourceCollectionGetParams {
	o.SetLocalStorageSvmName(localStorageSvmName)
	return o
}

// SetLocalStorageSvmName adds the localStorageSvmName to the data source collection get params
func (o *DataSourceCollectionGetParams) SetLocalStorageSvmName(localStorageSvmName *string) {
	o.LocalStorageSvmName = localStorageSvmName
}

// WithLocalStorageSvmUUID adds the localStorageSvmUUID to the data source collection get params
func (o *DataSourceCollectionGetParams) WithLocalStorageSvmUUID(localStorageSvmUUID *string) *DataSourceCollectionGetParams {
	o.SetLocalStorageSvmUUID(localStorageSvmUUID)
	return o
}

// SetLocalStorageSvmUUID adds the localStorageSvmUuid to the data source collection get params
func (o *DataSourceCollectionGetParams) SetLocalStorageSvmUUID(localStorageSvmUUID *string) {
	o.LocalStorageSvmUUID = localStorageSvmUUID
}

// WithLocalStorageUUID adds the localStorageUUID to the data source collection get params
func (o *DataSourceCollectionGetParams) WithLocalStorageUUID(localStorageUUID *string) *DataSourceCollectionGetParams {
	o.SetLocalStorageUUID(localStorageUUID)
	return o
}

// SetLocalStorageUUID adds the localStorageUuid to the data source collection get params
func (o *DataSourceCollectionGetParams) SetLocalStorageUUID(localStorageUUID *string) {
	o.LocalStorageUUID = localStorageUUID
}

// WithMaxRecords adds the maxRecords to the data source collection get params
func (o *DataSourceCollectionGetParams) WithMaxRecords(maxRecords *int64) *DataSourceCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the data source collection get params
func (o *DataSourceCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMessage adds the message to the data source collection get params
func (o *DataSourceCollectionGetParams) WithMessage(message *string) *DataSourceCollectionGetParams {
	o.SetMessage(message)
	return o
}

// SetMessage adds the message to the data source collection get params
func (o *DataSourceCollectionGetParams) SetMessage(message *string) {
	o.Message = message
}

// WithOrderBy adds the orderBy to the data source collection get params
func (o *DataSourceCollectionGetParams) WithOrderBy(orderBy []string) *DataSourceCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the data source collection get params
func (o *DataSourceCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithRemoteStorageClusterName adds the remoteStorageClusterName to the data source collection get params
func (o *DataSourceCollectionGetParams) WithRemoteStorageClusterName(remoteStorageClusterName *string) *DataSourceCollectionGetParams {
	o.SetRemoteStorageClusterName(remoteStorageClusterName)
	return o
}

// SetRemoteStorageClusterName adds the remoteStorageClusterName to the data source collection get params
func (o *DataSourceCollectionGetParams) SetRemoteStorageClusterName(remoteStorageClusterName *string) {
	o.RemoteStorageClusterName = remoteStorageClusterName
}

// WithRemoteStorageClusterUUID adds the remoteStorageClusterUUID to the data source collection get params
func (o *DataSourceCollectionGetParams) WithRemoteStorageClusterUUID(remoteStorageClusterUUID *string) *DataSourceCollectionGetParams {
	o.SetRemoteStorageClusterUUID(remoteStorageClusterUUID)
	return o
}

// SetRemoteStorageClusterUUID adds the remoteStorageClusterUuid to the data source collection get params
func (o *DataSourceCollectionGetParams) SetRemoteStorageClusterUUID(remoteStorageClusterUUID *string) {
	o.RemoteStorageClusterUUID = remoteStorageClusterUUID
}

// WithRemoteStorageName adds the remoteStorageName to the data source collection get params
func (o *DataSourceCollectionGetParams) WithRemoteStorageName(remoteStorageName *string) *DataSourceCollectionGetParams {
	o.SetRemoteStorageName(remoteStorageName)
	return o
}

// SetRemoteStorageName adds the remoteStorageName to the data source collection get params
func (o *DataSourceCollectionGetParams) SetRemoteStorageName(remoteStorageName *string) {
	o.RemoteStorageName = remoteStorageName
}

// WithRemoteStorageSvmName adds the remoteStorageSvmName to the data source collection get params
func (o *DataSourceCollectionGetParams) WithRemoteStorageSvmName(remoteStorageSvmName *string) *DataSourceCollectionGetParams {
	o.SetRemoteStorageSvmName(remoteStorageSvmName)
	return o
}

// SetRemoteStorageSvmName adds the remoteStorageSvmName to the data source collection get params
func (o *DataSourceCollectionGetParams) SetRemoteStorageSvmName(remoteStorageSvmName *string) {
	o.RemoteStorageSvmName = remoteStorageSvmName
}

// WithRemoteStorageSvmUUID adds the remoteStorageSvmUUID to the data source collection get params
func (o *DataSourceCollectionGetParams) WithRemoteStorageSvmUUID(remoteStorageSvmUUID *string) *DataSourceCollectionGetParams {
	o.SetRemoteStorageSvmUUID(remoteStorageSvmUUID)
	return o
}

// SetRemoteStorageSvmUUID adds the remoteStorageSvmUuid to the data source collection get params
func (o *DataSourceCollectionGetParams) SetRemoteStorageSvmUUID(remoteStorageSvmUUID *string) {
	o.RemoteStorageSvmUUID = remoteStorageSvmUUID
}

// WithRemoteStorageUUID adds the remoteStorageUUID to the data source collection get params
func (o *DataSourceCollectionGetParams) WithRemoteStorageUUID(remoteStorageUUID *string) *DataSourceCollectionGetParams {
	o.SetRemoteStorageUUID(remoteStorageUUID)
	return o
}

// SetRemoteStorageUUID adds the remoteStorageUuid to the data source collection get params
func (o *DataSourceCollectionGetParams) SetRemoteStorageUUID(remoteStorageUUID *string) {
	o.RemoteStorageUUID = remoteStorageUUID
}

// WithReturnRecords adds the returnRecords to the data source collection get params
func (o *DataSourceCollectionGetParams) WithReturnRecords(returnRecords *bool) *DataSourceCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the data source collection get params
func (o *DataSourceCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the data source collection get params
func (o *DataSourceCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DataSourceCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the data source collection get params
func (o *DataSourceCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSpaceAvailable adds the spaceAvailable to the data source collection get params
func (o *DataSourceCollectionGetParams) WithSpaceAvailable(spaceAvailable *int64) *DataSourceCollectionGetParams {
	o.SetSpaceAvailable(spaceAvailable)
	return o
}

// SetSpaceAvailable adds the spaceAvailable to the data source collection get params
func (o *DataSourceCollectionGetParams) SetSpaceAvailable(spaceAvailable *int64) {
	o.SpaceAvailable = spaceAvailable
}

// WithSpaceTotal adds the spaceTotal to the data source collection get params
func (o *DataSourceCollectionGetParams) WithSpaceTotal(spaceTotal *int64) *DataSourceCollectionGetParams {
	o.SetSpaceTotal(spaceTotal)
	return o
}

// SetSpaceTotal adds the spaceTotal to the data source collection get params
func (o *DataSourceCollectionGetParams) SetSpaceTotal(spaceTotal *int64) {
	o.SpaceTotal = spaceTotal
}

// WithSpaceUsed adds the spaceUsed to the data source collection get params
func (o *DataSourceCollectionGetParams) WithSpaceUsed(spaceUsed *int64) *DataSourceCollectionGetParams {
	o.SetSpaceUsed(spaceUsed)
	return o
}

// SetSpaceUsed adds the spaceUsed to the data source collection get params
func (o *DataSourceCollectionGetParams) SetSpaceUsed(spaceUsed *int64) {
	o.SpaceUsed = spaceUsed
}

// WithState adds the state to the data source collection get params
func (o *DataSourceCollectionGetParams) WithState(state *string) *DataSourceCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the data source collection get params
func (o *DataSourceCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithType adds the typeVar to the data source collection get params
func (o *DataSourceCollectionGetParams) WithType(typeVar *string) *DataSourceCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the data source collection get params
func (o *DataSourceCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the data source collection get params
func (o *DataSourceCollectionGetParams) WithUUID(uuid *string) *DataSourceCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the data source collection get params
func (o *DataSourceCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWorkspacesName adds the workspacesName to the data source collection get params
func (o *DataSourceCollectionGetParams) WithWorkspacesName(workspacesName *string) *DataSourceCollectionGetParams {
	o.SetWorkspacesName(workspacesName)
	return o
}

// SetWorkspacesName adds the workspacesName to the data source collection get params
func (o *DataSourceCollectionGetParams) SetWorkspacesName(workspacesName *string) {
	o.WorkspacesName = workspacesName
}

// WithWorkspacesUUID adds the workspacesUUID to the data source collection get params
func (o *DataSourceCollectionGetParams) WithWorkspacesUUID(workspacesUUID *string) *DataSourceCollectionGetParams {
	o.SetWorkspacesUUID(workspacesUUID)
	return o
}

// SetWorkspacesUUID adds the workspacesUuid to the data source collection get params
func (o *DataSourceCollectionGetParams) SetWorkspacesUUID(workspacesUUID *string) {
	o.WorkspacesUUID = workspacesUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DataSourceCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ErrorsErrorCode != nil {

		// query param errors.error.code
		var qrErrorsErrorCode string

		if o.ErrorsErrorCode != nil {
			qrErrorsErrorCode = *o.ErrorsErrorCode
		}
		qErrorsErrorCode := qrErrorsErrorCode
		if qErrorsErrorCode != "" {

			if err := r.SetQueryParam("errors.error.code", qErrorsErrorCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorMessage != nil {

		// query param errors.error.message
		var qrErrorsErrorMessage string

		if o.ErrorsErrorMessage != nil {
			qrErrorsErrorMessage = *o.ErrorsErrorMessage
		}
		qErrorsErrorMessage := qrErrorsErrorMessage
		if qErrorsErrorMessage != "" {

			if err := r.SetQueryParam("errors.error.message", qErrorsErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorTarget != nil {

		// query param errors.error.target
		var qrErrorsErrorTarget string

		if o.ErrorsErrorTarget != nil {
			qrErrorsErrorTarget = *o.ErrorsErrorTarget
		}
		qErrorsErrorTarget := qrErrorsErrorTarget
		if qErrorsErrorTarget != "" {

			if err := r.SetQueryParam("errors.error.target", qErrorsErrorTarget); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LastRefreshTime != nil {

		// query param last_refresh_time
		var qrLastRefreshTime string

		if o.LastRefreshTime != nil {
			qrLastRefreshTime = *o.LastRefreshTime
		}
		qLastRefreshTime := qrLastRefreshTime
		if qLastRefreshTime != "" {

			if err := r.SetQueryParam("last_refresh_time", qLastRefreshTime); err != nil {
				return err
			}
		}
	}

	if o.LocalStorageName != nil {

		// query param local_storage.name
		var qrLocalStorageName string

		if o.LocalStorageName != nil {
			qrLocalStorageName = *o.LocalStorageName
		}
		qLocalStorageName := qrLocalStorageName
		if qLocalStorageName != "" {

			if err := r.SetQueryParam("local_storage.name", qLocalStorageName); err != nil {
				return err
			}
		}
	}

	if o.LocalStorageSvmName != nil {

		// query param local_storage.svm.name
		var qrLocalStorageSvmName string

		if o.LocalStorageSvmName != nil {
			qrLocalStorageSvmName = *o.LocalStorageSvmName
		}
		qLocalStorageSvmName := qrLocalStorageSvmName
		if qLocalStorageSvmName != "" {

			if err := r.SetQueryParam("local_storage.svm.name", qLocalStorageSvmName); err != nil {
				return err
			}
		}
	}

	if o.LocalStorageSvmUUID != nil {

		// query param local_storage.svm.uuid
		var qrLocalStorageSvmUUID string

		if o.LocalStorageSvmUUID != nil {
			qrLocalStorageSvmUUID = *o.LocalStorageSvmUUID
		}
		qLocalStorageSvmUUID := qrLocalStorageSvmUUID
		if qLocalStorageSvmUUID != "" {

			if err := r.SetQueryParam("local_storage.svm.uuid", qLocalStorageSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.LocalStorageUUID != nil {

		// query param local_storage.uuid
		var qrLocalStorageUUID string

		if o.LocalStorageUUID != nil {
			qrLocalStorageUUID = *o.LocalStorageUUID
		}
		qLocalStorageUUID := qrLocalStorageUUID
		if qLocalStorageUUID != "" {

			if err := r.SetQueryParam("local_storage.uuid", qLocalStorageUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Message != nil {

		// query param message
		var qrMessage string

		if o.Message != nil {
			qrMessage = *o.Message
		}
		qMessage := qrMessage
		if qMessage != "" {

			if err := r.SetQueryParam("message", qMessage); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.RemoteStorageClusterName != nil {

		// query param remote_storage.cluster.name
		var qrRemoteStorageClusterName string

		if o.RemoteStorageClusterName != nil {
			qrRemoteStorageClusterName = *o.RemoteStorageClusterName
		}
		qRemoteStorageClusterName := qrRemoteStorageClusterName
		if qRemoteStorageClusterName != "" {

			if err := r.SetQueryParam("remote_storage.cluster.name", qRemoteStorageClusterName); err != nil {
				return err
			}
		}
	}

	if o.RemoteStorageClusterUUID != nil {

		// query param remote_storage.cluster.uuid
		var qrRemoteStorageClusterUUID string

		if o.RemoteStorageClusterUUID != nil {
			qrRemoteStorageClusterUUID = *o.RemoteStorageClusterUUID
		}
		qRemoteStorageClusterUUID := qrRemoteStorageClusterUUID
		if qRemoteStorageClusterUUID != "" {

			if err := r.SetQueryParam("remote_storage.cluster.uuid", qRemoteStorageClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.RemoteStorageName != nil {

		// query param remote_storage.name
		var qrRemoteStorageName string

		if o.RemoteStorageName != nil {
			qrRemoteStorageName = *o.RemoteStorageName
		}
		qRemoteStorageName := qrRemoteStorageName
		if qRemoteStorageName != "" {

			if err := r.SetQueryParam("remote_storage.name", qRemoteStorageName); err != nil {
				return err
			}
		}
	}

	if o.RemoteStorageSvmName != nil {

		// query param remote_storage.svm.name
		var qrRemoteStorageSvmName string

		if o.RemoteStorageSvmName != nil {
			qrRemoteStorageSvmName = *o.RemoteStorageSvmName
		}
		qRemoteStorageSvmName := qrRemoteStorageSvmName
		if qRemoteStorageSvmName != "" {

			if err := r.SetQueryParam("remote_storage.svm.name", qRemoteStorageSvmName); err != nil {
				return err
			}
		}
	}

	if o.RemoteStorageSvmUUID != nil {

		// query param remote_storage.svm.uuid
		var qrRemoteStorageSvmUUID string

		if o.RemoteStorageSvmUUID != nil {
			qrRemoteStorageSvmUUID = *o.RemoteStorageSvmUUID
		}
		qRemoteStorageSvmUUID := qrRemoteStorageSvmUUID
		if qRemoteStorageSvmUUID != "" {

			if err := r.SetQueryParam("remote_storage.svm.uuid", qRemoteStorageSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.RemoteStorageUUID != nil {

		// query param remote_storage.uuid
		var qrRemoteStorageUUID string

		if o.RemoteStorageUUID != nil {
			qrRemoteStorageUUID = *o.RemoteStorageUUID
		}
		qRemoteStorageUUID := qrRemoteStorageUUID
		if qRemoteStorageUUID != "" {

			if err := r.SetQueryParam("remote_storage.uuid", qRemoteStorageUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SpaceAvailable != nil {

		// query param space.available
		var qrSpaceAvailable int64

		if o.SpaceAvailable != nil {
			qrSpaceAvailable = *o.SpaceAvailable
		}
		qSpaceAvailable := swag.FormatInt64(qrSpaceAvailable)
		if qSpaceAvailable != "" {

			if err := r.SetQueryParam("space.available", qSpaceAvailable); err != nil {
				return err
			}
		}
	}

	if o.SpaceTotal != nil {

		// query param space.total
		var qrSpaceTotal int64

		if o.SpaceTotal != nil {
			qrSpaceTotal = *o.SpaceTotal
		}
		qSpaceTotal := swag.FormatInt64(qrSpaceTotal)
		if qSpaceTotal != "" {

			if err := r.SetQueryParam("space.total", qSpaceTotal); err != nil {
				return err
			}
		}
	}

	if o.SpaceUsed != nil {

		// query param space.used
		var qrSpaceUsed int64

		if o.SpaceUsed != nil {
			qrSpaceUsed = *o.SpaceUsed
		}
		qSpaceUsed := swag.FormatInt64(qrSpaceUsed)
		if qSpaceUsed != "" {

			if err := r.SetQueryParam("space.used", qSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.WorkspacesName != nil {

		// query param workspaces.name
		var qrWorkspacesName string

		if o.WorkspacesName != nil {
			qrWorkspacesName = *o.WorkspacesName
		}
		qWorkspacesName := qrWorkspacesName
		if qWorkspacesName != "" {

			if err := r.SetQueryParam("workspaces.name", qWorkspacesName); err != nil {
				return err
			}
		}
	}

	if o.WorkspacesUUID != nil {

		// query param workspaces.uuid
		var qrWorkspacesUUID string

		if o.WorkspacesUUID != nil {
			qrWorkspacesUUID = *o.WorkspacesUUID
		}
		qWorkspacesUUID := qrWorkspacesUUID
		if qWorkspacesUUID != "" {

			if err := r.SetQueryParam("workspaces.uuid", qWorkspacesUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDataSourceCollectionGet binds the parameter fields
func (o *DataSourceCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDataSourceCollectionGet binds the parameter order_by
func (o *DataSourceCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
