// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataSourceCollectionGetReader is a Reader for the DataSourceCollectionGet structure.
type DataSourceCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataSourceCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataSourceCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataSourceCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataSourceCollectionGetOK creates a DataSourceCollectionGetOK with default headers values
func NewDataSourceCollectionGetOK() *DataSourceCollectionGetOK {
	return &DataSourceCollectionGetOK{}
}

/*
DataSourceCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DataSourceCollectionGetOK struct {
	Payload *models.DataSourceResponse
}

// IsSuccess returns true when this data source collection get o k response has a 2xx status code
func (o *DataSourceCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data source collection get o k response has a 3xx status code
func (o *DataSourceCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data source collection get o k response has a 4xx status code
func (o *DataSourceCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data source collection get o k response has a 5xx status code
func (o *DataSourceCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data source collection get o k response a status code equal to that given
func (o *DataSourceCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data source collection get o k response
func (o *DataSourceCollectionGetOK) Code() int {
	return 200
}

func (o *DataSourceCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/data-sources][%d] dataSourceCollectionGetOK %s", 200, payload)
}

func (o *DataSourceCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/data-sources][%d] dataSourceCollectionGetOK %s", 200, payload)
}

func (o *DataSourceCollectionGetOK) GetPayload() *models.DataSourceResponse {
	return o.Payload
}

func (o *DataSourceCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataSourceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataSourceCollectionGetDefault creates a DataSourceCollectionGetDefault with default headers values
func NewDataSourceCollectionGetDefault(code int) *DataSourceCollectionGetDefault {
	return &DataSourceCollectionGetDefault{
		_statusCode: code,
	}
}

/*
DataSourceCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type DataSourceCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data source collection get default response has a 2xx status code
func (o *DataSourceCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data source collection get default response has a 3xx status code
func (o *DataSourceCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data source collection get default response has a 4xx status code
func (o *DataSourceCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data source collection get default response has a 5xx status code
func (o *DataSourceCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data source collection get default response a status code equal to that given
func (o *DataSourceCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data source collection get default response
func (o *DataSourceCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DataSourceCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/data-sources][%d] data_source_collection_get default %s", o._statusCode, payload)
}

func (o *DataSourceCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/data-sources][%d] data_source_collection_get default %s", o._statusCode, payload)
}

func (o *DataSourceCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataSourceCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
