// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DataSourceGetReader is a Reader for the DataSourceGet structure.
type DataSourceGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DataSourceGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDataSourceGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDataSourceGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDataSourceGetOK creates a DataSourceGetOK with default headers values
func NewDataSourceGetOK() *DataSourceGetOK {
	return &DataSourceGetOK{}
}

/*
DataSourceGetOK describes a response with status code 200, with default header values.

OK
*/
type DataSourceGetOK struct {
	Payload *models.DataSource
}

// IsSuccess returns true when this data source get o k response has a 2xx status code
func (o *DataSourceGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this data source get o k response has a 3xx status code
func (o *DataSourceGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this data source get o k response has a 4xx status code
func (o *DataSourceGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this data source get o k response has a 5xx status code
func (o *DataSourceGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this data source get o k response a status code equal to that given
func (o *DataSourceGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the data source get o k response
func (o *DataSourceGetOK) Code() int {
	return 200
}

func (o *DataSourceGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/data-sources/{uuid}][%d] dataSourceGetOK %s", 200, payload)
}

func (o *DataSourceGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/data-sources/{uuid}][%d] dataSourceGetOK %s", 200, payload)
}

func (o *DataSourceGetOK) GetPayload() *models.DataSource {
	return o.Payload
}

func (o *DataSourceGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataSource)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDataSourceGetDefault creates a DataSourceGetDefault with default headers values
func NewDataSourceGetDefault(code int) *DataSourceGetDefault {
	return &DataSourceGetDefault{
		_statusCode: code,
	}
}

/*
	DataSourceGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4 | The data source does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type DataSourceGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this data source get default response has a 2xx status code
func (o *DataSourceGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this data source get default response has a 3xx status code
func (o *DataSourceGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this data source get default response has a 4xx status code
func (o *DataSourceGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this data source get default response has a 5xx status code
func (o *DataSourceGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this data source get default response a status code equal to that given
func (o *DataSourceGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the data source get default response
func (o *DataSourceGetDefault) Code() int {
	return o._statusCode
}

func (o *DataSourceGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/data-sources/{uuid}][%d] data_source_get default %s", o._statusCode, payload)
}

func (o *DataSourceGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/data-sources/{uuid}][%d] data_source_get default %s", o._statusCode, payload)
}

func (o *DataSourceGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DataSourceGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
