// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDatacollectionCollectionGetParams creates a new DatacollectionCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionCollectionGetParams() *DatacollectionCollectionGetParams {
	return &DatacollectionCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionCollectionGetParamsWithTimeout creates a new DatacollectionCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDatacollectionCollectionGetParamsWithTimeout(timeout time.Duration) *DatacollectionCollectionGetParams {
	return &DatacollectionCollectionGetParams{
		timeout: timeout,
	}
}

// NewDatacollectionCollectionGetParamsWithContext creates a new DatacollectionCollectionGetParams object
// with the ability to set a context for a request.
func NewDatacollectionCollectionGetParamsWithContext(ctx context.Context) *DatacollectionCollectionGetParams {
	return &DatacollectionCollectionGetParams{
		Context: ctx,
	}
}

// NewDatacollectionCollectionGetParamsWithHTTPClient creates a new DatacollectionCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionCollectionGetParamsWithHTTPClient(client *http.Client) *DatacollectionCollectionGetParams {
	return &DatacollectionCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DatacollectionCollectionGetParams contains all the parameters to send to the API endpoint

	for the datacollection collection get operation.

	Typically these are written to a http.Request.
*/
type DatacollectionCollectionGetParams struct {

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Description.

	   Filter by description
	*/
	Description *string

	/* EmbeddingChunkSize.

	   Filter by embedding.chunk_size
	*/
	EmbeddingChunkSize *int64

	/* EmbeddingChunkType.

	   Filter by embedding.chunk_type
	*/
	EmbeddingChunkType *string

	/* EmbeddingDimension.

	   Filter by embedding.dimension
	*/
	EmbeddingDimension *int64

	/* EmbeddingEnabled.

	   Filter by embedding.enabled
	*/
	EmbeddingEnabled *bool

	/* EmbeddingQuantization.

	   Filter by embedding.quantization
	*/
	EmbeddingQuantization *string

	/* EmbeddingReRank.

	   Filter by embedding.re_rank
	*/
	EmbeddingReRank *bool

	/* EntitiesUUID.

	   Filter by entities.uuid
	*/
	EntitiesUUID *string

	/* EntityCount.

	   Filter by entity_count
	*/
	EntityCount *int64

	/* ErrorsErrorCode.

	   Filter by errors.error.code
	*/
	ErrorsErrorCode *string

	/* ErrorsErrorMessage.

	   Filter by errors.error.message
	*/
	ErrorsErrorMessage *string

	/* ErrorsErrorTarget.

	   Filter by errors.error.target
	*/
	ErrorsErrorTarget *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LastRefreshTime.

	   Filter by last_refresh_time
	*/
	LastRefreshTime *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Message.

	   Filter by message
	*/
	Message *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Owner.

	   Filter by owner
	*/
	Owner *string

	/* QueryExpression.

	   Filter by query.expression
	*/
	QueryExpression *string

	/* QueryUUID.

	   Filter by query.uuid
	*/
	QueryUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Size.

	   Filter by size
	*/
	Size *int64

	/* State.

	   Filter by state
	*/
	State *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UpdateTime.

	   Filter by update_time
	*/
	UpdateTime *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VersionCurrentJobState.

	   Filter by version.current.job.state
	*/
	VersionCurrentJobState *string

	/* VersionCurrentJobUUID.

	   Filter by version.current.job.uuid
	*/
	VersionCurrentJobUUID *string

	/* VersionCurrentUUID.

	   Filter by version.current.uuid
	*/
	VersionCurrentUUID *string

	/* VersionJobState.

	   Filter by version.job.state
	*/
	VersionJobState *string

	/* VersionJobUUID.

	   Filter by version.job.uuid
	*/
	VersionJobUUID *string

	/* VersionNextJobState.

	   Filter by version.next.job.state
	*/
	VersionNextJobState *string

	/* VersionNextJobUUID.

	   Filter by version.next.job.uuid
	*/
	VersionNextJobUUID *string

	/* VersionNextUUID.

	   Filter by version.next.uuid
	*/
	VersionNextUUID *string

	/* VersionUUID.

	   Filter by version.uuid
	*/
	VersionUUID *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	/* WorkspaceVersionUUID.

	   Filter by workspace.version.uuid
	*/
	WorkspaceVersionUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionCollectionGetParams) WithDefaults() *DatacollectionCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DatacollectionCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithTimeout(timeout time.Duration) *DatacollectionCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithContext(ctx context.Context) *DatacollectionCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithHTTPClient(client *http.Client) *DatacollectionCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCreateTime adds the createTime to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithCreateTime(createTime *string) *DatacollectionCollectionGetParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithDescription adds the description to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithDescription(description *string) *DatacollectionCollectionGetParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetDescription(description *string) {
	o.Description = description
}

// WithEmbeddingChunkSize adds the embeddingChunkSize to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithEmbeddingChunkSize(embeddingChunkSize *int64) *DatacollectionCollectionGetParams {
	o.SetEmbeddingChunkSize(embeddingChunkSize)
	return o
}

// SetEmbeddingChunkSize adds the embeddingChunkSize to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetEmbeddingChunkSize(embeddingChunkSize *int64) {
	o.EmbeddingChunkSize = embeddingChunkSize
}

// WithEmbeddingChunkType adds the embeddingChunkType to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithEmbeddingChunkType(embeddingChunkType *string) *DatacollectionCollectionGetParams {
	o.SetEmbeddingChunkType(embeddingChunkType)
	return o
}

// SetEmbeddingChunkType adds the embeddingChunkType to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetEmbeddingChunkType(embeddingChunkType *string) {
	o.EmbeddingChunkType = embeddingChunkType
}

// WithEmbeddingDimension adds the embeddingDimension to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithEmbeddingDimension(embeddingDimension *int64) *DatacollectionCollectionGetParams {
	o.SetEmbeddingDimension(embeddingDimension)
	return o
}

// SetEmbeddingDimension adds the embeddingDimension to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetEmbeddingDimension(embeddingDimension *int64) {
	o.EmbeddingDimension = embeddingDimension
}

// WithEmbeddingEnabled adds the embeddingEnabled to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithEmbeddingEnabled(embeddingEnabled *bool) *DatacollectionCollectionGetParams {
	o.SetEmbeddingEnabled(embeddingEnabled)
	return o
}

// SetEmbeddingEnabled adds the embeddingEnabled to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetEmbeddingEnabled(embeddingEnabled *bool) {
	o.EmbeddingEnabled = embeddingEnabled
}

// WithEmbeddingQuantization adds the embeddingQuantization to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithEmbeddingQuantization(embeddingQuantization *string) *DatacollectionCollectionGetParams {
	o.SetEmbeddingQuantization(embeddingQuantization)
	return o
}

// SetEmbeddingQuantization adds the embeddingQuantization to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetEmbeddingQuantization(embeddingQuantization *string) {
	o.EmbeddingQuantization = embeddingQuantization
}

// WithEmbeddingReRank adds the embeddingReRank to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithEmbeddingReRank(embeddingReRank *bool) *DatacollectionCollectionGetParams {
	o.SetEmbeddingReRank(embeddingReRank)
	return o
}

// SetEmbeddingReRank adds the embeddingReRank to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetEmbeddingReRank(embeddingReRank *bool) {
	o.EmbeddingReRank = embeddingReRank
}

// WithEntitiesUUID adds the entitiesUUID to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithEntitiesUUID(entitiesUUID *string) *DatacollectionCollectionGetParams {
	o.SetEntitiesUUID(entitiesUUID)
	return o
}

// SetEntitiesUUID adds the entitiesUuid to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetEntitiesUUID(entitiesUUID *string) {
	o.EntitiesUUID = entitiesUUID
}

// WithEntityCount adds the entityCount to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithEntityCount(entityCount *int64) *DatacollectionCollectionGetParams {
	o.SetEntityCount(entityCount)
	return o
}

// SetEntityCount adds the entityCount to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetEntityCount(entityCount *int64) {
	o.EntityCount = entityCount
}

// WithErrorsErrorCode adds the errorsErrorCode to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithErrorsErrorCode(errorsErrorCode *string) *DatacollectionCollectionGetParams {
	o.SetErrorsErrorCode(errorsErrorCode)
	return o
}

// SetErrorsErrorCode adds the errorsErrorCode to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetErrorsErrorCode(errorsErrorCode *string) {
	o.ErrorsErrorCode = errorsErrorCode
}

// WithErrorsErrorMessage adds the errorsErrorMessage to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithErrorsErrorMessage(errorsErrorMessage *string) *DatacollectionCollectionGetParams {
	o.SetErrorsErrorMessage(errorsErrorMessage)
	return o
}

// SetErrorsErrorMessage adds the errorsErrorMessage to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetErrorsErrorMessage(errorsErrorMessage *string) {
	o.ErrorsErrorMessage = errorsErrorMessage
}

// WithErrorsErrorTarget adds the errorsErrorTarget to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithErrorsErrorTarget(errorsErrorTarget *string) *DatacollectionCollectionGetParams {
	o.SetErrorsErrorTarget(errorsErrorTarget)
	return o
}

// SetErrorsErrorTarget adds the errorsErrorTarget to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetErrorsErrorTarget(errorsErrorTarget *string) {
	o.ErrorsErrorTarget = errorsErrorTarget
}

// WithFields adds the fields to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithFields(fields []string) *DatacollectionCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLastRefreshTime adds the lastRefreshTime to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithLastRefreshTime(lastRefreshTime *string) *DatacollectionCollectionGetParams {
	o.SetLastRefreshTime(lastRefreshTime)
	return o
}

// SetLastRefreshTime adds the lastRefreshTime to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetLastRefreshTime(lastRefreshTime *string) {
	o.LastRefreshTime = lastRefreshTime
}

// WithMaxRecords adds the maxRecords to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithMaxRecords(maxRecords *int64) *DatacollectionCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMessage adds the message to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithMessage(message *string) *DatacollectionCollectionGetParams {
	o.SetMessage(message)
	return o
}

// SetMessage adds the message to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetMessage(message *string) {
	o.Message = message
}

// WithName adds the name to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithName(name *string) *DatacollectionCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithOrderBy(orderBy []string) *DatacollectionCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOwner adds the owner to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithOwner(owner *string) *DatacollectionCollectionGetParams {
	o.SetOwner(owner)
	return o
}

// SetOwner adds the owner to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetOwner(owner *string) {
	o.Owner = owner
}

// WithQueryExpression adds the queryExpression to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithQueryExpression(queryExpression *string) *DatacollectionCollectionGetParams {
	o.SetQueryExpression(queryExpression)
	return o
}

// SetQueryExpression adds the queryExpression to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetQueryExpression(queryExpression *string) {
	o.QueryExpression = queryExpression
}

// WithQueryUUID adds the queryUUID to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithQueryUUID(queryUUID *string) *DatacollectionCollectionGetParams {
	o.SetQueryUUID(queryUUID)
	return o
}

// SetQueryUUID adds the queryUuid to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetQueryUUID(queryUUID *string) {
	o.QueryUUID = queryUUID
}

// WithReturnRecords adds the returnRecords to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithReturnRecords(returnRecords *bool) *DatacollectionCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DatacollectionCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSize adds the size to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithSize(size *int64) *DatacollectionCollectionGetParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetSize(size *int64) {
	o.Size = size
}

// WithState adds the state to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithState(state *string) *DatacollectionCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithType adds the typeVar to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithType(typeVar *string) *DatacollectionCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUpdateTime adds the updateTime to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithUpdateTime(updateTime *string) *DatacollectionCollectionGetParams {
	o.SetUpdateTime(updateTime)
	return o
}

// SetUpdateTime adds the updateTime to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetUpdateTime(updateTime *string) {
	o.UpdateTime = updateTime
}

// WithUUID adds the uuid to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithUUID(uuid *string) *DatacollectionCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVersionCurrentJobState adds the versionCurrentJobState to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithVersionCurrentJobState(versionCurrentJobState *string) *DatacollectionCollectionGetParams {
	o.SetVersionCurrentJobState(versionCurrentJobState)
	return o
}

// SetVersionCurrentJobState adds the versionCurrentJobState to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetVersionCurrentJobState(versionCurrentJobState *string) {
	o.VersionCurrentJobState = versionCurrentJobState
}

// WithVersionCurrentJobUUID adds the versionCurrentJobUUID to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithVersionCurrentJobUUID(versionCurrentJobUUID *string) *DatacollectionCollectionGetParams {
	o.SetVersionCurrentJobUUID(versionCurrentJobUUID)
	return o
}

// SetVersionCurrentJobUUID adds the versionCurrentJobUuid to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetVersionCurrentJobUUID(versionCurrentJobUUID *string) {
	o.VersionCurrentJobUUID = versionCurrentJobUUID
}

// WithVersionCurrentUUID adds the versionCurrentUUID to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithVersionCurrentUUID(versionCurrentUUID *string) *DatacollectionCollectionGetParams {
	o.SetVersionCurrentUUID(versionCurrentUUID)
	return o
}

// SetVersionCurrentUUID adds the versionCurrentUuid to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetVersionCurrentUUID(versionCurrentUUID *string) {
	o.VersionCurrentUUID = versionCurrentUUID
}

// WithVersionJobState adds the versionJobState to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithVersionJobState(versionJobState *string) *DatacollectionCollectionGetParams {
	o.SetVersionJobState(versionJobState)
	return o
}

// SetVersionJobState adds the versionJobState to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetVersionJobState(versionJobState *string) {
	o.VersionJobState = versionJobState
}

// WithVersionJobUUID adds the versionJobUUID to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithVersionJobUUID(versionJobUUID *string) *DatacollectionCollectionGetParams {
	o.SetVersionJobUUID(versionJobUUID)
	return o
}

// SetVersionJobUUID adds the versionJobUuid to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetVersionJobUUID(versionJobUUID *string) {
	o.VersionJobUUID = versionJobUUID
}

// WithVersionNextJobState adds the versionNextJobState to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithVersionNextJobState(versionNextJobState *string) *DatacollectionCollectionGetParams {
	o.SetVersionNextJobState(versionNextJobState)
	return o
}

// SetVersionNextJobState adds the versionNextJobState to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetVersionNextJobState(versionNextJobState *string) {
	o.VersionNextJobState = versionNextJobState
}

// WithVersionNextJobUUID adds the versionNextJobUUID to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithVersionNextJobUUID(versionNextJobUUID *string) *DatacollectionCollectionGetParams {
	o.SetVersionNextJobUUID(versionNextJobUUID)
	return o
}

// SetVersionNextJobUUID adds the versionNextJobUuid to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetVersionNextJobUUID(versionNextJobUUID *string) {
	o.VersionNextJobUUID = versionNextJobUUID
}

// WithVersionNextUUID adds the versionNextUUID to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithVersionNextUUID(versionNextUUID *string) *DatacollectionCollectionGetParams {
	o.SetVersionNextUUID(versionNextUUID)
	return o
}

// SetVersionNextUUID adds the versionNextUuid to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetVersionNextUUID(versionNextUUID *string) {
	o.VersionNextUUID = versionNextUUID
}

// WithVersionUUID adds the versionUUID to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithVersionUUID(versionUUID *string) *DatacollectionCollectionGetParams {
	o.SetVersionUUID(versionUUID)
	return o
}

// SetVersionUUID adds the versionUuid to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetVersionUUID(versionUUID *string) {
	o.VersionUUID = versionUUID
}

// WithWorkspaceName adds the workspaceName to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithWorkspaceName(workspaceName *string) *DatacollectionCollectionGetParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionCollectionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WithWorkspaceVersionUUID adds the workspaceVersionUUID to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) WithWorkspaceVersionUUID(workspaceVersionUUID *string) *DatacollectionCollectionGetParams {
	o.SetWorkspaceVersionUUID(workspaceVersionUUID)
	return o
}

// SetWorkspaceVersionUUID adds the workspaceVersionUuid to the datacollection collection get params
func (o *DatacollectionCollectionGetParams) SetWorkspaceVersionUUID(workspaceVersionUUID *string) {
	o.WorkspaceVersionUUID = workspaceVersionUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.EmbeddingChunkSize != nil {

		// query param embedding.chunk_size
		var qrEmbeddingChunkSize int64

		if o.EmbeddingChunkSize != nil {
			qrEmbeddingChunkSize = *o.EmbeddingChunkSize
		}
		qEmbeddingChunkSize := swag.FormatInt64(qrEmbeddingChunkSize)
		if qEmbeddingChunkSize != "" {

			if err := r.SetQueryParam("embedding.chunk_size", qEmbeddingChunkSize); err != nil {
				return err
			}
		}
	}

	if o.EmbeddingChunkType != nil {

		// query param embedding.chunk_type
		var qrEmbeddingChunkType string

		if o.EmbeddingChunkType != nil {
			qrEmbeddingChunkType = *o.EmbeddingChunkType
		}
		qEmbeddingChunkType := qrEmbeddingChunkType
		if qEmbeddingChunkType != "" {

			if err := r.SetQueryParam("embedding.chunk_type", qEmbeddingChunkType); err != nil {
				return err
			}
		}
	}

	if o.EmbeddingDimension != nil {

		// query param embedding.dimension
		var qrEmbeddingDimension int64

		if o.EmbeddingDimension != nil {
			qrEmbeddingDimension = *o.EmbeddingDimension
		}
		qEmbeddingDimension := swag.FormatInt64(qrEmbeddingDimension)
		if qEmbeddingDimension != "" {

			if err := r.SetQueryParam("embedding.dimension", qEmbeddingDimension); err != nil {
				return err
			}
		}
	}

	if o.EmbeddingEnabled != nil {

		// query param embedding.enabled
		var qrEmbeddingEnabled bool

		if o.EmbeddingEnabled != nil {
			qrEmbeddingEnabled = *o.EmbeddingEnabled
		}
		qEmbeddingEnabled := swag.FormatBool(qrEmbeddingEnabled)
		if qEmbeddingEnabled != "" {

			if err := r.SetQueryParam("embedding.enabled", qEmbeddingEnabled); err != nil {
				return err
			}
		}
	}

	if o.EmbeddingQuantization != nil {

		// query param embedding.quantization
		var qrEmbeddingQuantization string

		if o.EmbeddingQuantization != nil {
			qrEmbeddingQuantization = *o.EmbeddingQuantization
		}
		qEmbeddingQuantization := qrEmbeddingQuantization
		if qEmbeddingQuantization != "" {

			if err := r.SetQueryParam("embedding.quantization", qEmbeddingQuantization); err != nil {
				return err
			}
		}
	}

	if o.EmbeddingReRank != nil {

		// query param embedding.re_rank
		var qrEmbeddingReRank bool

		if o.EmbeddingReRank != nil {
			qrEmbeddingReRank = *o.EmbeddingReRank
		}
		qEmbeddingReRank := swag.FormatBool(qrEmbeddingReRank)
		if qEmbeddingReRank != "" {

			if err := r.SetQueryParam("embedding.re_rank", qEmbeddingReRank); err != nil {
				return err
			}
		}
	}

	if o.EntitiesUUID != nil {

		// query param entities.uuid
		var qrEntitiesUUID string

		if o.EntitiesUUID != nil {
			qrEntitiesUUID = *o.EntitiesUUID
		}
		qEntitiesUUID := qrEntitiesUUID
		if qEntitiesUUID != "" {

			if err := r.SetQueryParam("entities.uuid", qEntitiesUUID); err != nil {
				return err
			}
		}
	}

	if o.EntityCount != nil {

		// query param entity_count
		var qrEntityCount int64

		if o.EntityCount != nil {
			qrEntityCount = *o.EntityCount
		}
		qEntityCount := swag.FormatInt64(qrEntityCount)
		if qEntityCount != "" {

			if err := r.SetQueryParam("entity_count", qEntityCount); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorCode != nil {

		// query param errors.error.code
		var qrErrorsErrorCode string

		if o.ErrorsErrorCode != nil {
			qrErrorsErrorCode = *o.ErrorsErrorCode
		}
		qErrorsErrorCode := qrErrorsErrorCode
		if qErrorsErrorCode != "" {

			if err := r.SetQueryParam("errors.error.code", qErrorsErrorCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorMessage != nil {

		// query param errors.error.message
		var qrErrorsErrorMessage string

		if o.ErrorsErrorMessage != nil {
			qrErrorsErrorMessage = *o.ErrorsErrorMessage
		}
		qErrorsErrorMessage := qrErrorsErrorMessage
		if qErrorsErrorMessage != "" {

			if err := r.SetQueryParam("errors.error.message", qErrorsErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorTarget != nil {

		// query param errors.error.target
		var qrErrorsErrorTarget string

		if o.ErrorsErrorTarget != nil {
			qrErrorsErrorTarget = *o.ErrorsErrorTarget
		}
		qErrorsErrorTarget := qrErrorsErrorTarget
		if qErrorsErrorTarget != "" {

			if err := r.SetQueryParam("errors.error.target", qErrorsErrorTarget); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LastRefreshTime != nil {

		// query param last_refresh_time
		var qrLastRefreshTime string

		if o.LastRefreshTime != nil {
			qrLastRefreshTime = *o.LastRefreshTime
		}
		qLastRefreshTime := qrLastRefreshTime
		if qLastRefreshTime != "" {

			if err := r.SetQueryParam("last_refresh_time", qLastRefreshTime); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Message != nil {

		// query param message
		var qrMessage string

		if o.Message != nil {
			qrMessage = *o.Message
		}
		qMessage := qrMessage
		if qMessage != "" {

			if err := r.SetQueryParam("message", qMessage); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Owner != nil {

		// query param owner
		var qrOwner string

		if o.Owner != nil {
			qrOwner = *o.Owner
		}
		qOwner := qrOwner
		if qOwner != "" {

			if err := r.SetQueryParam("owner", qOwner); err != nil {
				return err
			}
		}
	}

	if o.QueryExpression != nil {

		// query param query.expression
		var qrQueryExpression string

		if o.QueryExpression != nil {
			qrQueryExpression = *o.QueryExpression
		}
		qQueryExpression := qrQueryExpression
		if qQueryExpression != "" {

			if err := r.SetQueryParam("query.expression", qQueryExpression); err != nil {
				return err
			}
		}
	}

	if o.QueryUUID != nil {

		// query param query.uuid
		var qrQueryUUID string

		if o.QueryUUID != nil {
			qrQueryUUID = *o.QueryUUID
		}
		qQueryUUID := qrQueryUUID
		if qQueryUUID != "" {

			if err := r.SetQueryParam("query.uuid", qQueryUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Size != nil {

		// query param size
		var qrSize int64

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatInt64(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UpdateTime != nil {

		// query param update_time
		var qrUpdateTime string

		if o.UpdateTime != nil {
			qrUpdateTime = *o.UpdateTime
		}
		qUpdateTime := qrUpdateTime
		if qUpdateTime != "" {

			if err := r.SetQueryParam("update_time", qUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionCurrentJobState != nil {

		// query param version.current.job.state
		var qrVersionCurrentJobState string

		if o.VersionCurrentJobState != nil {
			qrVersionCurrentJobState = *o.VersionCurrentJobState
		}
		qVersionCurrentJobState := qrVersionCurrentJobState
		if qVersionCurrentJobState != "" {

			if err := r.SetQueryParam("version.current.job.state", qVersionCurrentJobState); err != nil {
				return err
			}
		}
	}

	if o.VersionCurrentJobUUID != nil {

		// query param version.current.job.uuid
		var qrVersionCurrentJobUUID string

		if o.VersionCurrentJobUUID != nil {
			qrVersionCurrentJobUUID = *o.VersionCurrentJobUUID
		}
		qVersionCurrentJobUUID := qrVersionCurrentJobUUID
		if qVersionCurrentJobUUID != "" {

			if err := r.SetQueryParam("version.current.job.uuid", qVersionCurrentJobUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionCurrentUUID != nil {

		// query param version.current.uuid
		var qrVersionCurrentUUID string

		if o.VersionCurrentUUID != nil {
			qrVersionCurrentUUID = *o.VersionCurrentUUID
		}
		qVersionCurrentUUID := qrVersionCurrentUUID
		if qVersionCurrentUUID != "" {

			if err := r.SetQueryParam("version.current.uuid", qVersionCurrentUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionJobState != nil {

		// query param version.job.state
		var qrVersionJobState string

		if o.VersionJobState != nil {
			qrVersionJobState = *o.VersionJobState
		}
		qVersionJobState := qrVersionJobState
		if qVersionJobState != "" {

			if err := r.SetQueryParam("version.job.state", qVersionJobState); err != nil {
				return err
			}
		}
	}

	if o.VersionJobUUID != nil {

		// query param version.job.uuid
		var qrVersionJobUUID string

		if o.VersionJobUUID != nil {
			qrVersionJobUUID = *o.VersionJobUUID
		}
		qVersionJobUUID := qrVersionJobUUID
		if qVersionJobUUID != "" {

			if err := r.SetQueryParam("version.job.uuid", qVersionJobUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionNextJobState != nil {

		// query param version.next.job.state
		var qrVersionNextJobState string

		if o.VersionNextJobState != nil {
			qrVersionNextJobState = *o.VersionNextJobState
		}
		qVersionNextJobState := qrVersionNextJobState
		if qVersionNextJobState != "" {

			if err := r.SetQueryParam("version.next.job.state", qVersionNextJobState); err != nil {
				return err
			}
		}
	}

	if o.VersionNextJobUUID != nil {

		// query param version.next.job.uuid
		var qrVersionNextJobUUID string

		if o.VersionNextJobUUID != nil {
			qrVersionNextJobUUID = *o.VersionNextJobUUID
		}
		qVersionNextJobUUID := qrVersionNextJobUUID
		if qVersionNextJobUUID != "" {

			if err := r.SetQueryParam("version.next.job.uuid", qVersionNextJobUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionNextUUID != nil {

		// query param version.next.uuid
		var qrVersionNextUUID string

		if o.VersionNextUUID != nil {
			qrVersionNextUUID = *o.VersionNextUUID
		}
		qVersionNextUUID := qrVersionNextUUID
		if qVersionNextUUID != "" {

			if err := r.SetQueryParam("version.next.uuid", qVersionNextUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionUUID != nil {

		// query param version.uuid
		var qrVersionUUID string

		if o.VersionUUID != nil {
			qrVersionUUID = *o.VersionUUID
		}
		qVersionUUID := qrVersionUUID
		if qVersionUUID != "" {

			if err := r.SetQueryParam("version.uuid", qVersionUUID); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if o.WorkspaceVersionUUID != nil {

		// query param workspace.version.uuid
		var qrWorkspaceVersionUUID string

		if o.WorkspaceVersionUUID != nil {
			qrWorkspaceVersionUUID = *o.WorkspaceVersionUUID
		}
		qWorkspaceVersionUUID := qrWorkspaceVersionUUID
		if qWorkspaceVersionUUID != "" {

			if err := r.SetQueryParam("workspace.version.uuid", qWorkspaceVersionUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDatacollectionCollectionGet binds the parameter fields
func (o *DatacollectionCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDatacollectionCollectionGet binds the parameter order_by
func (o *DatacollectionCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
