// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDatacollectionCreateParams creates a new DatacollectionCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionCreateParams() *DatacollectionCreateParams {
	return &DatacollectionCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionCreateParamsWithTimeout creates a new DatacollectionCreateParams object
// with the ability to set a timeout on a request.
func NewDatacollectionCreateParamsWithTimeout(timeout time.Duration) *DatacollectionCreateParams {
	return &DatacollectionCreateParams{
		timeout: timeout,
	}
}

// NewDatacollectionCreateParamsWithContext creates a new DatacollectionCreateParams object
// with the ability to set a context for a request.
func NewDatacollectionCreateParamsWithContext(ctx context.Context) *DatacollectionCreateParams {
	return &DatacollectionCreateParams{
		Context: ctx,
	}
}

// NewDatacollectionCreateParamsWithHTTPClient creates a new DatacollectionCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionCreateParamsWithHTTPClient(client *http.Client) *DatacollectionCreateParams {
	return &DatacollectionCreateParams{
		HTTPClient: client,
	}
}

/*
DatacollectionCreateParams contains all the parameters to send to the API endpoint

	for the datacollection create operation.

	Typically these are written to a http.Request.
*/
type DatacollectionCreateParams struct {

	/* Info.

	   Data collection specification
	*/
	Info *models.Datacollection

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionCreateParams) WithDefaults() *DatacollectionCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := DatacollectionCreateParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the datacollection create params
func (o *DatacollectionCreateParams) WithTimeout(timeout time.Duration) *DatacollectionCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection create params
func (o *DatacollectionCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection create params
func (o *DatacollectionCreateParams) WithContext(ctx context.Context) *DatacollectionCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection create params
func (o *DatacollectionCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection create params
func (o *DatacollectionCreateParams) WithHTTPClient(client *http.Client) *DatacollectionCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection create params
func (o *DatacollectionCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the datacollection create params
func (o *DatacollectionCreateParams) WithInfo(info *models.Datacollection) *DatacollectionCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the datacollection create params
func (o *DatacollectionCreateParams) SetInfo(info *models.Datacollection) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the datacollection create params
func (o *DatacollectionCreateParams) WithReturnRecords(returnRecords *bool) *DatacollectionCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the datacollection create params
func (o *DatacollectionCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the datacollection create params
func (o *DatacollectionCreateParams) WithReturnTimeout(returnTimeout *int64) *DatacollectionCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the datacollection create params
func (o *DatacollectionCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection create params
func (o *DatacollectionCreateParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionCreateParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection create params
func (o *DatacollectionCreateParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
