// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionCreateReader is a Reader for the DatacollectionCreate structure.
type DatacollectionCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewDatacollectionCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDatacollectionCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionCreateCreated creates a DatacollectionCreateCreated with default headers values
func NewDatacollectionCreateCreated() *DatacollectionCreateCreated {
	return &DatacollectionCreateCreated{}
}

/*
DatacollectionCreateCreated describes a response with status code 201, with default header values.

Created
*/
type DatacollectionCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DatacollectionResponse
}

// IsSuccess returns true when this datacollection create created response has a 2xx status code
func (o *DatacollectionCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection create created response has a 3xx status code
func (o *DatacollectionCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection create created response has a 4xx status code
func (o *DatacollectionCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection create created response has a 5xx status code
func (o *DatacollectionCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection create created response a status code equal to that given
func (o *DatacollectionCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the datacollection create created response
func (o *DatacollectionCreateCreated) Code() int {
	return 201
}

func (o *DatacollectionCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollectionCreateCreated %s", 201, payload)
}

func (o *DatacollectionCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollectionCreateCreated %s", 201, payload)
}

func (o *DatacollectionCreateCreated) GetPayload() *models.DatacollectionResponse {
	return o.Payload
}

func (o *DatacollectionCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DatacollectionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionCreateAccepted creates a DatacollectionCreateAccepted with default headers values
func NewDatacollectionCreateAccepted() *DatacollectionCreateAccepted {
	return &DatacollectionCreateAccepted{}
}

/*
DatacollectionCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DatacollectionCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this datacollection create accepted response has a 2xx status code
func (o *DatacollectionCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection create accepted response has a 3xx status code
func (o *DatacollectionCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection create accepted response has a 4xx status code
func (o *DatacollectionCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection create accepted response has a 5xx status code
func (o *DatacollectionCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection create accepted response a status code equal to that given
func (o *DatacollectionCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the datacollection create accepted response
func (o *DatacollectionCreateAccepted) Code() int {
	return 202
}

func (o *DatacollectionCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollectionCreateAccepted %s", 202, payload)
}

func (o *DatacollectionCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollectionCreateAccepted %s", 202, payload)
}

func (o *DatacollectionCreateAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *DatacollectionCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionCreateDefault creates a DatacollectionCreateDefault with default headers values
func NewDatacollectionCreateDefault(code int) *DatacollectionCreateDefault {
	return &DatacollectionCreateDefault{
		_statusCode: code,
	}
}

/*
DatacollectionCreateDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection create default response has a 2xx status code
func (o *DatacollectionCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection create default response has a 3xx status code
func (o *DatacollectionCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection create default response has a 4xx status code
func (o *DatacollectionCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection create default response has a 5xx status code
func (o *DatacollectionCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection create default response a status code equal to that given
func (o *DatacollectionCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection create default response
func (o *DatacollectionCreateDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollection_create default %s", o._statusCode, payload)
}

func (o *DatacollectionCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollection_create default %s", o._statusCode, payload)
}

func (o *DatacollectionCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
