// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionDeleteCollectionReader is a Reader for the DatacollectionDeleteCollection structure.
type DatacollectionDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDatacollectionDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDatacollectionDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionDeleteCollectionOK creates a DatacollectionDeleteCollectionOK with default headers values
func NewDatacollectionDeleteCollectionOK() *DatacollectionDeleteCollectionOK {
	return &DatacollectionDeleteCollectionOK{}
}

/*
DatacollectionDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DatacollectionDeleteCollectionOK struct {
}

// IsSuccess returns true when this datacollection delete collection o k response has a 2xx status code
func (o *DatacollectionDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection delete collection o k response has a 3xx status code
func (o *DatacollectionDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection delete collection o k response has a 4xx status code
func (o *DatacollectionDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection delete collection o k response has a 5xx status code
func (o *DatacollectionDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection delete collection o k response a status code equal to that given
func (o *DatacollectionDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the datacollection delete collection o k response
func (o *DatacollectionDeleteCollectionOK) Code() int {
	return 200
}

func (o *DatacollectionDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollectionDeleteCollectionOK", 200)
}

func (o *DatacollectionDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollectionDeleteCollectionOK", 200)
}

func (o *DatacollectionDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDatacollectionDeleteCollectionAccepted creates a DatacollectionDeleteCollectionAccepted with default headers values
func NewDatacollectionDeleteCollectionAccepted() *DatacollectionDeleteCollectionAccepted {
	return &DatacollectionDeleteCollectionAccepted{}
}

/*
DatacollectionDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DatacollectionDeleteCollectionAccepted struct {
	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this datacollection delete collection accepted response has a 2xx status code
func (o *DatacollectionDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection delete collection accepted response has a 3xx status code
func (o *DatacollectionDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection delete collection accepted response has a 4xx status code
func (o *DatacollectionDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection delete collection accepted response has a 5xx status code
func (o *DatacollectionDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection delete collection accepted response a status code equal to that given
func (o *DatacollectionDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the datacollection delete collection accepted response
func (o *DatacollectionDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *DatacollectionDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollectionDeleteCollectionAccepted %s", 202, payload)
}

func (o *DatacollectionDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollectionDeleteCollectionAccepted %s", 202, payload)
}

func (o *DatacollectionDeleteCollectionAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *DatacollectionDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionDeleteCollectionDefault creates a DatacollectionDeleteCollectionDefault with default headers values
func NewDatacollectionDeleteCollectionDefault(code int) *DatacollectionDeleteCollectionDefault {
	return &DatacollectionDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
DatacollectionDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection delete collection default response has a 2xx status code
func (o *DatacollectionDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection delete collection default response has a 3xx status code
func (o *DatacollectionDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection delete collection default response has a 4xx status code
func (o *DatacollectionDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection delete collection default response has a 5xx status code
func (o *DatacollectionDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection delete collection default response a status code equal to that given
func (o *DatacollectionDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection delete collection default response
func (o *DatacollectionDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollection_delete_collection default %s", o._statusCode, payload)
}

func (o *DatacollectionDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollection_delete_collection default %s", o._statusCode, payload)
}

func (o *DatacollectionDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DatacollectionDeleteCollectionBody Response object for data collection.
swagger:model DatacollectionDeleteCollectionBody
*/
type DatacollectionDeleteCollectionBody struct {

	// List of data collection records.
	DatacollectionResponseInlineRecords []*models.Datacollection `json:"records,omitempty"`

	// The total number of data collections present in a workspace.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`
}

// Validate validates this datacollection delete collection body
func (o *DatacollectionDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDatacollectionResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionDeleteCollectionBody) validateDatacollectionResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DatacollectionResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DatacollectionResponseInlineRecords); i++ {
		if swag.IsZero(o.DatacollectionResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DatacollectionResponseInlineRecords[i] != nil {
			if err := o.DatacollectionResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this datacollection delete collection body based on the context it is used
func (o *DatacollectionDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDatacollectionResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionDeleteCollectionBody) contextValidateDatacollectionResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DatacollectionResponseInlineRecords); i++ {

		if o.DatacollectionResponseInlineRecords[i] != nil {
			if err := o.DatacollectionResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DatacollectionDeleteCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DatacollectionDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DatacollectionDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res DatacollectionDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
