// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDatacollectionDeleteParams creates a new DatacollectionDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionDeleteParams() *DatacollectionDeleteParams {
	return &DatacollectionDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionDeleteParamsWithTimeout creates a new DatacollectionDeleteParams object
// with the ability to set a timeout on a request.
func NewDatacollectionDeleteParamsWithTimeout(timeout time.Duration) *DatacollectionDeleteParams {
	return &DatacollectionDeleteParams{
		timeout: timeout,
	}
}

// NewDatacollectionDeleteParamsWithContext creates a new DatacollectionDeleteParams object
// with the ability to set a context for a request.
func NewDatacollectionDeleteParamsWithContext(ctx context.Context) *DatacollectionDeleteParams {
	return &DatacollectionDeleteParams{
		Context: ctx,
	}
}

// NewDatacollectionDeleteParamsWithHTTPClient creates a new DatacollectionDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionDeleteParamsWithHTTPClient(client *http.Client) *DatacollectionDeleteParams {
	return &DatacollectionDeleteParams{
		HTTPClient: client,
	}
}

/*
DatacollectionDeleteParams contains all the parameters to send to the API endpoint

	for the datacollection delete operation.

	Typically these are written to a http.Request.
*/
type DatacollectionDeleteParams struct {

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   Unique identifier of the data collection.
	*/
	UUID string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionDeleteParams) WithDefaults() *DatacollectionDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := DatacollectionDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the datacollection delete params
func (o *DatacollectionDeleteParams) WithTimeout(timeout time.Duration) *DatacollectionDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection delete params
func (o *DatacollectionDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection delete params
func (o *DatacollectionDeleteParams) WithContext(ctx context.Context) *DatacollectionDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection delete params
func (o *DatacollectionDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection delete params
func (o *DatacollectionDeleteParams) WithHTTPClient(client *http.Client) *DatacollectionDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection delete params
func (o *DatacollectionDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithReturnTimeout adds the returnTimeout to the datacollection delete params
func (o *DatacollectionDeleteParams) WithReturnTimeout(returnTimeout *int64) *DatacollectionDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the datacollection delete params
func (o *DatacollectionDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the datacollection delete params
func (o *DatacollectionDeleteParams) WithUUID(uuid string) *DatacollectionDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the datacollection delete params
func (o *DatacollectionDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection delete params
func (o *DatacollectionDeleteParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionDeleteParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection delete params
func (o *DatacollectionDeleteParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
