// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionDeleteReader is a Reader for the DatacollectionDelete structure.
type DatacollectionDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDatacollectionDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDatacollectionDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionDeleteOK creates a DatacollectionDeleteOK with default headers values
func NewDatacollectionDeleteOK() *DatacollectionDeleteOK {
	return &DatacollectionDeleteOK{}
}

/*
DatacollectionDeleteOK describes a response with status code 200, with default header values.

OK
*/
type DatacollectionDeleteOK struct {
}

// IsSuccess returns true when this datacollection delete o k response has a 2xx status code
func (o *DatacollectionDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection delete o k response has a 3xx status code
func (o *DatacollectionDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection delete o k response has a 4xx status code
func (o *DatacollectionDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection delete o k response has a 5xx status code
func (o *DatacollectionDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection delete o k response a status code equal to that given
func (o *DatacollectionDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the datacollection delete o k response
func (o *DatacollectionDeleteOK) Code() int {
	return 200
}

func (o *DatacollectionDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollectionDeleteOK", 200)
}

func (o *DatacollectionDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollectionDeleteOK", 200)
}

func (o *DatacollectionDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDatacollectionDeleteAccepted creates a DatacollectionDeleteAccepted with default headers values
func NewDatacollectionDeleteAccepted() *DatacollectionDeleteAccepted {
	return &DatacollectionDeleteAccepted{}
}

/*
DatacollectionDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DatacollectionDeleteAccepted struct {
	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this datacollection delete accepted response has a 2xx status code
func (o *DatacollectionDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection delete accepted response has a 3xx status code
func (o *DatacollectionDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection delete accepted response has a 4xx status code
func (o *DatacollectionDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection delete accepted response has a 5xx status code
func (o *DatacollectionDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection delete accepted response a status code equal to that given
func (o *DatacollectionDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the datacollection delete accepted response
func (o *DatacollectionDeleteAccepted) Code() int {
	return 202
}

func (o *DatacollectionDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollectionDeleteAccepted %s", 202, payload)
}

func (o *DatacollectionDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollectionDeleteAccepted %s", 202, payload)
}

func (o *DatacollectionDeleteAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *DatacollectionDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionDeleteDefault creates a DatacollectionDeleteDefault with default headers values
func NewDatacollectionDeleteDefault(code int) *DatacollectionDeleteDefault {
	return &DatacollectionDeleteDefault{
		_statusCode: code,
	}
}

/*
DatacollectionDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection delete default response has a 2xx status code
func (o *DatacollectionDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection delete default response has a 3xx status code
func (o *DatacollectionDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection delete default response has a 4xx status code
func (o *DatacollectionDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection delete default response has a 5xx status code
func (o *DatacollectionDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection delete default response a status code equal to that given
func (o *DatacollectionDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection delete default response
func (o *DatacollectionDeleteDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollection_delete default %s", o._statusCode, payload)
}

func (o *DatacollectionDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollection_delete default %s", o._statusCode, payload)
}

func (o *DatacollectionDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
