// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionEntityCollectionGetReader is a Reader for the DatacollectionEntityCollectionGet structure.
type DatacollectionEntityCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionEntityCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDatacollectionEntityCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionEntityCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionEntityCollectionGetOK creates a DatacollectionEntityCollectionGetOK with default headers values
func NewDatacollectionEntityCollectionGetOK() *DatacollectionEntityCollectionGetOK {
	return &DatacollectionEntityCollectionGetOK{}
}

/*
DatacollectionEntityCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DatacollectionEntityCollectionGetOK struct {
	Payload *models.DatacollectionEntityResponse
}

// IsSuccess returns true when this datacollection entity collection get o k response has a 2xx status code
func (o *DatacollectionEntityCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection entity collection get o k response has a 3xx status code
func (o *DatacollectionEntityCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection entity collection get o k response has a 4xx status code
func (o *DatacollectionEntityCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection entity collection get o k response has a 5xx status code
func (o *DatacollectionEntityCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection entity collection get o k response a status code equal to that given
func (o *DatacollectionEntityCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the datacollection entity collection get o k response
func (o *DatacollectionEntityCollectionGetOK) Code() int {
	return 200
}

func (o *DatacollectionEntityCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollectionEntityCollectionGetOK %s", 200, payload)
}

func (o *DatacollectionEntityCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollectionEntityCollectionGetOK %s", 200, payload)
}

func (o *DatacollectionEntityCollectionGetOK) GetPayload() *models.DatacollectionEntityResponse {
	return o.Payload
}

func (o *DatacollectionEntityCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DatacollectionEntityResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionEntityCollectionGetDefault creates a DatacollectionEntityCollectionGetDefault with default headers values
func NewDatacollectionEntityCollectionGetDefault(code int) *DatacollectionEntityCollectionGetDefault {
	return &DatacollectionEntityCollectionGetDefault{
		_statusCode: code,
	}
}

/*
DatacollectionEntityCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionEntityCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection entity collection get default response has a 2xx status code
func (o *DatacollectionEntityCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection entity collection get default response has a 3xx status code
func (o *DatacollectionEntityCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection entity collection get default response has a 4xx status code
func (o *DatacollectionEntityCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection entity collection get default response has a 5xx status code
func (o *DatacollectionEntityCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection entity collection get default response a status code equal to that given
func (o *DatacollectionEntityCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection entity collection get default response
func (o *DatacollectionEntityCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionEntityCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollection_entity_collection_get default %s", o._statusCode, payload)
}

func (o *DatacollectionEntityCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollection_entity_collection_get default %s", o._statusCode, payload)
}

func (o *DatacollectionEntityCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionEntityCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
