// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDatacollectionEntityCreateParams creates a new DatacollectionEntityCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionEntityCreateParams() *DatacollectionEntityCreateParams {
	return &DatacollectionEntityCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionEntityCreateParamsWithTimeout creates a new DatacollectionEntityCreateParams object
// with the ability to set a timeout on a request.
func NewDatacollectionEntityCreateParamsWithTimeout(timeout time.Duration) *DatacollectionEntityCreateParams {
	return &DatacollectionEntityCreateParams{
		timeout: timeout,
	}
}

// NewDatacollectionEntityCreateParamsWithContext creates a new DatacollectionEntityCreateParams object
// with the ability to set a context for a request.
func NewDatacollectionEntityCreateParamsWithContext(ctx context.Context) *DatacollectionEntityCreateParams {
	return &DatacollectionEntityCreateParams{
		Context: ctx,
	}
}

// NewDatacollectionEntityCreateParamsWithHTTPClient creates a new DatacollectionEntityCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionEntityCreateParamsWithHTTPClient(client *http.Client) *DatacollectionEntityCreateParams {
	return &DatacollectionEntityCreateParams{
		HTTPClient: client,
	}
}

/*
DatacollectionEntityCreateParams contains all the parameters to send to the API endpoint

	for the datacollection entity create operation.

	Typically these are written to a http.Request.
*/
type DatacollectionEntityCreateParams struct {

	/* DatacollectionUUID.

	   Unique identifier of the data collection.
	*/
	DatacollectionUUID string

	/* Info.

	   Entity specification.
	*/
	Info *models.DatacollectionEntity

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection entity create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionEntityCreateParams) WithDefaults() *DatacollectionEntityCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection entity create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionEntityCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := DatacollectionEntityCreateParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) WithTimeout(timeout time.Duration) *DatacollectionEntityCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) WithContext(ctx context.Context) *DatacollectionEntityCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) WithHTTPClient(client *http.Client) *DatacollectionEntityCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDatacollectionUUID adds the datacollectionUUID to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) WithDatacollectionUUID(datacollectionUUID string) *DatacollectionEntityCreateParams {
	o.SetDatacollectionUUID(datacollectionUUID)
	return o
}

// SetDatacollectionUUID adds the datacollectionUuid to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) SetDatacollectionUUID(datacollectionUUID string) {
	o.DatacollectionUUID = datacollectionUUID
}

// WithInfo adds the info to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) WithInfo(info *models.DatacollectionEntity) *DatacollectionEntityCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) SetInfo(info *models.DatacollectionEntity) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) WithReturnRecords(returnRecords *bool) *DatacollectionEntityCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) WithReturnTimeout(returnTimeout *int64) *DatacollectionEntityCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionEntityCreateParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection entity create params
func (o *DatacollectionEntityCreateParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionEntityCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param datacollection.uuid
	if err := r.SetPathParam("datacollection.uuid", o.DatacollectionUUID); err != nil {
		return err
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
