// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionEntityCreateReader is a Reader for the DatacollectionEntityCreate structure.
type DatacollectionEntityCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionEntityCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewDatacollectionEntityCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDatacollectionEntityCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionEntityCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionEntityCreateCreated creates a DatacollectionEntityCreateCreated with default headers values
func NewDatacollectionEntityCreateCreated() *DatacollectionEntityCreateCreated {
	return &DatacollectionEntityCreateCreated{}
}

/*
DatacollectionEntityCreateCreated describes a response with status code 201, with default header values.

Created
*/
type DatacollectionEntityCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DatacollectionEntityResponse
}

// IsSuccess returns true when this datacollection entity create created response has a 2xx status code
func (o *DatacollectionEntityCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection entity create created response has a 3xx status code
func (o *DatacollectionEntityCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection entity create created response has a 4xx status code
func (o *DatacollectionEntityCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection entity create created response has a 5xx status code
func (o *DatacollectionEntityCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection entity create created response a status code equal to that given
func (o *DatacollectionEntityCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the datacollection entity create created response
func (o *DatacollectionEntityCreateCreated) Code() int {
	return 201
}

func (o *DatacollectionEntityCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollectionEntityCreateCreated %s", 201, payload)
}

func (o *DatacollectionEntityCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollectionEntityCreateCreated %s", 201, payload)
}

func (o *DatacollectionEntityCreateCreated) GetPayload() *models.DatacollectionEntityResponse {
	return o.Payload
}

func (o *DatacollectionEntityCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DatacollectionEntityResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionEntityCreateAccepted creates a DatacollectionEntityCreateAccepted with default headers values
func NewDatacollectionEntityCreateAccepted() *DatacollectionEntityCreateAccepted {
	return &DatacollectionEntityCreateAccepted{}
}

/*
DatacollectionEntityCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DatacollectionEntityCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this datacollection entity create accepted response has a 2xx status code
func (o *DatacollectionEntityCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection entity create accepted response has a 3xx status code
func (o *DatacollectionEntityCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection entity create accepted response has a 4xx status code
func (o *DatacollectionEntityCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection entity create accepted response has a 5xx status code
func (o *DatacollectionEntityCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection entity create accepted response a status code equal to that given
func (o *DatacollectionEntityCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the datacollection entity create accepted response
func (o *DatacollectionEntityCreateAccepted) Code() int {
	return 202
}

func (o *DatacollectionEntityCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollectionEntityCreateAccepted %s", 202, payload)
}

func (o *DatacollectionEntityCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollectionEntityCreateAccepted %s", 202, payload)
}

func (o *DatacollectionEntityCreateAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *DatacollectionEntityCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionEntityCreateDefault creates a DatacollectionEntityCreateDefault with default headers values
func NewDatacollectionEntityCreateDefault(code int) *DatacollectionEntityCreateDefault {
	return &DatacollectionEntityCreateDefault{
		_statusCode: code,
	}
}

/*
DatacollectionEntityCreateDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionEntityCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection entity create default response has a 2xx status code
func (o *DatacollectionEntityCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection entity create default response has a 3xx status code
func (o *DatacollectionEntityCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection entity create default response has a 4xx status code
func (o *DatacollectionEntityCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection entity create default response has a 5xx status code
func (o *DatacollectionEntityCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection entity create default response a status code equal to that given
func (o *DatacollectionEntityCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection entity create default response
func (o *DatacollectionEntityCreateDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionEntityCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollection_entity_create default %s", o._statusCode, payload)
}

func (o *DatacollectionEntityCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollection_entity_create default %s", o._statusCode, payload)
}

func (o *DatacollectionEntityCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionEntityCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
