// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDatacollectionEntityDeleteCollectionParams creates a new DatacollectionEntityDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionEntityDeleteCollectionParams() *DatacollectionEntityDeleteCollectionParams {
	return &DatacollectionEntityDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionEntityDeleteCollectionParamsWithTimeout creates a new DatacollectionEntityDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewDatacollectionEntityDeleteCollectionParamsWithTimeout(timeout time.Duration) *DatacollectionEntityDeleteCollectionParams {
	return &DatacollectionEntityDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewDatacollectionEntityDeleteCollectionParamsWithContext creates a new DatacollectionEntityDeleteCollectionParams object
// with the ability to set a context for a request.
func NewDatacollectionEntityDeleteCollectionParamsWithContext(ctx context.Context) *DatacollectionEntityDeleteCollectionParams {
	return &DatacollectionEntityDeleteCollectionParams{
		Context: ctx,
	}
}

// NewDatacollectionEntityDeleteCollectionParamsWithHTTPClient creates a new DatacollectionEntityDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionEntityDeleteCollectionParamsWithHTTPClient(client *http.Client) *DatacollectionEntityDeleteCollectionParams {
	return &DatacollectionEntityDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
DatacollectionEntityDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the datacollection entity delete collection operation.

	Typically these are written to a http.Request.
*/
type DatacollectionEntityDeleteCollectionParams struct {

	/* AccessTime.

	   Filter by access_time
	*/
	AccessTime *string

	/* AttributesContentKey.

	   Filter by attributes.content.key
	*/
	AttributesContentKey *string

	/* AttributesContentValue.

	   Filter by attributes.content.value
	*/
	AttributesContentValue *string

	/* AttributesCustomKey.

	   Filter by attributes.custom.key
	*/
	AttributesCustomKey *string

	/* AttributesCustomValue.

	   Filter by attributes.custom.value
	*/
	AttributesCustomValue *string

	/* AttributesExtendedKey.

	   Filter by attributes.extended.key
	*/
	AttributesExtendedKey *string

	/* AttributesExtendedValue.

	   Filter by attributes.extended.value
	*/
	AttributesExtendedValue *string

	/* AttributesSystemKey.

	   Filter by attributes.system.key
	*/
	AttributesSystemKey *string

	/* AttributesSystemValue.

	   Filter by attributes.system.value
	*/
	AttributesSystemValue *string

	/* CanPreview.

	   Filter by can_preview
	*/
	CanPreview *bool

	/* ContentHash.

	   Filter by content_hash
	*/
	ContentHash *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* DatacollectionName.

	   Filter by datacollection.name
	*/
	DatacollectionName *string

	/* DatacollectionUUID.

	   Unique identifier of the data collection.
	*/
	DatacollectionUUID string

	/* DatasourceName.

	   Filter by datasource.name
	*/
	DatasourceName *string

	/* DatasourceUUID.

	   Filter by datasource.uuid
	*/
	DatasourceUUID *string

	/* DatasourceVersionUUID.

	   Filter by datasource.version.uuid
	*/
	DatasourceVersionUUID *string

	/* ErrorsErrorCode.

	   Filter by errors.error.code
	*/
	ErrorsErrorCode *string

	/* ErrorsErrorMessage.

	   Filter by errors.error.message
	*/
	ErrorsErrorMessage *string

	/* ErrorsErrorTarget.

	   Filter by errors.error.target
	*/
	ErrorsErrorTarget *string

	/* Extension.

	   Filter by extension
	*/
	Extension *string

	/* Format.

	   Filter by format
	*/
	Format *string

	/* HasPii.

	   Filter by has_pii
	*/
	HasPii *bool

	/* Info.

	   Info specification
	*/
	Info DatacollectionEntityDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* PermissionsKey.

	   Filter by permissions.key
	*/
	PermissionsKey *string

	/* PermissionsValue.

	   Filter by permissions.value
	*/
	PermissionsValue *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Size.

	   Filter by size
	*/
	Size *int64

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UpdateTime.

	   Filter by update_time
	*/
	UpdateTime *string

	/* URI.

	   Filter by uri
	*/
	URI *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	/* WorkspaceVersionUUID.

	   Filter by workspace.version.uuid
	*/
	WorkspaceVersionUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection entity delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionEntityDeleteCollectionParams) WithDefaults() *DatacollectionEntityDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection entity delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionEntityDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := DatacollectionEntityDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithTimeout(timeout time.Duration) *DatacollectionEntityDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithContext(ctx context.Context) *DatacollectionEntityDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithHTTPClient(client *http.Client) *DatacollectionEntityDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccessTime adds the accessTime to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithAccessTime(accessTime *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetAccessTime(accessTime)
	return o
}

// SetAccessTime adds the accessTime to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetAccessTime(accessTime *string) {
	o.AccessTime = accessTime
}

// WithAttributesContentKey adds the attributesContentKey to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithAttributesContentKey(attributesContentKey *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetAttributesContentKey(attributesContentKey)
	return o
}

// SetAttributesContentKey adds the attributesContentKey to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetAttributesContentKey(attributesContentKey *string) {
	o.AttributesContentKey = attributesContentKey
}

// WithAttributesContentValue adds the attributesContentValue to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithAttributesContentValue(attributesContentValue *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetAttributesContentValue(attributesContentValue)
	return o
}

// SetAttributesContentValue adds the attributesContentValue to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetAttributesContentValue(attributesContentValue *string) {
	o.AttributesContentValue = attributesContentValue
}

// WithAttributesCustomKey adds the attributesCustomKey to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithAttributesCustomKey(attributesCustomKey *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetAttributesCustomKey(attributesCustomKey)
	return o
}

// SetAttributesCustomKey adds the attributesCustomKey to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetAttributesCustomKey(attributesCustomKey *string) {
	o.AttributesCustomKey = attributesCustomKey
}

// WithAttributesCustomValue adds the attributesCustomValue to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithAttributesCustomValue(attributesCustomValue *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetAttributesCustomValue(attributesCustomValue)
	return o
}

// SetAttributesCustomValue adds the attributesCustomValue to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetAttributesCustomValue(attributesCustomValue *string) {
	o.AttributesCustomValue = attributesCustomValue
}

// WithAttributesExtendedKey adds the attributesExtendedKey to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithAttributesExtendedKey(attributesExtendedKey *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetAttributesExtendedKey(attributesExtendedKey)
	return o
}

// SetAttributesExtendedKey adds the attributesExtendedKey to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetAttributesExtendedKey(attributesExtendedKey *string) {
	o.AttributesExtendedKey = attributesExtendedKey
}

// WithAttributesExtendedValue adds the attributesExtendedValue to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithAttributesExtendedValue(attributesExtendedValue *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetAttributesExtendedValue(attributesExtendedValue)
	return o
}

// SetAttributesExtendedValue adds the attributesExtendedValue to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetAttributesExtendedValue(attributesExtendedValue *string) {
	o.AttributesExtendedValue = attributesExtendedValue
}

// WithAttributesSystemKey adds the attributesSystemKey to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithAttributesSystemKey(attributesSystemKey *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetAttributesSystemKey(attributesSystemKey)
	return o
}

// SetAttributesSystemKey adds the attributesSystemKey to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetAttributesSystemKey(attributesSystemKey *string) {
	o.AttributesSystemKey = attributesSystemKey
}

// WithAttributesSystemValue adds the attributesSystemValue to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithAttributesSystemValue(attributesSystemValue *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetAttributesSystemValue(attributesSystemValue)
	return o
}

// SetAttributesSystemValue adds the attributesSystemValue to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetAttributesSystemValue(attributesSystemValue *string) {
	o.AttributesSystemValue = attributesSystemValue
}

// WithCanPreview adds the canPreview to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithCanPreview(canPreview *bool) *DatacollectionEntityDeleteCollectionParams {
	o.SetCanPreview(canPreview)
	return o
}

// SetCanPreview adds the canPreview to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetCanPreview(canPreview *bool) {
	o.CanPreview = canPreview
}

// WithContentHash adds the contentHash to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithContentHash(contentHash *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetContentHash(contentHash)
	return o
}

// SetContentHash adds the contentHash to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetContentHash(contentHash *string) {
	o.ContentHash = contentHash
}

// WithContinueOnFailure adds the continueOnFailure to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *DatacollectionEntityDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCreateTime adds the createTime to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithCreateTime(createTime *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithDatacollectionName adds the datacollectionName to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithDatacollectionName(datacollectionName *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetDatacollectionName(datacollectionName)
	return o
}

// SetDatacollectionName adds the datacollectionName to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetDatacollectionName(datacollectionName *string) {
	o.DatacollectionName = datacollectionName
}

// WithDatacollectionUUID adds the datacollectionUUID to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithDatacollectionUUID(datacollectionUUID string) *DatacollectionEntityDeleteCollectionParams {
	o.SetDatacollectionUUID(datacollectionUUID)
	return o
}

// SetDatacollectionUUID adds the datacollectionUuid to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetDatacollectionUUID(datacollectionUUID string) {
	o.DatacollectionUUID = datacollectionUUID
}

// WithDatasourceName adds the datasourceName to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithDatasourceName(datasourceName *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetDatasourceName(datasourceName)
	return o
}

// SetDatasourceName adds the datasourceName to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetDatasourceName(datasourceName *string) {
	o.DatasourceName = datasourceName
}

// WithDatasourceUUID adds the datasourceUUID to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithDatasourceUUID(datasourceUUID *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetDatasourceUUID(datasourceUUID)
	return o
}

// SetDatasourceUUID adds the datasourceUuid to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetDatasourceUUID(datasourceUUID *string) {
	o.DatasourceUUID = datasourceUUID
}

// WithDatasourceVersionUUID adds the datasourceVersionUUID to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithDatasourceVersionUUID(datasourceVersionUUID *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetDatasourceVersionUUID(datasourceVersionUUID)
	return o
}

// SetDatasourceVersionUUID adds the datasourceVersionUuid to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetDatasourceVersionUUID(datasourceVersionUUID *string) {
	o.DatasourceVersionUUID = datasourceVersionUUID
}

// WithErrorsErrorCode adds the errorsErrorCode to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithErrorsErrorCode(errorsErrorCode *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetErrorsErrorCode(errorsErrorCode)
	return o
}

// SetErrorsErrorCode adds the errorsErrorCode to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetErrorsErrorCode(errorsErrorCode *string) {
	o.ErrorsErrorCode = errorsErrorCode
}

// WithErrorsErrorMessage adds the errorsErrorMessage to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithErrorsErrorMessage(errorsErrorMessage *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetErrorsErrorMessage(errorsErrorMessage)
	return o
}

// SetErrorsErrorMessage adds the errorsErrorMessage to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetErrorsErrorMessage(errorsErrorMessage *string) {
	o.ErrorsErrorMessage = errorsErrorMessage
}

// WithErrorsErrorTarget adds the errorsErrorTarget to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithErrorsErrorTarget(errorsErrorTarget *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetErrorsErrorTarget(errorsErrorTarget)
	return o
}

// SetErrorsErrorTarget adds the errorsErrorTarget to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetErrorsErrorTarget(errorsErrorTarget *string) {
	o.ErrorsErrorTarget = errorsErrorTarget
}

// WithExtension adds the extension to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithExtension(extension *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetExtension(extension)
	return o
}

// SetExtension adds the extension to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetExtension(extension *string) {
	o.Extension = extension
}

// WithFormat adds the format to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithFormat(format *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetFormat(format *string) {
	o.Format = format
}

// WithHasPii adds the hasPii to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithHasPii(hasPii *bool) *DatacollectionEntityDeleteCollectionParams {
	o.SetHasPii(hasPii)
	return o
}

// SetHasPii adds the hasPii to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetHasPii(hasPii *bool) {
	o.HasPii = hasPii
}

// WithInfo adds the info to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithInfo(info DatacollectionEntityDeleteCollectionBody) *DatacollectionEntityDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetInfo(info DatacollectionEntityDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithName(name *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithPermissionsKey adds the permissionsKey to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithPermissionsKey(permissionsKey *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetPermissionsKey(permissionsKey)
	return o
}

// SetPermissionsKey adds the permissionsKey to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetPermissionsKey(permissionsKey *string) {
	o.PermissionsKey = permissionsKey
}

// WithPermissionsValue adds the permissionsValue to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithPermissionsValue(permissionsValue *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetPermissionsValue(permissionsValue)
	return o
}

// SetPermissionsValue adds the permissionsValue to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetPermissionsValue(permissionsValue *string) {
	o.PermissionsValue = permissionsValue
}

// WithReturnRecords adds the returnRecords to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *DatacollectionEntityDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *DatacollectionEntityDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *DatacollectionEntityDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSize adds the size to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithSize(size *int64) *DatacollectionEntityDeleteCollectionParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetSize(size *int64) {
	o.Size = size
}

// WithType adds the typeVar to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithType(typeVar *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUpdateTime adds the updateTime to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithUpdateTime(updateTime *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetUpdateTime(updateTime)
	return o
}

// SetUpdateTime adds the updateTime to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetUpdateTime(updateTime *string) {
	o.UpdateTime = updateTime
}

// WithURI adds the uri to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithURI(uri *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetURI(uri)
	return o
}

// SetURI adds the uri to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetURI(uri *string) {
	o.URI = uri
}

// WithUUID adds the uuid to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithUUID(uuid *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWorkspaceName adds the workspaceName to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithWorkspaceName(workspaceName *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionEntityDeleteCollectionParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WithWorkspaceVersionUUID adds the workspaceVersionUUID to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) WithWorkspaceVersionUUID(workspaceVersionUUID *string) *DatacollectionEntityDeleteCollectionParams {
	o.SetWorkspaceVersionUUID(workspaceVersionUUID)
	return o
}

// SetWorkspaceVersionUUID adds the workspaceVersionUuid to the datacollection entity delete collection params
func (o *DatacollectionEntityDeleteCollectionParams) SetWorkspaceVersionUUID(workspaceVersionUUID *string) {
	o.WorkspaceVersionUUID = workspaceVersionUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionEntityDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccessTime != nil {

		// query param access_time
		var qrAccessTime string

		if o.AccessTime != nil {
			qrAccessTime = *o.AccessTime
		}
		qAccessTime := qrAccessTime
		if qAccessTime != "" {

			if err := r.SetQueryParam("access_time", qAccessTime); err != nil {
				return err
			}
		}
	}

	if o.AttributesContentKey != nil {

		// query param attributes.content.key
		var qrAttributesContentKey string

		if o.AttributesContentKey != nil {
			qrAttributesContentKey = *o.AttributesContentKey
		}
		qAttributesContentKey := qrAttributesContentKey
		if qAttributesContentKey != "" {

			if err := r.SetQueryParam("attributes.content.key", qAttributesContentKey); err != nil {
				return err
			}
		}
	}

	if o.AttributesContentValue != nil {

		// query param attributes.content.value
		var qrAttributesContentValue string

		if o.AttributesContentValue != nil {
			qrAttributesContentValue = *o.AttributesContentValue
		}
		qAttributesContentValue := qrAttributesContentValue
		if qAttributesContentValue != "" {

			if err := r.SetQueryParam("attributes.content.value", qAttributesContentValue); err != nil {
				return err
			}
		}
	}

	if o.AttributesCustomKey != nil {

		// query param attributes.custom.key
		var qrAttributesCustomKey string

		if o.AttributesCustomKey != nil {
			qrAttributesCustomKey = *o.AttributesCustomKey
		}
		qAttributesCustomKey := qrAttributesCustomKey
		if qAttributesCustomKey != "" {

			if err := r.SetQueryParam("attributes.custom.key", qAttributesCustomKey); err != nil {
				return err
			}
		}
	}

	if o.AttributesCustomValue != nil {

		// query param attributes.custom.value
		var qrAttributesCustomValue string

		if o.AttributesCustomValue != nil {
			qrAttributesCustomValue = *o.AttributesCustomValue
		}
		qAttributesCustomValue := qrAttributesCustomValue
		if qAttributesCustomValue != "" {

			if err := r.SetQueryParam("attributes.custom.value", qAttributesCustomValue); err != nil {
				return err
			}
		}
	}

	if o.AttributesExtendedKey != nil {

		// query param attributes.extended.key
		var qrAttributesExtendedKey string

		if o.AttributesExtendedKey != nil {
			qrAttributesExtendedKey = *o.AttributesExtendedKey
		}
		qAttributesExtendedKey := qrAttributesExtendedKey
		if qAttributesExtendedKey != "" {

			if err := r.SetQueryParam("attributes.extended.key", qAttributesExtendedKey); err != nil {
				return err
			}
		}
	}

	if o.AttributesExtendedValue != nil {

		// query param attributes.extended.value
		var qrAttributesExtendedValue string

		if o.AttributesExtendedValue != nil {
			qrAttributesExtendedValue = *o.AttributesExtendedValue
		}
		qAttributesExtendedValue := qrAttributesExtendedValue
		if qAttributesExtendedValue != "" {

			if err := r.SetQueryParam("attributes.extended.value", qAttributesExtendedValue); err != nil {
				return err
			}
		}
	}

	if o.AttributesSystemKey != nil {

		// query param attributes.system.key
		var qrAttributesSystemKey string

		if o.AttributesSystemKey != nil {
			qrAttributesSystemKey = *o.AttributesSystemKey
		}
		qAttributesSystemKey := qrAttributesSystemKey
		if qAttributesSystemKey != "" {

			if err := r.SetQueryParam("attributes.system.key", qAttributesSystemKey); err != nil {
				return err
			}
		}
	}

	if o.AttributesSystemValue != nil {

		// query param attributes.system.value
		var qrAttributesSystemValue string

		if o.AttributesSystemValue != nil {
			qrAttributesSystemValue = *o.AttributesSystemValue
		}
		qAttributesSystemValue := qrAttributesSystemValue
		if qAttributesSystemValue != "" {

			if err := r.SetQueryParam("attributes.system.value", qAttributesSystemValue); err != nil {
				return err
			}
		}
	}

	if o.CanPreview != nil {

		// query param can_preview
		var qrCanPreview bool

		if o.CanPreview != nil {
			qrCanPreview = *o.CanPreview
		}
		qCanPreview := swag.FormatBool(qrCanPreview)
		if qCanPreview != "" {

			if err := r.SetQueryParam("can_preview", qCanPreview); err != nil {
				return err
			}
		}
	}

	if o.ContentHash != nil {

		// query param content_hash
		var qrContentHash string

		if o.ContentHash != nil {
			qrContentHash = *o.ContentHash
		}
		qContentHash := qrContentHash
		if qContentHash != "" {

			if err := r.SetQueryParam("content_hash", qContentHash); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.DatacollectionName != nil {

		// query param datacollection.name
		var qrDatacollectionName string

		if o.DatacollectionName != nil {
			qrDatacollectionName = *o.DatacollectionName
		}
		qDatacollectionName := qrDatacollectionName
		if qDatacollectionName != "" {

			if err := r.SetQueryParam("datacollection.name", qDatacollectionName); err != nil {
				return err
			}
		}
	}

	// path param datacollection.uuid
	if err := r.SetPathParam("datacollection.uuid", o.DatacollectionUUID); err != nil {
		return err
	}

	if o.DatasourceName != nil {

		// query param datasource.name
		var qrDatasourceName string

		if o.DatasourceName != nil {
			qrDatasourceName = *o.DatasourceName
		}
		qDatasourceName := qrDatasourceName
		if qDatasourceName != "" {

			if err := r.SetQueryParam("datasource.name", qDatasourceName); err != nil {
				return err
			}
		}
	}

	if o.DatasourceUUID != nil {

		// query param datasource.uuid
		var qrDatasourceUUID string

		if o.DatasourceUUID != nil {
			qrDatasourceUUID = *o.DatasourceUUID
		}
		qDatasourceUUID := qrDatasourceUUID
		if qDatasourceUUID != "" {

			if err := r.SetQueryParam("datasource.uuid", qDatasourceUUID); err != nil {
				return err
			}
		}
	}

	if o.DatasourceVersionUUID != nil {

		// query param datasource.version.uuid
		var qrDatasourceVersionUUID string

		if o.DatasourceVersionUUID != nil {
			qrDatasourceVersionUUID = *o.DatasourceVersionUUID
		}
		qDatasourceVersionUUID := qrDatasourceVersionUUID
		if qDatasourceVersionUUID != "" {

			if err := r.SetQueryParam("datasource.version.uuid", qDatasourceVersionUUID); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorCode != nil {

		// query param errors.error.code
		var qrErrorsErrorCode string

		if o.ErrorsErrorCode != nil {
			qrErrorsErrorCode = *o.ErrorsErrorCode
		}
		qErrorsErrorCode := qrErrorsErrorCode
		if qErrorsErrorCode != "" {

			if err := r.SetQueryParam("errors.error.code", qErrorsErrorCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorMessage != nil {

		// query param errors.error.message
		var qrErrorsErrorMessage string

		if o.ErrorsErrorMessage != nil {
			qrErrorsErrorMessage = *o.ErrorsErrorMessage
		}
		qErrorsErrorMessage := qrErrorsErrorMessage
		if qErrorsErrorMessage != "" {

			if err := r.SetQueryParam("errors.error.message", qErrorsErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorTarget != nil {

		// query param errors.error.target
		var qrErrorsErrorTarget string

		if o.ErrorsErrorTarget != nil {
			qrErrorsErrorTarget = *o.ErrorsErrorTarget
		}
		qErrorsErrorTarget := qrErrorsErrorTarget
		if qErrorsErrorTarget != "" {

			if err := r.SetQueryParam("errors.error.target", qErrorsErrorTarget); err != nil {
				return err
			}
		}
	}

	if o.Extension != nil {

		// query param extension
		var qrExtension string

		if o.Extension != nil {
			qrExtension = *o.Extension
		}
		qExtension := qrExtension
		if qExtension != "" {

			if err := r.SetQueryParam("extension", qExtension); err != nil {
				return err
			}
		}
	}

	if o.Format != nil {

		// query param format
		var qrFormat string

		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {

			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}
	}

	if o.HasPii != nil {

		// query param has_pii
		var qrHasPii bool

		if o.HasPii != nil {
			qrHasPii = *o.HasPii
		}
		qHasPii := swag.FormatBool(qrHasPii)
		if qHasPii != "" {

			if err := r.SetQueryParam("has_pii", qHasPii); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.PermissionsKey != nil {

		// query param permissions.key
		var qrPermissionsKey string

		if o.PermissionsKey != nil {
			qrPermissionsKey = *o.PermissionsKey
		}
		qPermissionsKey := qrPermissionsKey
		if qPermissionsKey != "" {

			if err := r.SetQueryParam("permissions.key", qPermissionsKey); err != nil {
				return err
			}
		}
	}

	if o.PermissionsValue != nil {

		// query param permissions.value
		var qrPermissionsValue string

		if o.PermissionsValue != nil {
			qrPermissionsValue = *o.PermissionsValue
		}
		qPermissionsValue := qrPermissionsValue
		if qPermissionsValue != "" {

			if err := r.SetQueryParam("permissions.value", qPermissionsValue); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Size != nil {

		// query param size
		var qrSize int64

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatInt64(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UpdateTime != nil {

		// query param update_time
		var qrUpdateTime string

		if o.UpdateTime != nil {
			qrUpdateTime = *o.UpdateTime
		}
		qUpdateTime := qrUpdateTime
		if qUpdateTime != "" {

			if err := r.SetQueryParam("update_time", qUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.URI != nil {

		// query param uri
		var qrURI string

		if o.URI != nil {
			qrURI = *o.URI
		}
		qURI := qrURI
		if qURI != "" {

			if err := r.SetQueryParam("uri", qURI); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if o.WorkspaceVersionUUID != nil {

		// query param workspace.version.uuid
		var qrWorkspaceVersionUUID string

		if o.WorkspaceVersionUUID != nil {
			qrWorkspaceVersionUUID = *o.WorkspaceVersionUUID
		}
		qWorkspaceVersionUUID := qrWorkspaceVersionUUID
		if qWorkspaceVersionUUID != "" {

			if err := r.SetQueryParam("workspace.version.uuid", qWorkspaceVersionUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
