// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionEntityDeleteCollectionReader is a Reader for the DatacollectionEntityDeleteCollection structure.
type DatacollectionEntityDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionEntityDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDatacollectionEntityDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDatacollectionEntityDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionEntityDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionEntityDeleteCollectionOK creates a DatacollectionEntityDeleteCollectionOK with default headers values
func NewDatacollectionEntityDeleteCollectionOK() *DatacollectionEntityDeleteCollectionOK {
	return &DatacollectionEntityDeleteCollectionOK{}
}

/*
DatacollectionEntityDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DatacollectionEntityDeleteCollectionOK struct {
}

// IsSuccess returns true when this datacollection entity delete collection o k response has a 2xx status code
func (o *DatacollectionEntityDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection entity delete collection o k response has a 3xx status code
func (o *DatacollectionEntityDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection entity delete collection o k response has a 4xx status code
func (o *DatacollectionEntityDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection entity delete collection o k response has a 5xx status code
func (o *DatacollectionEntityDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection entity delete collection o k response a status code equal to that given
func (o *DatacollectionEntityDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the datacollection entity delete collection o k response
func (o *DatacollectionEntityDeleteCollectionOK) Code() int {
	return 200
}

func (o *DatacollectionEntityDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollectionEntityDeleteCollectionOK", 200)
}

func (o *DatacollectionEntityDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollectionEntityDeleteCollectionOK", 200)
}

func (o *DatacollectionEntityDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDatacollectionEntityDeleteCollectionAccepted creates a DatacollectionEntityDeleteCollectionAccepted with default headers values
func NewDatacollectionEntityDeleteCollectionAccepted() *DatacollectionEntityDeleteCollectionAccepted {
	return &DatacollectionEntityDeleteCollectionAccepted{}
}

/*
DatacollectionEntityDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DatacollectionEntityDeleteCollectionAccepted struct {
	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this datacollection entity delete collection accepted response has a 2xx status code
func (o *DatacollectionEntityDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection entity delete collection accepted response has a 3xx status code
func (o *DatacollectionEntityDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection entity delete collection accepted response has a 4xx status code
func (o *DatacollectionEntityDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection entity delete collection accepted response has a 5xx status code
func (o *DatacollectionEntityDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection entity delete collection accepted response a status code equal to that given
func (o *DatacollectionEntityDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the datacollection entity delete collection accepted response
func (o *DatacollectionEntityDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *DatacollectionEntityDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollectionEntityDeleteCollectionAccepted %s", 202, payload)
}

func (o *DatacollectionEntityDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollectionEntityDeleteCollectionAccepted %s", 202, payload)
}

func (o *DatacollectionEntityDeleteCollectionAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *DatacollectionEntityDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionEntityDeleteCollectionDefault creates a DatacollectionEntityDeleteCollectionDefault with default headers values
func NewDatacollectionEntityDeleteCollectionDefault(code int) *DatacollectionEntityDeleteCollectionDefault {
	return &DatacollectionEntityDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
DatacollectionEntityDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionEntityDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection entity delete collection default response has a 2xx status code
func (o *DatacollectionEntityDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection entity delete collection default response has a 3xx status code
func (o *DatacollectionEntityDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection entity delete collection default response has a 4xx status code
func (o *DatacollectionEntityDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection entity delete collection default response has a 5xx status code
func (o *DatacollectionEntityDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection entity delete collection default response a status code equal to that given
func (o *DatacollectionEntityDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection entity delete collection default response
func (o *DatacollectionEntityDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionEntityDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollection_entity_delete_collection default %s", o._statusCode, payload)
}

func (o *DatacollectionEntityDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities][%d] datacollection_entity_delete_collection default %s", o._statusCode, payload)
}

func (o *DatacollectionEntityDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionEntityDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DatacollectionEntityDeleteCollectionBody datacollection entity delete collection body
swagger:model DatacollectionEntityDeleteCollectionBody
*/
type DatacollectionEntityDeleteCollectionBody struct {

	// datacollection entity response inline records
	DatacollectionEntityResponseInlineRecords []*models.DatacollectionEntity `json:"records,omitempty"`

	// The total number of entities present in a data collection.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`
}

// Validate validates this datacollection entity delete collection body
func (o *DatacollectionEntityDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDatacollectionEntityResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionEntityDeleteCollectionBody) validateDatacollectionEntityResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DatacollectionEntityResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DatacollectionEntityResponseInlineRecords); i++ {
		if swag.IsZero(o.DatacollectionEntityResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DatacollectionEntityResponseInlineRecords[i] != nil {
			if err := o.DatacollectionEntityResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this datacollection entity delete collection body based on the context it is used
func (o *DatacollectionEntityDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDatacollectionEntityResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionEntityDeleteCollectionBody) contextValidateDatacollectionEntityResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DatacollectionEntityResponseInlineRecords); i++ {

		if o.DatacollectionEntityResponseInlineRecords[i] != nil {
			if err := o.DatacollectionEntityResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DatacollectionEntityDeleteCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DatacollectionEntityDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DatacollectionEntityDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res DatacollectionEntityDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
