// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionEntityDeleteReader is a Reader for the DatacollectionEntityDelete structure.
type DatacollectionEntityDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionEntityDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDatacollectionEntityDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDatacollectionEntityDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionEntityDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionEntityDeleteOK creates a DatacollectionEntityDeleteOK with default headers values
func NewDatacollectionEntityDeleteOK() *DatacollectionEntityDeleteOK {
	return &DatacollectionEntityDeleteOK{}
}

/*
DatacollectionEntityDeleteOK describes a response with status code 200, with default header values.

OK
*/
type DatacollectionEntityDeleteOK struct {
}

// IsSuccess returns true when this datacollection entity delete o k response has a 2xx status code
func (o *DatacollectionEntityDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection entity delete o k response has a 3xx status code
func (o *DatacollectionEntityDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection entity delete o k response has a 4xx status code
func (o *DatacollectionEntityDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection entity delete o k response has a 5xx status code
func (o *DatacollectionEntityDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection entity delete o k response a status code equal to that given
func (o *DatacollectionEntityDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the datacollection entity delete o k response
func (o *DatacollectionEntityDeleteOK) Code() int {
	return 200
}

func (o *DatacollectionEntityDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities/{uuid}][%d] datacollectionEntityDeleteOK", 200)
}

func (o *DatacollectionEntityDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities/{uuid}][%d] datacollectionEntityDeleteOK", 200)
}

func (o *DatacollectionEntityDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDatacollectionEntityDeleteAccepted creates a DatacollectionEntityDeleteAccepted with default headers values
func NewDatacollectionEntityDeleteAccepted() *DatacollectionEntityDeleteAccepted {
	return &DatacollectionEntityDeleteAccepted{}
}

/*
DatacollectionEntityDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DatacollectionEntityDeleteAccepted struct {
	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this datacollection entity delete accepted response has a 2xx status code
func (o *DatacollectionEntityDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection entity delete accepted response has a 3xx status code
func (o *DatacollectionEntityDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection entity delete accepted response has a 4xx status code
func (o *DatacollectionEntityDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection entity delete accepted response has a 5xx status code
func (o *DatacollectionEntityDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection entity delete accepted response a status code equal to that given
func (o *DatacollectionEntityDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the datacollection entity delete accepted response
func (o *DatacollectionEntityDeleteAccepted) Code() int {
	return 202
}

func (o *DatacollectionEntityDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities/{uuid}][%d] datacollectionEntityDeleteAccepted %s", 202, payload)
}

func (o *DatacollectionEntityDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities/{uuid}][%d] datacollectionEntityDeleteAccepted %s", 202, payload)
}

func (o *DatacollectionEntityDeleteAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *DatacollectionEntityDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionEntityDeleteDefault creates a DatacollectionEntityDeleteDefault with default headers values
func NewDatacollectionEntityDeleteDefault(code int) *DatacollectionEntityDeleteDefault {
	return &DatacollectionEntityDeleteDefault{
		_statusCode: code,
	}
}

/*
DatacollectionEntityDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionEntityDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection entity delete default response has a 2xx status code
func (o *DatacollectionEntityDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection entity delete default response has a 3xx status code
func (o *DatacollectionEntityDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection entity delete default response has a 4xx status code
func (o *DatacollectionEntityDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection entity delete default response has a 5xx status code
func (o *DatacollectionEntityDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection entity delete default response a status code equal to that given
func (o *DatacollectionEntityDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection entity delete default response
func (o *DatacollectionEntityDeleteDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionEntityDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities/{uuid}][%d] datacollection_entity_delete default %s", o._statusCode, payload)
}

func (o *DatacollectionEntityDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities/{uuid}][%d] datacollection_entity_delete default %s", o._statusCode, payload)
}

func (o *DatacollectionEntityDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionEntityDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
