// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDatacollectionEntityGetParams creates a new DatacollectionEntityGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionEntityGetParams() *DatacollectionEntityGetParams {
	return &DatacollectionEntityGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionEntityGetParamsWithTimeout creates a new DatacollectionEntityGetParams object
// with the ability to set a timeout on a request.
func NewDatacollectionEntityGetParamsWithTimeout(timeout time.Duration) *DatacollectionEntityGetParams {
	return &DatacollectionEntityGetParams{
		timeout: timeout,
	}
}

// NewDatacollectionEntityGetParamsWithContext creates a new DatacollectionEntityGetParams object
// with the ability to set a context for a request.
func NewDatacollectionEntityGetParamsWithContext(ctx context.Context) *DatacollectionEntityGetParams {
	return &DatacollectionEntityGetParams{
		Context: ctx,
	}
}

// NewDatacollectionEntityGetParamsWithHTTPClient creates a new DatacollectionEntityGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionEntityGetParamsWithHTTPClient(client *http.Client) *DatacollectionEntityGetParams {
	return &DatacollectionEntityGetParams{
		HTTPClient: client,
	}
}

/*
DatacollectionEntityGetParams contains all the parameters to send to the API endpoint

	for the datacollection entity get operation.

	Typically these are written to a http.Request.
*/
type DatacollectionEntityGetParams struct {

	/* DatacollectionUUID.

	   Unique identifier of the data collection.
	*/
	DatacollectionUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Unique identifier of the entity.
	*/
	UUID string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	/* WorkspaceVersionUUID.

	   The version of the workspace to be used. If not specified, the current version is used.

	*/
	WorkspaceVersionUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection entity get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionEntityGetParams) WithDefaults() *DatacollectionEntityGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection entity get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionEntityGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the datacollection entity get params
func (o *DatacollectionEntityGetParams) WithTimeout(timeout time.Duration) *DatacollectionEntityGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection entity get params
func (o *DatacollectionEntityGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection entity get params
func (o *DatacollectionEntityGetParams) WithContext(ctx context.Context) *DatacollectionEntityGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection entity get params
func (o *DatacollectionEntityGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection entity get params
func (o *DatacollectionEntityGetParams) WithHTTPClient(client *http.Client) *DatacollectionEntityGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection entity get params
func (o *DatacollectionEntityGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDatacollectionUUID adds the datacollectionUUID to the datacollection entity get params
func (o *DatacollectionEntityGetParams) WithDatacollectionUUID(datacollectionUUID string) *DatacollectionEntityGetParams {
	o.SetDatacollectionUUID(datacollectionUUID)
	return o
}

// SetDatacollectionUUID adds the datacollectionUuid to the datacollection entity get params
func (o *DatacollectionEntityGetParams) SetDatacollectionUUID(datacollectionUUID string) {
	o.DatacollectionUUID = datacollectionUUID
}

// WithFields adds the fields to the datacollection entity get params
func (o *DatacollectionEntityGetParams) WithFields(fields []string) *DatacollectionEntityGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the datacollection entity get params
func (o *DatacollectionEntityGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the datacollection entity get params
func (o *DatacollectionEntityGetParams) WithUUID(uuid string) *DatacollectionEntityGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the datacollection entity get params
func (o *DatacollectionEntityGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection entity get params
func (o *DatacollectionEntityGetParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionEntityGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection entity get params
func (o *DatacollectionEntityGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WithWorkspaceVersionUUID adds the workspaceVersionUUID to the datacollection entity get params
func (o *DatacollectionEntityGetParams) WithWorkspaceVersionUUID(workspaceVersionUUID *string) *DatacollectionEntityGetParams {
	o.SetWorkspaceVersionUUID(workspaceVersionUUID)
	return o
}

// SetWorkspaceVersionUUID adds the workspaceVersionUuid to the datacollection entity get params
func (o *DatacollectionEntityGetParams) SetWorkspaceVersionUUID(workspaceVersionUUID *string) {
	o.WorkspaceVersionUUID = workspaceVersionUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionEntityGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param datacollection.uuid
	if err := r.SetPathParam("datacollection.uuid", o.DatacollectionUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if o.WorkspaceVersionUUID != nil {

		// query param workspace.version.uuid
		var qrWorkspaceVersionUUID string

		if o.WorkspaceVersionUUID != nil {
			qrWorkspaceVersionUUID = *o.WorkspaceVersionUUID
		}
		qWorkspaceVersionUUID := qrWorkspaceVersionUUID
		if qWorkspaceVersionUUID != "" {

			if err := r.SetQueryParam("workspace.version.uuid", qWorkspaceVersionUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDatacollectionEntityGet binds the parameter fields
func (o *DatacollectionEntityGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
