// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionEntityGetReader is a Reader for the DatacollectionEntityGet structure.
type DatacollectionEntityGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionEntityGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDatacollectionEntityGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionEntityGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionEntityGetOK creates a DatacollectionEntityGetOK with default headers values
func NewDatacollectionEntityGetOK() *DatacollectionEntityGetOK {
	return &DatacollectionEntityGetOK{}
}

/*
DatacollectionEntityGetOK describes a response with status code 200, with default header values.

OK
*/
type DatacollectionEntityGetOK struct {
	Payload *models.DatacollectionEntity
}

// IsSuccess returns true when this datacollection entity get o k response has a 2xx status code
func (o *DatacollectionEntityGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection entity get o k response has a 3xx status code
func (o *DatacollectionEntityGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection entity get o k response has a 4xx status code
func (o *DatacollectionEntityGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection entity get o k response has a 5xx status code
func (o *DatacollectionEntityGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection entity get o k response a status code equal to that given
func (o *DatacollectionEntityGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the datacollection entity get o k response
func (o *DatacollectionEntityGetOK) Code() int {
	return 200
}

func (o *DatacollectionEntityGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities/{uuid}][%d] datacollectionEntityGetOK %s", 200, payload)
}

func (o *DatacollectionEntityGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities/{uuid}][%d] datacollectionEntityGetOK %s", 200, payload)
}

func (o *DatacollectionEntityGetOK) GetPayload() *models.DatacollectionEntity {
	return o.Payload
}

func (o *DatacollectionEntityGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DatacollectionEntity)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionEntityGetDefault creates a DatacollectionEntityGetDefault with default headers values
func NewDatacollectionEntityGetDefault(code int) *DatacollectionEntityGetDefault {
	return &DatacollectionEntityGetDefault{
		_statusCode: code,
	}
}

/*
DatacollectionEntityGetDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionEntityGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection entity get default response has a 2xx status code
func (o *DatacollectionEntityGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection entity get default response has a 3xx status code
func (o *DatacollectionEntityGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection entity get default response has a 4xx status code
func (o *DatacollectionEntityGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection entity get default response has a 5xx status code
func (o *DatacollectionEntityGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection entity get default response a status code equal to that given
func (o *DatacollectionEntityGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection entity get default response
func (o *DatacollectionEntityGetDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionEntityGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities/{uuid}][%d] datacollection_entity_get default %s", o._statusCode, payload)
}

func (o *DatacollectionEntityGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/entities/{uuid}][%d] datacollection_entity_get default %s", o._statusCode, payload)
}

func (o *DatacollectionEntityGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionEntityGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
