// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDatacollectionGetParams creates a new DatacollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionGetParams() *DatacollectionGetParams {
	return &DatacollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionGetParamsWithTimeout creates a new DatacollectionGetParams object
// with the ability to set a timeout on a request.
func NewDatacollectionGetParamsWithTimeout(timeout time.Duration) *DatacollectionGetParams {
	return &DatacollectionGetParams{
		timeout: timeout,
	}
}

// NewDatacollectionGetParamsWithContext creates a new DatacollectionGetParams object
// with the ability to set a context for a request.
func NewDatacollectionGetParamsWithContext(ctx context.Context) *DatacollectionGetParams {
	return &DatacollectionGetParams{
		Context: ctx,
	}
}

// NewDatacollectionGetParamsWithHTTPClient creates a new DatacollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionGetParamsWithHTTPClient(client *http.Client) *DatacollectionGetParams {
	return &DatacollectionGetParams{
		HTTPClient: client,
	}
}

/*
DatacollectionGetParams contains all the parameters to send to the API endpoint

	for the datacollection get operation.

	Typically these are written to a http.Request.
*/
type DatacollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Unique identifier of the data collection.
	*/
	UUID string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionGetParams) WithDefaults() *DatacollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the datacollection get params
func (o *DatacollectionGetParams) WithTimeout(timeout time.Duration) *DatacollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection get params
func (o *DatacollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection get params
func (o *DatacollectionGetParams) WithContext(ctx context.Context) *DatacollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection get params
func (o *DatacollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection get params
func (o *DatacollectionGetParams) WithHTTPClient(client *http.Client) *DatacollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection get params
func (o *DatacollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the datacollection get params
func (o *DatacollectionGetParams) WithFields(fields []string) *DatacollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the datacollection get params
func (o *DatacollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the datacollection get params
func (o *DatacollectionGetParams) WithUUID(uuid string) *DatacollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the datacollection get params
func (o *DatacollectionGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection get params
func (o *DatacollectionGetParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection get params
func (o *DatacollectionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDatacollectionGet binds the parameter fields
func (o *DatacollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
