// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionGetReader is a Reader for the DatacollectionGet structure.
type DatacollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDatacollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionGetOK creates a DatacollectionGetOK with default headers values
func NewDatacollectionGetOK() *DatacollectionGetOK {
	return &DatacollectionGetOK{}
}

/*
DatacollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DatacollectionGetOK struct {
	Payload *models.Datacollection
}

// IsSuccess returns true when this datacollection get o k response has a 2xx status code
func (o *DatacollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection get o k response has a 3xx status code
func (o *DatacollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection get o k response has a 4xx status code
func (o *DatacollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection get o k response has a 5xx status code
func (o *DatacollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection get o k response a status code equal to that given
func (o *DatacollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the datacollection get o k response
func (o *DatacollectionGetOK) Code() int {
	return 200
}

func (o *DatacollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollectionGetOK %s", 200, payload)
}

func (o *DatacollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollectionGetOK %s", 200, payload)
}

func (o *DatacollectionGetOK) GetPayload() *models.Datacollection {
	return o.Payload
}

func (o *DatacollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Datacollection)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionGetDefault creates a DatacollectionGetDefault with default headers values
func NewDatacollectionGetDefault(code int) *DatacollectionGetDefault {
	return &DatacollectionGetDefault{
		_statusCode: code,
	}
}

/*
DatacollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection get default response has a 2xx status code
func (o *DatacollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection get default response has a 3xx status code
func (o *DatacollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection get default response has a 4xx status code
func (o *DatacollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection get default response has a 5xx status code
func (o *DatacollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection get default response a status code equal to that given
func (o *DatacollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection get default response
func (o *DatacollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollection_get default %s", o._statusCode, payload)
}

func (o *DatacollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollection_get default %s", o._statusCode, payload)
}

func (o *DatacollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
