// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDatacollectionModifyCollectionParams creates a new DatacollectionModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionModifyCollectionParams() *DatacollectionModifyCollectionParams {
	return &DatacollectionModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionModifyCollectionParamsWithTimeout creates a new DatacollectionModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewDatacollectionModifyCollectionParamsWithTimeout(timeout time.Duration) *DatacollectionModifyCollectionParams {
	return &DatacollectionModifyCollectionParams{
		timeout: timeout,
	}
}

// NewDatacollectionModifyCollectionParamsWithContext creates a new DatacollectionModifyCollectionParams object
// with the ability to set a context for a request.
func NewDatacollectionModifyCollectionParamsWithContext(ctx context.Context) *DatacollectionModifyCollectionParams {
	return &DatacollectionModifyCollectionParams{
		Context: ctx,
	}
}

// NewDatacollectionModifyCollectionParamsWithHTTPClient creates a new DatacollectionModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionModifyCollectionParamsWithHTTPClient(client *http.Client) *DatacollectionModifyCollectionParams {
	return &DatacollectionModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
DatacollectionModifyCollectionParams contains all the parameters to send to the API endpoint

	for the datacollection modify collection operation.

	Typically these are written to a http.Request.
*/
type DatacollectionModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Description.

	   Filter by description
	*/
	Description *string

	/* EmbeddingChunkSize.

	   Filter by embedding.chunk_size
	*/
	EmbeddingChunkSize *int64

	/* EmbeddingChunkType.

	   Filter by embedding.chunk_type
	*/
	EmbeddingChunkType *string

	/* EmbeddingDimension.

	   Filter by embedding.dimension
	*/
	EmbeddingDimension *int64

	/* EmbeddingEnabled.

	   Filter by embedding.enabled
	*/
	EmbeddingEnabled *bool

	/* EmbeddingQuantization.

	   Filter by embedding.quantization
	*/
	EmbeddingQuantization *string

	/* EmbeddingReRank.

	   Filter by embedding.re_rank
	*/
	EmbeddingReRank *bool

	/* EntitiesUUID.

	   Filter by entities.uuid
	*/
	EntitiesUUID *string

	/* EntityCount.

	   Filter by entity_count
	*/
	EntityCount *int64

	/* ErrorsErrorCode.

	   Filter by errors.error.code
	*/
	ErrorsErrorCode *string

	/* ErrorsErrorMessage.

	   Filter by errors.error.message
	*/
	ErrorsErrorMessage *string

	/* ErrorsErrorTarget.

	   Filter by errors.error.target
	*/
	ErrorsErrorTarget *string

	/* Info.

	   Info specification
	*/
	Info DatacollectionModifyCollectionBody

	/* LastRefreshTime.

	   Filter by last_refresh_time
	*/
	LastRefreshTime *string

	/* Message.

	   Filter by message
	*/
	Message *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* Owner.

	   Filter by owner
	*/
	Owner *string

	/* QueryExpression.

	   Filter by query.expression
	*/
	QueryExpression *string

	/* QueryUUID.

	   Filter by query.uuid
	*/
	QueryUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Size.

	   Filter by size
	*/
	Size *int64

	/* State.

	   Filter by state
	*/
	State *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UpdateTime.

	   Filter by update_time
	*/
	UpdateTime *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VersionCurrentJobState.

	   Filter by version.current.job.state
	*/
	VersionCurrentJobState *string

	/* VersionCurrentJobUUID.

	   Filter by version.current.job.uuid
	*/
	VersionCurrentJobUUID *string

	/* VersionCurrentUUID.

	   Filter by version.current.uuid
	*/
	VersionCurrentUUID *string

	/* VersionJobState.

	   Filter by version.job.state
	*/
	VersionJobState *string

	/* VersionJobUUID.

	   Filter by version.job.uuid
	*/
	VersionJobUUID *string

	/* VersionNextJobState.

	   Filter by version.next.job.state
	*/
	VersionNextJobState *string

	/* VersionNextJobUUID.

	   Filter by version.next.job.uuid
	*/
	VersionNextJobUUID *string

	/* VersionNextUUID.

	   Filter by version.next.uuid
	*/
	VersionNextUUID *string

	/* VersionUUID.

	   Filter by version.uuid
	*/
	VersionUUID *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	/* WorkspaceVersionUUID.

	   Filter by workspace.version.uuid
	*/
	WorkspaceVersionUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionModifyCollectionParams) WithDefaults() *DatacollectionModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := DatacollectionModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithTimeout(timeout time.Duration) *DatacollectionModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithContext(ctx context.Context) *DatacollectionModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithHTTPClient(client *http.Client) *DatacollectionModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *DatacollectionModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCreateTime adds the createTime to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithCreateTime(createTime *string) *DatacollectionModifyCollectionParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithDescription adds the description to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithDescription(description *string) *DatacollectionModifyCollectionParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetDescription(description *string) {
	o.Description = description
}

// WithEmbeddingChunkSize adds the embeddingChunkSize to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithEmbeddingChunkSize(embeddingChunkSize *int64) *DatacollectionModifyCollectionParams {
	o.SetEmbeddingChunkSize(embeddingChunkSize)
	return o
}

// SetEmbeddingChunkSize adds the embeddingChunkSize to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetEmbeddingChunkSize(embeddingChunkSize *int64) {
	o.EmbeddingChunkSize = embeddingChunkSize
}

// WithEmbeddingChunkType adds the embeddingChunkType to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithEmbeddingChunkType(embeddingChunkType *string) *DatacollectionModifyCollectionParams {
	o.SetEmbeddingChunkType(embeddingChunkType)
	return o
}

// SetEmbeddingChunkType adds the embeddingChunkType to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetEmbeddingChunkType(embeddingChunkType *string) {
	o.EmbeddingChunkType = embeddingChunkType
}

// WithEmbeddingDimension adds the embeddingDimension to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithEmbeddingDimension(embeddingDimension *int64) *DatacollectionModifyCollectionParams {
	o.SetEmbeddingDimension(embeddingDimension)
	return o
}

// SetEmbeddingDimension adds the embeddingDimension to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetEmbeddingDimension(embeddingDimension *int64) {
	o.EmbeddingDimension = embeddingDimension
}

// WithEmbeddingEnabled adds the embeddingEnabled to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithEmbeddingEnabled(embeddingEnabled *bool) *DatacollectionModifyCollectionParams {
	o.SetEmbeddingEnabled(embeddingEnabled)
	return o
}

// SetEmbeddingEnabled adds the embeddingEnabled to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetEmbeddingEnabled(embeddingEnabled *bool) {
	o.EmbeddingEnabled = embeddingEnabled
}

// WithEmbeddingQuantization adds the embeddingQuantization to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithEmbeddingQuantization(embeddingQuantization *string) *DatacollectionModifyCollectionParams {
	o.SetEmbeddingQuantization(embeddingQuantization)
	return o
}

// SetEmbeddingQuantization adds the embeddingQuantization to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetEmbeddingQuantization(embeddingQuantization *string) {
	o.EmbeddingQuantization = embeddingQuantization
}

// WithEmbeddingReRank adds the embeddingReRank to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithEmbeddingReRank(embeddingReRank *bool) *DatacollectionModifyCollectionParams {
	o.SetEmbeddingReRank(embeddingReRank)
	return o
}

// SetEmbeddingReRank adds the embeddingReRank to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetEmbeddingReRank(embeddingReRank *bool) {
	o.EmbeddingReRank = embeddingReRank
}

// WithEntitiesUUID adds the entitiesUUID to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithEntitiesUUID(entitiesUUID *string) *DatacollectionModifyCollectionParams {
	o.SetEntitiesUUID(entitiesUUID)
	return o
}

// SetEntitiesUUID adds the entitiesUuid to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetEntitiesUUID(entitiesUUID *string) {
	o.EntitiesUUID = entitiesUUID
}

// WithEntityCount adds the entityCount to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithEntityCount(entityCount *int64) *DatacollectionModifyCollectionParams {
	o.SetEntityCount(entityCount)
	return o
}

// SetEntityCount adds the entityCount to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetEntityCount(entityCount *int64) {
	o.EntityCount = entityCount
}

// WithErrorsErrorCode adds the errorsErrorCode to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithErrorsErrorCode(errorsErrorCode *string) *DatacollectionModifyCollectionParams {
	o.SetErrorsErrorCode(errorsErrorCode)
	return o
}

// SetErrorsErrorCode adds the errorsErrorCode to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetErrorsErrorCode(errorsErrorCode *string) {
	o.ErrorsErrorCode = errorsErrorCode
}

// WithErrorsErrorMessage adds the errorsErrorMessage to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithErrorsErrorMessage(errorsErrorMessage *string) *DatacollectionModifyCollectionParams {
	o.SetErrorsErrorMessage(errorsErrorMessage)
	return o
}

// SetErrorsErrorMessage adds the errorsErrorMessage to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetErrorsErrorMessage(errorsErrorMessage *string) {
	o.ErrorsErrorMessage = errorsErrorMessage
}

// WithErrorsErrorTarget adds the errorsErrorTarget to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithErrorsErrorTarget(errorsErrorTarget *string) *DatacollectionModifyCollectionParams {
	o.SetErrorsErrorTarget(errorsErrorTarget)
	return o
}

// SetErrorsErrorTarget adds the errorsErrorTarget to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetErrorsErrorTarget(errorsErrorTarget *string) {
	o.ErrorsErrorTarget = errorsErrorTarget
}

// WithInfo adds the info to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithInfo(info DatacollectionModifyCollectionBody) *DatacollectionModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetInfo(info DatacollectionModifyCollectionBody) {
	o.Info = info
}

// WithLastRefreshTime adds the lastRefreshTime to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithLastRefreshTime(lastRefreshTime *string) *DatacollectionModifyCollectionParams {
	o.SetLastRefreshTime(lastRefreshTime)
	return o
}

// SetLastRefreshTime adds the lastRefreshTime to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetLastRefreshTime(lastRefreshTime *string) {
	o.LastRefreshTime = lastRefreshTime
}

// WithMessage adds the message to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithMessage(message *string) *DatacollectionModifyCollectionParams {
	o.SetMessage(message)
	return o
}

// SetMessage adds the message to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetMessage(message *string) {
	o.Message = message
}

// WithName adds the name to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithName(name *string) *DatacollectionModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithOwner adds the owner to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithOwner(owner *string) *DatacollectionModifyCollectionParams {
	o.SetOwner(owner)
	return o
}

// SetOwner adds the owner to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetOwner(owner *string) {
	o.Owner = owner
}

// WithQueryExpression adds the queryExpression to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithQueryExpression(queryExpression *string) *DatacollectionModifyCollectionParams {
	o.SetQueryExpression(queryExpression)
	return o
}

// SetQueryExpression adds the queryExpression to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetQueryExpression(queryExpression *string) {
	o.QueryExpression = queryExpression
}

// WithQueryUUID adds the queryUUID to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithQueryUUID(queryUUID *string) *DatacollectionModifyCollectionParams {
	o.SetQueryUUID(queryUUID)
	return o
}

// SetQueryUUID adds the queryUuid to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetQueryUUID(queryUUID *string) {
	o.QueryUUID = queryUUID
}

// WithReturnRecords adds the returnRecords to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithReturnRecords(returnRecords *bool) *DatacollectionModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *DatacollectionModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithSerialRecords(serialRecords *bool) *DatacollectionModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSize adds the size to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithSize(size *int64) *DatacollectionModifyCollectionParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetSize(size *int64) {
	o.Size = size
}

// WithState adds the state to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithState(state *string) *DatacollectionModifyCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetState(state *string) {
	o.State = state
}

// WithType adds the typeVar to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithType(typeVar *string) *DatacollectionModifyCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUpdateTime adds the updateTime to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithUpdateTime(updateTime *string) *DatacollectionModifyCollectionParams {
	o.SetUpdateTime(updateTime)
	return o
}

// SetUpdateTime adds the updateTime to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetUpdateTime(updateTime *string) {
	o.UpdateTime = updateTime
}

// WithUUID adds the uuid to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithUUID(uuid *string) *DatacollectionModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVersionCurrentJobState adds the versionCurrentJobState to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithVersionCurrentJobState(versionCurrentJobState *string) *DatacollectionModifyCollectionParams {
	o.SetVersionCurrentJobState(versionCurrentJobState)
	return o
}

// SetVersionCurrentJobState adds the versionCurrentJobState to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetVersionCurrentJobState(versionCurrentJobState *string) {
	o.VersionCurrentJobState = versionCurrentJobState
}

// WithVersionCurrentJobUUID adds the versionCurrentJobUUID to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithVersionCurrentJobUUID(versionCurrentJobUUID *string) *DatacollectionModifyCollectionParams {
	o.SetVersionCurrentJobUUID(versionCurrentJobUUID)
	return o
}

// SetVersionCurrentJobUUID adds the versionCurrentJobUuid to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetVersionCurrentJobUUID(versionCurrentJobUUID *string) {
	o.VersionCurrentJobUUID = versionCurrentJobUUID
}

// WithVersionCurrentUUID adds the versionCurrentUUID to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithVersionCurrentUUID(versionCurrentUUID *string) *DatacollectionModifyCollectionParams {
	o.SetVersionCurrentUUID(versionCurrentUUID)
	return o
}

// SetVersionCurrentUUID adds the versionCurrentUuid to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetVersionCurrentUUID(versionCurrentUUID *string) {
	o.VersionCurrentUUID = versionCurrentUUID
}

// WithVersionJobState adds the versionJobState to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithVersionJobState(versionJobState *string) *DatacollectionModifyCollectionParams {
	o.SetVersionJobState(versionJobState)
	return o
}

// SetVersionJobState adds the versionJobState to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetVersionJobState(versionJobState *string) {
	o.VersionJobState = versionJobState
}

// WithVersionJobUUID adds the versionJobUUID to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithVersionJobUUID(versionJobUUID *string) *DatacollectionModifyCollectionParams {
	o.SetVersionJobUUID(versionJobUUID)
	return o
}

// SetVersionJobUUID adds the versionJobUuid to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetVersionJobUUID(versionJobUUID *string) {
	o.VersionJobUUID = versionJobUUID
}

// WithVersionNextJobState adds the versionNextJobState to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithVersionNextJobState(versionNextJobState *string) *DatacollectionModifyCollectionParams {
	o.SetVersionNextJobState(versionNextJobState)
	return o
}

// SetVersionNextJobState adds the versionNextJobState to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetVersionNextJobState(versionNextJobState *string) {
	o.VersionNextJobState = versionNextJobState
}

// WithVersionNextJobUUID adds the versionNextJobUUID to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithVersionNextJobUUID(versionNextJobUUID *string) *DatacollectionModifyCollectionParams {
	o.SetVersionNextJobUUID(versionNextJobUUID)
	return o
}

// SetVersionNextJobUUID adds the versionNextJobUuid to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetVersionNextJobUUID(versionNextJobUUID *string) {
	o.VersionNextJobUUID = versionNextJobUUID
}

// WithVersionNextUUID adds the versionNextUUID to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithVersionNextUUID(versionNextUUID *string) *DatacollectionModifyCollectionParams {
	o.SetVersionNextUUID(versionNextUUID)
	return o
}

// SetVersionNextUUID adds the versionNextUuid to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetVersionNextUUID(versionNextUUID *string) {
	o.VersionNextUUID = versionNextUUID
}

// WithVersionUUID adds the versionUUID to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithVersionUUID(versionUUID *string) *DatacollectionModifyCollectionParams {
	o.SetVersionUUID(versionUUID)
	return o
}

// SetVersionUUID adds the versionUuid to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetVersionUUID(versionUUID *string) {
	o.VersionUUID = versionUUID
}

// WithWorkspaceName adds the workspaceName to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithWorkspaceName(workspaceName *string) *DatacollectionModifyCollectionParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionModifyCollectionParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WithWorkspaceVersionUUID adds the workspaceVersionUUID to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) WithWorkspaceVersionUUID(workspaceVersionUUID *string) *DatacollectionModifyCollectionParams {
	o.SetWorkspaceVersionUUID(workspaceVersionUUID)
	return o
}

// SetWorkspaceVersionUUID adds the workspaceVersionUuid to the datacollection modify collection params
func (o *DatacollectionModifyCollectionParams) SetWorkspaceVersionUUID(workspaceVersionUUID *string) {
	o.WorkspaceVersionUUID = workspaceVersionUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.EmbeddingChunkSize != nil {

		// query param embedding.chunk_size
		var qrEmbeddingChunkSize int64

		if o.EmbeddingChunkSize != nil {
			qrEmbeddingChunkSize = *o.EmbeddingChunkSize
		}
		qEmbeddingChunkSize := swag.FormatInt64(qrEmbeddingChunkSize)
		if qEmbeddingChunkSize != "" {

			if err := r.SetQueryParam("embedding.chunk_size", qEmbeddingChunkSize); err != nil {
				return err
			}
		}
	}

	if o.EmbeddingChunkType != nil {

		// query param embedding.chunk_type
		var qrEmbeddingChunkType string

		if o.EmbeddingChunkType != nil {
			qrEmbeddingChunkType = *o.EmbeddingChunkType
		}
		qEmbeddingChunkType := qrEmbeddingChunkType
		if qEmbeddingChunkType != "" {

			if err := r.SetQueryParam("embedding.chunk_type", qEmbeddingChunkType); err != nil {
				return err
			}
		}
	}

	if o.EmbeddingDimension != nil {

		// query param embedding.dimension
		var qrEmbeddingDimension int64

		if o.EmbeddingDimension != nil {
			qrEmbeddingDimension = *o.EmbeddingDimension
		}
		qEmbeddingDimension := swag.FormatInt64(qrEmbeddingDimension)
		if qEmbeddingDimension != "" {

			if err := r.SetQueryParam("embedding.dimension", qEmbeddingDimension); err != nil {
				return err
			}
		}
	}

	if o.EmbeddingEnabled != nil {

		// query param embedding.enabled
		var qrEmbeddingEnabled bool

		if o.EmbeddingEnabled != nil {
			qrEmbeddingEnabled = *o.EmbeddingEnabled
		}
		qEmbeddingEnabled := swag.FormatBool(qrEmbeddingEnabled)
		if qEmbeddingEnabled != "" {

			if err := r.SetQueryParam("embedding.enabled", qEmbeddingEnabled); err != nil {
				return err
			}
		}
	}

	if o.EmbeddingQuantization != nil {

		// query param embedding.quantization
		var qrEmbeddingQuantization string

		if o.EmbeddingQuantization != nil {
			qrEmbeddingQuantization = *o.EmbeddingQuantization
		}
		qEmbeddingQuantization := qrEmbeddingQuantization
		if qEmbeddingQuantization != "" {

			if err := r.SetQueryParam("embedding.quantization", qEmbeddingQuantization); err != nil {
				return err
			}
		}
	}

	if o.EmbeddingReRank != nil {

		// query param embedding.re_rank
		var qrEmbeddingReRank bool

		if o.EmbeddingReRank != nil {
			qrEmbeddingReRank = *o.EmbeddingReRank
		}
		qEmbeddingReRank := swag.FormatBool(qrEmbeddingReRank)
		if qEmbeddingReRank != "" {

			if err := r.SetQueryParam("embedding.re_rank", qEmbeddingReRank); err != nil {
				return err
			}
		}
	}

	if o.EntitiesUUID != nil {

		// query param entities.uuid
		var qrEntitiesUUID string

		if o.EntitiesUUID != nil {
			qrEntitiesUUID = *o.EntitiesUUID
		}
		qEntitiesUUID := qrEntitiesUUID
		if qEntitiesUUID != "" {

			if err := r.SetQueryParam("entities.uuid", qEntitiesUUID); err != nil {
				return err
			}
		}
	}

	if o.EntityCount != nil {

		// query param entity_count
		var qrEntityCount int64

		if o.EntityCount != nil {
			qrEntityCount = *o.EntityCount
		}
		qEntityCount := swag.FormatInt64(qrEntityCount)
		if qEntityCount != "" {

			if err := r.SetQueryParam("entity_count", qEntityCount); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorCode != nil {

		// query param errors.error.code
		var qrErrorsErrorCode string

		if o.ErrorsErrorCode != nil {
			qrErrorsErrorCode = *o.ErrorsErrorCode
		}
		qErrorsErrorCode := qrErrorsErrorCode
		if qErrorsErrorCode != "" {

			if err := r.SetQueryParam("errors.error.code", qErrorsErrorCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorMessage != nil {

		// query param errors.error.message
		var qrErrorsErrorMessage string

		if o.ErrorsErrorMessage != nil {
			qrErrorsErrorMessage = *o.ErrorsErrorMessage
		}
		qErrorsErrorMessage := qrErrorsErrorMessage
		if qErrorsErrorMessage != "" {

			if err := r.SetQueryParam("errors.error.message", qErrorsErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorTarget != nil {

		// query param errors.error.target
		var qrErrorsErrorTarget string

		if o.ErrorsErrorTarget != nil {
			qrErrorsErrorTarget = *o.ErrorsErrorTarget
		}
		qErrorsErrorTarget := qrErrorsErrorTarget
		if qErrorsErrorTarget != "" {

			if err := r.SetQueryParam("errors.error.target", qErrorsErrorTarget); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.LastRefreshTime != nil {

		// query param last_refresh_time
		var qrLastRefreshTime string

		if o.LastRefreshTime != nil {
			qrLastRefreshTime = *o.LastRefreshTime
		}
		qLastRefreshTime := qrLastRefreshTime
		if qLastRefreshTime != "" {

			if err := r.SetQueryParam("last_refresh_time", qLastRefreshTime); err != nil {
				return err
			}
		}
	}

	if o.Message != nil {

		// query param message
		var qrMessage string

		if o.Message != nil {
			qrMessage = *o.Message
		}
		qMessage := qrMessage
		if qMessage != "" {

			if err := r.SetQueryParam("message", qMessage); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.Owner != nil {

		// query param owner
		var qrOwner string

		if o.Owner != nil {
			qrOwner = *o.Owner
		}
		qOwner := qrOwner
		if qOwner != "" {

			if err := r.SetQueryParam("owner", qOwner); err != nil {
				return err
			}
		}
	}

	if o.QueryExpression != nil {

		// query param query.expression
		var qrQueryExpression string

		if o.QueryExpression != nil {
			qrQueryExpression = *o.QueryExpression
		}
		qQueryExpression := qrQueryExpression
		if qQueryExpression != "" {

			if err := r.SetQueryParam("query.expression", qQueryExpression); err != nil {
				return err
			}
		}
	}

	if o.QueryUUID != nil {

		// query param query.uuid
		var qrQueryUUID string

		if o.QueryUUID != nil {
			qrQueryUUID = *o.QueryUUID
		}
		qQueryUUID := qrQueryUUID
		if qQueryUUID != "" {

			if err := r.SetQueryParam("query.uuid", qQueryUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Size != nil {

		// query param size
		var qrSize int64

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatInt64(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UpdateTime != nil {

		// query param update_time
		var qrUpdateTime string

		if o.UpdateTime != nil {
			qrUpdateTime = *o.UpdateTime
		}
		qUpdateTime := qrUpdateTime
		if qUpdateTime != "" {

			if err := r.SetQueryParam("update_time", qUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionCurrentJobState != nil {

		// query param version.current.job.state
		var qrVersionCurrentJobState string

		if o.VersionCurrentJobState != nil {
			qrVersionCurrentJobState = *o.VersionCurrentJobState
		}
		qVersionCurrentJobState := qrVersionCurrentJobState
		if qVersionCurrentJobState != "" {

			if err := r.SetQueryParam("version.current.job.state", qVersionCurrentJobState); err != nil {
				return err
			}
		}
	}

	if o.VersionCurrentJobUUID != nil {

		// query param version.current.job.uuid
		var qrVersionCurrentJobUUID string

		if o.VersionCurrentJobUUID != nil {
			qrVersionCurrentJobUUID = *o.VersionCurrentJobUUID
		}
		qVersionCurrentJobUUID := qrVersionCurrentJobUUID
		if qVersionCurrentJobUUID != "" {

			if err := r.SetQueryParam("version.current.job.uuid", qVersionCurrentJobUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionCurrentUUID != nil {

		// query param version.current.uuid
		var qrVersionCurrentUUID string

		if o.VersionCurrentUUID != nil {
			qrVersionCurrentUUID = *o.VersionCurrentUUID
		}
		qVersionCurrentUUID := qrVersionCurrentUUID
		if qVersionCurrentUUID != "" {

			if err := r.SetQueryParam("version.current.uuid", qVersionCurrentUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionJobState != nil {

		// query param version.job.state
		var qrVersionJobState string

		if o.VersionJobState != nil {
			qrVersionJobState = *o.VersionJobState
		}
		qVersionJobState := qrVersionJobState
		if qVersionJobState != "" {

			if err := r.SetQueryParam("version.job.state", qVersionJobState); err != nil {
				return err
			}
		}
	}

	if o.VersionJobUUID != nil {

		// query param version.job.uuid
		var qrVersionJobUUID string

		if o.VersionJobUUID != nil {
			qrVersionJobUUID = *o.VersionJobUUID
		}
		qVersionJobUUID := qrVersionJobUUID
		if qVersionJobUUID != "" {

			if err := r.SetQueryParam("version.job.uuid", qVersionJobUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionNextJobState != nil {

		// query param version.next.job.state
		var qrVersionNextJobState string

		if o.VersionNextJobState != nil {
			qrVersionNextJobState = *o.VersionNextJobState
		}
		qVersionNextJobState := qrVersionNextJobState
		if qVersionNextJobState != "" {

			if err := r.SetQueryParam("version.next.job.state", qVersionNextJobState); err != nil {
				return err
			}
		}
	}

	if o.VersionNextJobUUID != nil {

		// query param version.next.job.uuid
		var qrVersionNextJobUUID string

		if o.VersionNextJobUUID != nil {
			qrVersionNextJobUUID = *o.VersionNextJobUUID
		}
		qVersionNextJobUUID := qrVersionNextJobUUID
		if qVersionNextJobUUID != "" {

			if err := r.SetQueryParam("version.next.job.uuid", qVersionNextJobUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionNextUUID != nil {

		// query param version.next.uuid
		var qrVersionNextUUID string

		if o.VersionNextUUID != nil {
			qrVersionNextUUID = *o.VersionNextUUID
		}
		qVersionNextUUID := qrVersionNextUUID
		if qVersionNextUUID != "" {

			if err := r.SetQueryParam("version.next.uuid", qVersionNextUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionUUID != nil {

		// query param version.uuid
		var qrVersionUUID string

		if o.VersionUUID != nil {
			qrVersionUUID = *o.VersionUUID
		}
		qVersionUUID := qrVersionUUID
		if qVersionUUID != "" {

			if err := r.SetQueryParam("version.uuid", qVersionUUID); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if o.WorkspaceVersionUUID != nil {

		// query param workspace.version.uuid
		var qrWorkspaceVersionUUID string

		if o.WorkspaceVersionUUID != nil {
			qrWorkspaceVersionUUID = *o.WorkspaceVersionUUID
		}
		qWorkspaceVersionUUID := qrWorkspaceVersionUUID
		if qWorkspaceVersionUUID != "" {

			if err := r.SetQueryParam("workspace.version.uuid", qWorkspaceVersionUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
