// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionModifyCollectionReader is a Reader for the DatacollectionModifyCollection structure.
type DatacollectionModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDatacollectionModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDatacollectionModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionModifyCollectionOK creates a DatacollectionModifyCollectionOK with default headers values
func NewDatacollectionModifyCollectionOK() *DatacollectionModifyCollectionOK {
	return &DatacollectionModifyCollectionOK{}
}

/*
DatacollectionModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DatacollectionModifyCollectionOK struct {
	Payload *models.Datacollection
}

// IsSuccess returns true when this datacollection modify collection o k response has a 2xx status code
func (o *DatacollectionModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection modify collection o k response has a 3xx status code
func (o *DatacollectionModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection modify collection o k response has a 4xx status code
func (o *DatacollectionModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection modify collection o k response has a 5xx status code
func (o *DatacollectionModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection modify collection o k response a status code equal to that given
func (o *DatacollectionModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the datacollection modify collection o k response
func (o *DatacollectionModifyCollectionOK) Code() int {
	return 200
}

func (o *DatacollectionModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollectionModifyCollectionOK %s", 200, payload)
}

func (o *DatacollectionModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollectionModifyCollectionOK %s", 200, payload)
}

func (o *DatacollectionModifyCollectionOK) GetPayload() *models.Datacollection {
	return o.Payload
}

func (o *DatacollectionModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Datacollection)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionModifyCollectionAccepted creates a DatacollectionModifyCollectionAccepted with default headers values
func NewDatacollectionModifyCollectionAccepted() *DatacollectionModifyCollectionAccepted {
	return &DatacollectionModifyCollectionAccepted{}
}

/*
DatacollectionModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DatacollectionModifyCollectionAccepted struct {
	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this datacollection modify collection accepted response has a 2xx status code
func (o *DatacollectionModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection modify collection accepted response has a 3xx status code
func (o *DatacollectionModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection modify collection accepted response has a 4xx status code
func (o *DatacollectionModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection modify collection accepted response has a 5xx status code
func (o *DatacollectionModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection modify collection accepted response a status code equal to that given
func (o *DatacollectionModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the datacollection modify collection accepted response
func (o *DatacollectionModifyCollectionAccepted) Code() int {
	return 202
}

func (o *DatacollectionModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollectionModifyCollectionAccepted %s", 202, payload)
}

func (o *DatacollectionModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollectionModifyCollectionAccepted %s", 202, payload)
}

func (o *DatacollectionModifyCollectionAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *DatacollectionModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionModifyCollectionDefault creates a DatacollectionModifyCollectionDefault with default headers values
func NewDatacollectionModifyCollectionDefault(code int) *DatacollectionModifyCollectionDefault {
	return &DatacollectionModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
DatacollectionModifyCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection modify collection default response has a 2xx status code
func (o *DatacollectionModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection modify collection default response has a 3xx status code
func (o *DatacollectionModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection modify collection default response has a 4xx status code
func (o *DatacollectionModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection modify collection default response has a 5xx status code
func (o *DatacollectionModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection modify collection default response a status code equal to that given
func (o *DatacollectionModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection modify collection default response
func (o *DatacollectionModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollection_modify_collection default %s", o._statusCode, payload)
}

func (o *DatacollectionModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/data-collections][%d] datacollection_modify_collection default %s", o._statusCode, payload)
}

func (o *DatacollectionModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DatacollectionModifyCollectionBody Response object for data collection.
swagger:model DatacollectionModifyCollectionBody
*/
type DatacollectionModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The creation time of the data collection. This field is generated when the data collection is created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// List of users or groups associated with the ACL.
	DatacollectionInlineAcls []*models.DataEngineDatacollectionACL `json:"acls,omitempty"`

	// List of entities.
	DatacollectionInlineEntities []*models.DatacollectionInlineEntitiesInlineArrayItem `json:"entities,omitempty"`

	// datacollection inline errors
	// Read Only: true
	DatacollectionInlineErrors []*models.DatacollectionInlineErrorsInlineArrayItem `json:"errors,omitempty"`

	// List of data collection records.
	DatacollectionResponseInlineRecords []*models.Datacollection `json:"records,omitempty"`

	// Description of the data collection.
	// Example: This is an example data collection.
	Description *string `json:"description,omitempty"`

	// embedding
	Embedding *models.DatacollectionInlineEmbedding `json:"embedding,omitempty"`

	// The count of entities in a data collection.
	// Example: 1000
	// Read Only: true
	EntityCount *int64 `json:"entity_count,omitempty"`

	// The last refresh time of the data collection. This field is generated when the data collection is refreshed.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	LastRefreshTime *strfmt.DateTime `json:"last_refresh_time,omitempty"`

	// The message associated with the current state of the data collection.
	// Example: creating data collection
	// Read Only: true
	Message *string `json:"message,omitempty"`

	// Name of the data collection.
	// Example: Example Data Collection
	Name *string `json:"name,omitempty"`

	// The owner of the data collection.
	// Example: Eva
	// Read Only: true
	Owner *string `json:"owner,omitempty"`

	// query
	Query *models.DatacollectionInlineQuery `json:"query,omitempty"`

	// The size of the data collection, in bytes.
	// Example: 1000
	// Read Only: true
	Size *uint64 `json:"size,omitempty"`

	// State of the data collection:
	// * <i>draft</i> - The data collection is in draft.
	// * <i>processing</i> - The data collection is being processed.
	// * <i>published</i> - The data collection is published.
	// * <i>failed</i> - The data collection has a failure.
	// * <i>outdated</i> - The data collection is outdated.
	// * Valid in GET requests.
	//
	// Example: published
	// Read Only: true
	// Enum: ["draft","processing","published","failed","outdated"]
	State *string `json:"state,omitempty"`

	// The total number of data collections present in a workspace.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`

	// The type of the data collection.
	// * <i>manual</i> - The data collection is created by providing an entities list.
	// * <i>dynamic</i> - The data collection is created with a query selector.
	//
	// Example: dynamic
	// Enum: ["manual","dynamic"]
	Type *string `json:"type,omitempty"`

	// The update time of the data collection. This field is generated when the data collection is updated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// Unique identifier of the data collection.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// version
	Version *models.DatacollectionInlineVersion `json:"version,omitempty"`

	// Workspace containing the data collection.
	// Read Only: true
	Workspace *models.EntityWorkspaceVersion `json:"workspace,omitempty"`
}

// Validate validates this datacollection modify collection body
func (o *DatacollectionModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDatacollectionInlineAcls(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDatacollectionInlineEntities(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDatacollectionInlineErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDatacollectionResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEmbedding(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLastRefreshTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQuery(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) validateDatacollectionInlineAcls(formats strfmt.Registry) error {
	if swag.IsZero(o.DatacollectionInlineAcls) { // not required
		return nil
	}

	for i := 0; i < len(o.DatacollectionInlineAcls); i++ {
		if swag.IsZero(o.DatacollectionInlineAcls[i]) { // not required
			continue
		}

		if o.DatacollectionInlineAcls[i] != nil {
			if err := o.DatacollectionInlineAcls[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "acls" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) validateDatacollectionInlineEntities(formats strfmt.Registry) error {
	if swag.IsZero(o.DatacollectionInlineEntities) { // not required
		return nil
	}

	for i := 0; i < len(o.DatacollectionInlineEntities); i++ {
		if swag.IsZero(o.DatacollectionInlineEntities[i]) { // not required
			continue
		}

		if o.DatacollectionInlineEntities[i] != nil {
			if err := o.DatacollectionInlineEntities[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "entities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) validateDatacollectionInlineErrors(formats strfmt.Registry) error {
	if swag.IsZero(o.DatacollectionInlineErrors) { // not required
		return nil
	}

	for i := 0; i < len(o.DatacollectionInlineErrors); i++ {
		if swag.IsZero(o.DatacollectionInlineErrors[i]) { // not required
			continue
		}

		if o.DatacollectionInlineErrors[i] != nil {
			if err := o.DatacollectionInlineErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) validateDatacollectionResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DatacollectionResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DatacollectionResponseInlineRecords); i++ {
		if swag.IsZero(o.DatacollectionResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DatacollectionResponseInlineRecords[i] != nil {
			if err := o.DatacollectionResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) validateEmbedding(formats strfmt.Registry) error {
	if swag.IsZero(o.Embedding) { // not required
		return nil
	}

	if o.Embedding != nil {
		if err := o.Embedding.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "embedding")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) validateLastRefreshTime(formats strfmt.Registry) error {
	if swag.IsZero(o.LastRefreshTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"last_refresh_time", "body", "date-time", o.LastRefreshTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) validateQuery(formats strfmt.Registry) error {
	if swag.IsZero(o.Query) { // not required
		return nil
	}

	if o.Query != nil {
		if err := o.Query.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "query")
			}
			return err
		}
	}

	return nil
}

var datacollectionModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["draft","processing","published","failed","outdated"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionModifyCollectionBodyTypeStatePropEnum = append(datacollectionModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DatacollectionModifyCollectionBody
	// DatacollectionModifyCollectionBody
	// state
	// State
	// draft
	// END DEBUGGING
	// DatacollectionModifyCollectionBodyStateDraft captures enum value "draft"
	DatacollectionModifyCollectionBodyStateDraft string = "draft"

	// BEGIN DEBUGGING
	// DatacollectionModifyCollectionBody
	// DatacollectionModifyCollectionBody
	// state
	// State
	// processing
	// END DEBUGGING
	// DatacollectionModifyCollectionBodyStateProcessing captures enum value "processing"
	DatacollectionModifyCollectionBodyStateProcessing string = "processing"

	// BEGIN DEBUGGING
	// DatacollectionModifyCollectionBody
	// DatacollectionModifyCollectionBody
	// state
	// State
	// published
	// END DEBUGGING
	// DatacollectionModifyCollectionBodyStatePublished captures enum value "published"
	DatacollectionModifyCollectionBodyStatePublished string = "published"

	// BEGIN DEBUGGING
	// DatacollectionModifyCollectionBody
	// DatacollectionModifyCollectionBody
	// state
	// State
	// failed
	// END DEBUGGING
	// DatacollectionModifyCollectionBodyStateFailed captures enum value "failed"
	DatacollectionModifyCollectionBodyStateFailed string = "failed"

	// BEGIN DEBUGGING
	// DatacollectionModifyCollectionBody
	// DatacollectionModifyCollectionBody
	// state
	// State
	// outdated
	// END DEBUGGING
	// DatacollectionModifyCollectionBodyStateOutdated captures enum value "outdated"
	DatacollectionModifyCollectionBodyStateOutdated string = "outdated"
)

// prop value enum
func (o *DatacollectionModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DatacollectionModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

var datacollectionModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["manual","dynamic"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionModifyCollectionBodyTypeTypePropEnum = append(datacollectionModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DatacollectionModifyCollectionBody
	// DatacollectionModifyCollectionBody
	// type
	// Type
	// manual
	// END DEBUGGING
	// DatacollectionModifyCollectionBodyTypeManual captures enum value "manual"
	DatacollectionModifyCollectionBodyTypeManual string = "manual"

	// BEGIN DEBUGGING
	// DatacollectionModifyCollectionBody
	// DatacollectionModifyCollectionBody
	// type
	// Type
	// dynamic
	// END DEBUGGING
	// DatacollectionModifyCollectionBodyTypeDynamic captures enum value "dynamic"
	DatacollectionModifyCollectionBodyTypeDynamic string = "dynamic"
)

// prop value enum
func (o *DatacollectionModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DatacollectionModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"update_time", "body", "date-time", o.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(o.Version) { // not required
		return nil
	}

	if o.Version != nil {
		if err := o.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Workspace) { // not required
		return nil
	}

	if o.Workspace != nil {
		if err := o.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this datacollection modify collection body based on the context it is used
func (o *DatacollectionModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDatacollectionInlineAcls(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDatacollectionInlineEntities(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDatacollectionInlineErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDatacollectionResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEmbedding(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEntityCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastRefreshTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQuery(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateDatacollectionInlineAcls(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DatacollectionInlineAcls); i++ {

		if o.DatacollectionInlineAcls[i] != nil {
			if err := o.DatacollectionInlineAcls[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "acls" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateDatacollectionInlineEntities(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DatacollectionInlineEntities); i++ {

		if o.DatacollectionInlineEntities[i] != nil {
			if err := o.DatacollectionInlineEntities[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "entities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateDatacollectionInlineErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"errors", "body", []*models.DatacollectionInlineErrorsInlineArrayItem(o.DatacollectionInlineErrors)); err != nil {
		return err
	}

	for i := 0; i < len(o.DatacollectionInlineErrors); i++ {

		if o.DatacollectionInlineErrors[i] != nil {
			if err := o.DatacollectionInlineErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateDatacollectionResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DatacollectionResponseInlineRecords); i++ {

		if o.DatacollectionResponseInlineRecords[i] != nil {
			if err := o.DatacollectionResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateEmbedding(ctx context.Context, formats strfmt.Registry) error {

	if o.Embedding != nil {
		if err := o.Embedding.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "embedding")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateEntityCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"entity_count", "body", o.EntityCount); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateLastRefreshTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"last_refresh_time", "body", o.LastRefreshTime); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"owner", "body", o.Owner); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateQuery(ctx context.Context, formats strfmt.Registry) error {

	if o.Query != nil {
		if err := o.Query.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "query")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"size", "body", o.Size); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"update_time", "body", o.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if o.Version != nil {
		if err := o.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionModifyCollectionBody) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Workspace != nil {
		if err := o.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DatacollectionModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DatacollectionModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res DatacollectionModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DatacollectionInlineEmbedding Vectorization settings for the data collection.
swagger:model datacollection_inline_embedding
*/
type DatacollectionInlineEmbedding struct {

	// The chunk size value in the range (3..1536)
	// Example: 1536
	ChunkSize *int64 `json:"chunk_size,omitempty"`

	// The type of chunking.
	// Enum: ["sentence","paragraph","full_file","semantic","fixed_size","recursive"]
	ChunkType *string `json:"chunk_type,omitempty"`

	// The dimension of vectorization.
	// Example: 1024
	// Enum: [1024]
	Dimension *int64 `json:"dimension,omitempty"`

	// Indicates whether vectorization is enabled.
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// The vector quantization value.
	// Example: fp32
	// Enum: ["fp32","fp16"]
	Quantization *string `json:"quantization,omitempty"`

	// Indicates whether re_rank is enabled
	// Example: true
	ReRank *bool `json:"re_rank,omitempty"`
}

// Validate validates this datacollection inline embedding
func (o *DatacollectionInlineEmbedding) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateChunkType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDimension(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQuantization(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var datacollectionInlineEmbeddingTypeChunkTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sentence","paragraph","full_file","semantic","fixed_size","recursive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionInlineEmbeddingTypeChunkTypePropEnum = append(datacollectionInlineEmbeddingTypeChunkTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// sentence
	// END DEBUGGING
	// DatacollectionInlineEmbeddingChunkTypeSentence captures enum value "sentence"
	DatacollectionInlineEmbeddingChunkTypeSentence string = "sentence"

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// paragraph
	// END DEBUGGING
	// DatacollectionInlineEmbeddingChunkTypeParagraph captures enum value "paragraph"
	DatacollectionInlineEmbeddingChunkTypeParagraph string = "paragraph"

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// full_file
	// END DEBUGGING
	// DatacollectionInlineEmbeddingChunkTypeFullFile captures enum value "full_file"
	DatacollectionInlineEmbeddingChunkTypeFullFile string = "full_file"

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// semantic
	// END DEBUGGING
	// DatacollectionInlineEmbeddingChunkTypeSemantic captures enum value "semantic"
	DatacollectionInlineEmbeddingChunkTypeSemantic string = "semantic"

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// fixed_size
	// END DEBUGGING
	// DatacollectionInlineEmbeddingChunkTypeFixedSize captures enum value "fixed_size"
	DatacollectionInlineEmbeddingChunkTypeFixedSize string = "fixed_size"

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// recursive
	// END DEBUGGING
	// DatacollectionInlineEmbeddingChunkTypeRecursive captures enum value "recursive"
	DatacollectionInlineEmbeddingChunkTypeRecursive string = "recursive"
)

// prop value enum
func (o *DatacollectionInlineEmbedding) validateChunkTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionInlineEmbeddingTypeChunkTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DatacollectionInlineEmbedding) validateChunkType(formats strfmt.Registry) error {
	if swag.IsZero(o.ChunkType) { // not required
		return nil
	}

	// value enum
	if err := o.validateChunkTypeEnum("info"+"."+"embedding"+"."+"chunk_type", "body", *o.ChunkType); err != nil {
		return err
	}

	return nil
}

var datacollectionInlineEmbeddingTypeDimensionPropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[1024]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionInlineEmbeddingTypeDimensionPropEnum = append(datacollectionInlineEmbeddingTypeDimensionPropEnum, v)
	}
}

// prop value enum
func (o *DatacollectionInlineEmbedding) validateDimensionEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, datacollectionInlineEmbeddingTypeDimensionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DatacollectionInlineEmbedding) validateDimension(formats strfmt.Registry) error {
	if swag.IsZero(o.Dimension) { // not required
		return nil
	}

	// value enum
	if err := o.validateDimensionEnum("info"+"."+"embedding"+"."+"dimension", "body", *o.Dimension); err != nil {
		return err
	}

	return nil
}

var datacollectionInlineEmbeddingTypeQuantizationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fp32","fp16"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionInlineEmbeddingTypeQuantizationPropEnum = append(datacollectionInlineEmbeddingTypeQuantizationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// quantization
	// Quantization
	// fp32
	// END DEBUGGING
	// DatacollectionInlineEmbeddingQuantizationFp32 captures enum value "fp32"
	DatacollectionInlineEmbeddingQuantizationFp32 string = "fp32"

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// quantization
	// Quantization
	// fp16
	// END DEBUGGING
	// DatacollectionInlineEmbeddingQuantizationFp16 captures enum value "fp16"
	DatacollectionInlineEmbeddingQuantizationFp16 string = "fp16"
)

// prop value enum
func (o *DatacollectionInlineEmbedding) validateQuantizationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionInlineEmbeddingTypeQuantizationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DatacollectionInlineEmbedding) validateQuantization(formats strfmt.Registry) error {
	if swag.IsZero(o.Quantization) { // not required
		return nil
	}

	// value enum
	if err := o.validateQuantizationEnum("info"+"."+"embedding"+"."+"quantization", "body", *o.Quantization); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this datacollection inline embedding based on context it is used
func (o *DatacollectionInlineEmbedding) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *DatacollectionInlineEmbedding) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DatacollectionInlineEmbedding) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineEmbedding
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DatacollectionInlineEntitiesInlineArrayItem datacollection inline entities inline array item
swagger:model datacollection_inline_entities_inline_array_item
*/
type DatacollectionInlineEntitiesInlineArrayItem struct {

	// Unique identifier of the entity.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection inline entities inline array item
func (o *DatacollectionInlineEntitiesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionInlineEntitiesInlineArrayItem) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this datacollection inline entities inline array item based on context it is used
func (o *DatacollectionInlineEntitiesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *DatacollectionInlineEntitiesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DatacollectionInlineEntitiesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineEntitiesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DatacollectionInlineErrorsInlineArrayItem datacollection inline errors inline array item
swagger:model datacollection_inline_errors_inline_array_item
*/
type DatacollectionInlineErrorsInlineArrayItem struct {

	// error
	Error *models.DcnCommonError `json:"error,omitempty"`
}

// Validate validates this datacollection inline errors inline array item
func (o *DatacollectionInlineErrorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionInlineErrorsInlineArrayItem) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this datacollection inline errors inline array item based on the context it is used
func (o *DatacollectionInlineErrorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionInlineErrorsInlineArrayItem) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DatacollectionInlineErrorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DatacollectionInlineErrorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineErrorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DatacollectionInlineQuery The query selector associated with the data collection.
swagger:model datacollection_inline_query
*/
type DatacollectionInlineQuery struct {

	// The query expression for the selector.
	// Example: {'type': 'pdf'}
	Expression *string `json:"expression,omitempty"`

	// Unique identifier of the query.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection inline query
func (o *DatacollectionInlineQuery) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionInlineQuery) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"query"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this datacollection inline query based on context it is used
func (o *DatacollectionInlineQuery) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *DatacollectionInlineQuery) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DatacollectionInlineQuery) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineQuery
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DatacollectionInlineVersion The version information of a data collection.
swagger:model datacollection_inline_version
*/
type DatacollectionInlineVersion struct {

	// current
	Current *models.DatacollectionInlineVersionInlineCurrent `json:"current,omitempty"`

	// job
	Job *models.DataEngineVersionJob `json:"job,omitempty"`

	// next
	Next *models.DatacollectionInlineVersionInlineNext `json:"next,omitempty"`

	// The unique identifier of the version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection inline version
func (o *DatacollectionInlineVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCurrent(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionInlineVersion) validateCurrent(formats strfmt.Registry) error {
	if swag.IsZero(o.Current) { // not required
		return nil
	}

	if o.Current != nil {
		if err := o.Current.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "current")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionInlineVersion) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(o.Job) { // not required
		return nil
	}

	if o.Job != nil {
		if err := o.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionInlineVersion) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(o.Next) { // not required
		return nil
	}

	if o.Next != nil {
		if err := o.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionInlineVersion) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"version"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection inline version based on the context it is used
func (o *DatacollectionInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionInlineVersion) contextValidateCurrent(ctx context.Context, formats strfmt.Registry) error {

	if o.Current != nil {
		if err := o.Current.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "current")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionInlineVersion) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if o.Job != nil {
		if err := o.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionInlineVersion) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if o.Next != nil {
		if err := o.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "next")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DatacollectionInlineVersion) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DatacollectionInlineVersion) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DatacollectionInlineVersionInlineCurrent Current version information.
swagger:model datacollection_inline_version_inline_current
*/
type DatacollectionInlineVersionInlineCurrent struct {

	// job
	Job *models.DataEngineVersionJob `json:"job,omitempty"`

	// The unique identifier of the current version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection inline version inline current
func (o *DatacollectionInlineVersionInlineCurrent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionInlineVersionInlineCurrent) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(o.Job) { // not required
		return nil
	}

	if o.Job != nil {
		if err := o.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "current" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionInlineVersionInlineCurrent) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"version"+"."+"current"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection inline version inline current based on the context it is used
func (o *DatacollectionInlineVersionInlineCurrent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionInlineVersionInlineCurrent) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if o.Job != nil {
		if err := o.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "current" + "." + "job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DatacollectionInlineVersionInlineCurrent) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DatacollectionInlineVersionInlineCurrent) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineVersionInlineCurrent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DatacollectionInlineVersionInlineNext Next version information.
swagger:model datacollection_inline_version_inline_next
*/
type DatacollectionInlineVersionInlineNext struct {

	// job
	Job *models.DataEngineVersionJob `json:"job,omitempty"`

	// The unique identifier of the next version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection inline version inline next
func (o *DatacollectionInlineVersionInlineNext) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionInlineVersionInlineNext) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(o.Job) { // not required
		return nil
	}

	if o.Job != nil {
		if err := o.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "next" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (o *DatacollectionInlineVersionInlineNext) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"version"+"."+"next"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection inline version inline next based on the context it is used
func (o *DatacollectionInlineVersionInlineNext) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DatacollectionInlineVersionInlineNext) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if o.Job != nil {
		if err := o.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "next" + "." + "job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DatacollectionInlineVersionInlineNext) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DatacollectionInlineVersionInlineNext) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineVersionInlineNext
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
