// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDatacollectionModifyParams creates a new DatacollectionModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionModifyParams() *DatacollectionModifyParams {
	return &DatacollectionModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionModifyParamsWithTimeout creates a new DatacollectionModifyParams object
// with the ability to set a timeout on a request.
func NewDatacollectionModifyParamsWithTimeout(timeout time.Duration) *DatacollectionModifyParams {
	return &DatacollectionModifyParams{
		timeout: timeout,
	}
}

// NewDatacollectionModifyParamsWithContext creates a new DatacollectionModifyParams object
// with the ability to set a context for a request.
func NewDatacollectionModifyParamsWithContext(ctx context.Context) *DatacollectionModifyParams {
	return &DatacollectionModifyParams{
		Context: ctx,
	}
}

// NewDatacollectionModifyParamsWithHTTPClient creates a new DatacollectionModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionModifyParamsWithHTTPClient(client *http.Client) *DatacollectionModifyParams {
	return &DatacollectionModifyParams{
		HTTPClient: client,
	}
}

/*
DatacollectionModifyParams contains all the parameters to send to the API endpoint

	for the datacollection modify operation.

	Typically these are written to a http.Request.
*/
type DatacollectionModifyParams struct {

	/* Info.

	   Data collection specification
	*/
	Info *models.Datacollection

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   Unique identifier of the data collection.
	*/
	UUID string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionModifyParams) WithDefaults() *DatacollectionModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := DatacollectionModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the datacollection modify params
func (o *DatacollectionModifyParams) WithTimeout(timeout time.Duration) *DatacollectionModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection modify params
func (o *DatacollectionModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection modify params
func (o *DatacollectionModifyParams) WithContext(ctx context.Context) *DatacollectionModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection modify params
func (o *DatacollectionModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection modify params
func (o *DatacollectionModifyParams) WithHTTPClient(client *http.Client) *DatacollectionModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection modify params
func (o *DatacollectionModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the datacollection modify params
func (o *DatacollectionModifyParams) WithInfo(info *models.Datacollection) *DatacollectionModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the datacollection modify params
func (o *DatacollectionModifyParams) SetInfo(info *models.Datacollection) {
	o.Info = info
}

// WithReturnTimeout adds the returnTimeout to the datacollection modify params
func (o *DatacollectionModifyParams) WithReturnTimeout(returnTimeout *int64) *DatacollectionModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the datacollection modify params
func (o *DatacollectionModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the datacollection modify params
func (o *DatacollectionModifyParams) WithUUID(uuid string) *DatacollectionModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the datacollection modify params
func (o *DatacollectionModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection modify params
func (o *DatacollectionModifyParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionModifyParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection modify params
func (o *DatacollectionModifyParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
