// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionModifyReader is a Reader for the DatacollectionModify structure.
type DatacollectionModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDatacollectionModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDatacollectionModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionModifyOK creates a DatacollectionModifyOK with default headers values
func NewDatacollectionModifyOK() *DatacollectionModifyOK {
	return &DatacollectionModifyOK{}
}

/*
DatacollectionModifyOK describes a response with status code 200, with default header values.

OK
*/
type DatacollectionModifyOK struct {
	Payload *models.Datacollection
}

// IsSuccess returns true when this datacollection modify o k response has a 2xx status code
func (o *DatacollectionModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection modify o k response has a 3xx status code
func (o *DatacollectionModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection modify o k response has a 4xx status code
func (o *DatacollectionModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection modify o k response has a 5xx status code
func (o *DatacollectionModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection modify o k response a status code equal to that given
func (o *DatacollectionModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the datacollection modify o k response
func (o *DatacollectionModifyOK) Code() int {
	return 200
}

func (o *DatacollectionModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollectionModifyOK %s", 200, payload)
}

func (o *DatacollectionModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollectionModifyOK %s", 200, payload)
}

func (o *DatacollectionModifyOK) GetPayload() *models.Datacollection {
	return o.Payload
}

func (o *DatacollectionModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Datacollection)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionModifyAccepted creates a DatacollectionModifyAccepted with default headers values
func NewDatacollectionModifyAccepted() *DatacollectionModifyAccepted {
	return &DatacollectionModifyAccepted{}
}

/*
DatacollectionModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DatacollectionModifyAccepted struct {
	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this datacollection modify accepted response has a 2xx status code
func (o *DatacollectionModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection modify accepted response has a 3xx status code
func (o *DatacollectionModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection modify accepted response has a 4xx status code
func (o *DatacollectionModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection modify accepted response has a 5xx status code
func (o *DatacollectionModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection modify accepted response a status code equal to that given
func (o *DatacollectionModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the datacollection modify accepted response
func (o *DatacollectionModifyAccepted) Code() int {
	return 202
}

func (o *DatacollectionModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollectionModifyAccepted %s", 202, payload)
}

func (o *DatacollectionModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollectionModifyAccepted %s", 202, payload)
}

func (o *DatacollectionModifyAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *DatacollectionModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionModifyDefault creates a DatacollectionModifyDefault with default headers values
func NewDatacollectionModifyDefault(code int) *DatacollectionModifyDefault {
	return &DatacollectionModifyDefault{
		_statusCode: code,
	}
}

/*
DatacollectionModifyDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection modify default response has a 2xx status code
func (o *DatacollectionModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection modify default response has a 3xx status code
func (o *DatacollectionModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection modify default response has a 4xx status code
func (o *DatacollectionModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection modify default response has a 5xx status code
func (o *DatacollectionModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection modify default response a status code equal to that given
func (o *DatacollectionModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection modify default response
func (o *DatacollectionModifyDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollection_modify default %s", o._statusCode, payload)
}

func (o *DatacollectionModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/data-collections/{uuid}][%d] datacollection_modify default %s", o._statusCode, payload)
}

func (o *DatacollectionModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
