// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDatacollectionSearchDataGetParams creates a new DatacollectionSearchDataGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionSearchDataGetParams() *DatacollectionSearchDataGetParams {
	return &DatacollectionSearchDataGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionSearchDataGetParamsWithTimeout creates a new DatacollectionSearchDataGetParams object
// with the ability to set a timeout on a request.
func NewDatacollectionSearchDataGetParamsWithTimeout(timeout time.Duration) *DatacollectionSearchDataGetParams {
	return &DatacollectionSearchDataGetParams{
		timeout: timeout,
	}
}

// NewDatacollectionSearchDataGetParamsWithContext creates a new DatacollectionSearchDataGetParams object
// with the ability to set a context for a request.
func NewDatacollectionSearchDataGetParamsWithContext(ctx context.Context) *DatacollectionSearchDataGetParams {
	return &DatacollectionSearchDataGetParams{
		Context: ctx,
	}
}

// NewDatacollectionSearchDataGetParamsWithHTTPClient creates a new DatacollectionSearchDataGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionSearchDataGetParamsWithHTTPClient(client *http.Client) *DatacollectionSearchDataGetParams {
	return &DatacollectionSearchDataGetParams{
		HTTPClient: client,
	}
}

/*
DatacollectionSearchDataGetParams contains all the parameters to send to the API endpoint

	for the datacollection search data get operation.

	Typically these are written to a http.Request.
*/
type DatacollectionSearchDataGetParams struct {

	/* DatacollectionUUID.

	   Unique identifier of the data collection.

	   Format: uuid
	*/
	DatacollectionUUID strfmt.UUID

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MaxResults.

	   The maximum number of results to return.
	*/
	MaxResults *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Prompt.

	   The prompt to search for.
	*/
	Prompt string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Version.

	   The version of the data collection to search.

	   Format: uuid
	*/
	Version *strfmt.UUID

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection search data get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionSearchDataGetParams) WithDefaults() *DatacollectionSearchDataGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection search data get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionSearchDataGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DatacollectionSearchDataGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) WithTimeout(timeout time.Duration) *DatacollectionSearchDataGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) WithContext(ctx context.Context) *DatacollectionSearchDataGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) WithHTTPClient(client *http.Client) *DatacollectionSearchDataGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDatacollectionUUID adds the datacollectionUUID to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) WithDatacollectionUUID(datacollectionUUID strfmt.UUID) *DatacollectionSearchDataGetParams {
	o.SetDatacollectionUUID(datacollectionUUID)
	return o
}

// SetDatacollectionUUID adds the datacollectionUuid to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) SetDatacollectionUUID(datacollectionUUID strfmt.UUID) {
	o.DatacollectionUUID = datacollectionUUID
}

// WithFields adds the fields to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) WithFields(fields []string) *DatacollectionSearchDataGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) WithMaxRecords(maxRecords *int64) *DatacollectionSearchDataGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMaxResults adds the maxResults to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) WithMaxResults(maxResults *int64) *DatacollectionSearchDataGetParams {
	o.SetMaxResults(maxResults)
	return o
}

// SetMaxResults adds the maxResults to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) SetMaxResults(maxResults *int64) {
	o.MaxResults = maxResults
}

// WithOrderBy adds the orderBy to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) WithOrderBy(orderBy []string) *DatacollectionSearchDataGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPrompt adds the prompt to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) WithPrompt(prompt string) *DatacollectionSearchDataGetParams {
	o.SetPrompt(prompt)
	return o
}

// SetPrompt adds the prompt to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) SetPrompt(prompt string) {
	o.Prompt = prompt
}

// WithReturnRecords adds the returnRecords to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) WithReturnRecords(returnRecords *bool) *DatacollectionSearchDataGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) WithReturnTimeout(returnTimeout *int64) *DatacollectionSearchDataGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithVersion adds the version to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) WithVersion(version *strfmt.UUID) *DatacollectionSearchDataGetParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) SetVersion(version *strfmt.UUID) {
	o.Version = version
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionSearchDataGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection search data get params
func (o *DatacollectionSearchDataGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionSearchDataGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param datacollection.uuid
	if err := r.SetPathParam("datacollection.uuid", o.DatacollectionUUID.String()); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MaxResults != nil {

		// query param max_results
		var qrMaxResults int64

		if o.MaxResults != nil {
			qrMaxResults = *o.MaxResults
		}
		qMaxResults := swag.FormatInt64(qrMaxResults)
		if qMaxResults != "" {

			if err := r.SetQueryParam("max_results", qMaxResults); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	// query param prompt
	qrPrompt := o.Prompt
	qPrompt := qrPrompt
	if qPrompt != "" {

		if err := r.SetQueryParam("prompt", qPrompt); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Version != nil {

		// query param version
		var qrVersion strfmt.UUID

		if o.Version != nil {
			qrVersion = *o.Version
		}
		qVersion := qrVersion.String()
		if qVersion != "" {

			if err := r.SetQueryParam("version", qVersion); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDatacollectionSearchDataGet binds the parameter fields
func (o *DatacollectionSearchDataGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDatacollectionSearchDataGet binds the parameter order_by
func (o *DatacollectionSearchDataGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
