// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionSearchDataGetReader is a Reader for the DatacollectionSearchDataGet structure.
type DatacollectionSearchDataGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionSearchDataGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDatacollectionSearchDataGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionSearchDataGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionSearchDataGetOK creates a DatacollectionSearchDataGetOK with default headers values
func NewDatacollectionSearchDataGetOK() *DatacollectionSearchDataGetOK {
	return &DatacollectionSearchDataGetOK{}
}

/*
DatacollectionSearchDataGetOK describes a response with status code 200, with default header values.

OK
*/
type DatacollectionSearchDataGetOK struct {
	Payload *models.DatacollectionSearchData
}

// IsSuccess returns true when this datacollection search data get o k response has a 2xx status code
func (o *DatacollectionSearchDataGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection search data get o k response has a 3xx status code
func (o *DatacollectionSearchDataGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection search data get o k response has a 4xx status code
func (o *DatacollectionSearchDataGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection search data get o k response has a 5xx status code
func (o *DatacollectionSearchDataGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection search data get o k response a status code equal to that given
func (o *DatacollectionSearchDataGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the datacollection search data get o k response
func (o *DatacollectionSearchDataGetOK) Code() int {
	return 200
}

func (o *DatacollectionSearchDataGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/search][%d] datacollectionSearchDataGetOK %s", 200, payload)
}

func (o *DatacollectionSearchDataGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/search][%d] datacollectionSearchDataGetOK %s", 200, payload)
}

func (o *DatacollectionSearchDataGetOK) GetPayload() *models.DatacollectionSearchData {
	return o.Payload
}

func (o *DatacollectionSearchDataGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DatacollectionSearchData)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionSearchDataGetDefault creates a DatacollectionSearchDataGetDefault with default headers values
func NewDatacollectionSearchDataGetDefault(code int) *DatacollectionSearchDataGetDefault {
	return &DatacollectionSearchDataGetDefault{
		_statusCode: code,
	}
}

/*
DatacollectionSearchDataGetDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionSearchDataGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection search data get default response has a 2xx status code
func (o *DatacollectionSearchDataGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection search data get default response has a 3xx status code
func (o *DatacollectionSearchDataGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection search data get default response has a 4xx status code
func (o *DatacollectionSearchDataGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection search data get default response has a 5xx status code
func (o *DatacollectionSearchDataGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection search data get default response a status code equal to that given
func (o *DatacollectionSearchDataGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection search data get default response
func (o *DatacollectionSearchDataGetDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionSearchDataGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/search][%d] datacollection_search_data_get default %s", o._statusCode, payload)
}

func (o *DatacollectionSearchDataGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/search][%d] datacollection_search_data_get default %s", o._statusCode, payload)
}

func (o *DatacollectionSearchDataGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionSearchDataGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
