// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDatacollectionVersionCollectionGetParams creates a new DatacollectionVersionCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionVersionCollectionGetParams() *DatacollectionVersionCollectionGetParams {
	return &DatacollectionVersionCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionVersionCollectionGetParamsWithTimeout creates a new DatacollectionVersionCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDatacollectionVersionCollectionGetParamsWithTimeout(timeout time.Duration) *DatacollectionVersionCollectionGetParams {
	return &DatacollectionVersionCollectionGetParams{
		timeout: timeout,
	}
}

// NewDatacollectionVersionCollectionGetParamsWithContext creates a new DatacollectionVersionCollectionGetParams object
// with the ability to set a context for a request.
func NewDatacollectionVersionCollectionGetParamsWithContext(ctx context.Context) *DatacollectionVersionCollectionGetParams {
	return &DatacollectionVersionCollectionGetParams{
		Context: ctx,
	}
}

// NewDatacollectionVersionCollectionGetParamsWithHTTPClient creates a new DatacollectionVersionCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionVersionCollectionGetParamsWithHTTPClient(client *http.Client) *DatacollectionVersionCollectionGetParams {
	return &DatacollectionVersionCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DatacollectionVersionCollectionGetParams contains all the parameters to send to the API endpoint

	for the datacollection version collection get operation.

	Typically these are written to a http.Request.
*/
type DatacollectionVersionCollectionGetParams struct {

	/* DataCollectionCreateTime.

	   Filter by data_collection.create_time
	*/
	DataCollectionCreateTime *string

	/* DataCollectionDescription.

	   Filter by data_collection.description
	*/
	DataCollectionDescription *string

	/* DataCollectionEmbeddingChunkSize.

	   Filter by data_collection.embedding.chunk_size
	*/
	DataCollectionEmbeddingChunkSize *int64

	/* DataCollectionEmbeddingChunkType.

	   Filter by data_collection.embedding.chunk_type
	*/
	DataCollectionEmbeddingChunkType *string

	/* DataCollectionEmbeddingDimension.

	   Filter by data_collection.embedding.dimension
	*/
	DataCollectionEmbeddingDimension *int64

	/* DataCollectionEmbeddingEnabled.

	   Filter by data_collection.embedding.enabled
	*/
	DataCollectionEmbeddingEnabled *bool

	/* DataCollectionEmbeddingQuantization.

	   Filter by data_collection.embedding.quantization
	*/
	DataCollectionEmbeddingQuantization *string

	/* DataCollectionEmbeddingReRank.

	   Filter by data_collection.embedding.re_rank
	*/
	DataCollectionEmbeddingReRank *bool

	/* DataCollectionEntitiesUUID.

	   Filter by data_collection.entities.uuid
	*/
	DataCollectionEntitiesUUID *string

	/* DataCollectionEntityCount.

	   Filter by data_collection.entity_count
	*/
	DataCollectionEntityCount *int64

	/* DataCollectionErrorsErrorCode.

	   Filter by data_collection.errors.error.code
	*/
	DataCollectionErrorsErrorCode *string

	/* DataCollectionErrorsErrorMessage.

	   Filter by data_collection.errors.error.message
	*/
	DataCollectionErrorsErrorMessage *string

	/* DataCollectionErrorsErrorTarget.

	   Filter by data_collection.errors.error.target
	*/
	DataCollectionErrorsErrorTarget *string

	/* DataCollectionLastRefreshTime.

	   Filter by data_collection.last_refresh_time
	*/
	DataCollectionLastRefreshTime *string

	/* DataCollectionMessage.

	   Filter by data_collection.message
	*/
	DataCollectionMessage *string

	/* DataCollectionName.

	   Filter by data_collection.name
	*/
	DataCollectionName *string

	/* DataCollectionOwner.

	   Filter by data_collection.owner
	*/
	DataCollectionOwner *string

	/* DataCollectionQueryExpression.

	   Filter by data_collection.query.expression
	*/
	DataCollectionQueryExpression *string

	/* DataCollectionQueryUUID.

	   Filter by data_collection.query.uuid
	*/
	DataCollectionQueryUUID *string

	/* DataCollectionSize.

	   Filter by data_collection.size
	*/
	DataCollectionSize *int64

	/* DataCollectionState.

	   Filter by data_collection.state
	*/
	DataCollectionState *string

	/* DataCollectionType.

	   Filter by data_collection.type
	*/
	DataCollectionType *string

	/* DataCollectionUUID.

	   Filter by data_collection.uuid
	*/
	DataCollectionUUID *string

	/* DataCollectionVersionJobState.

	   Filter by data_collection.version.job.state
	*/
	DataCollectionVersionJobState *string

	/* DataCollectionVersionJobUUID.

	   Filter by data_collection.version.job.uuid
	*/
	DataCollectionVersionJobUUID *string

	/* DataCollectionVersionUUID.

	   Filter by data_collection.version.uuid
	*/
	DataCollectionVersionUUID *string

	/* DataCollectionWorkspaceName.

	   Filter by data_collection.workspace.name
	*/
	DataCollectionWorkspaceName *string

	/* DataCollectionWorkspaceUUID.

	   Filter by data_collection.workspace.uuid
	*/
	DataCollectionWorkspaceUUID *string

	/* DatacollectionUUID.

	   Unique identifier of the data collection.
	*/
	DatacollectionUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection version collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionVersionCollectionGetParams) WithDefaults() *DatacollectionVersionCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection version collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionVersionCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DatacollectionVersionCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithTimeout(timeout time.Duration) *DatacollectionVersionCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithContext(ctx context.Context) *DatacollectionVersionCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithHTTPClient(client *http.Client) *DatacollectionVersionCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDataCollectionCreateTime adds the dataCollectionCreateTime to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionCreateTime(dataCollectionCreateTime *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionCreateTime(dataCollectionCreateTime)
	return o
}

// SetDataCollectionCreateTime adds the dataCollectionCreateTime to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionCreateTime(dataCollectionCreateTime *string) {
	o.DataCollectionCreateTime = dataCollectionCreateTime
}

// WithDataCollectionDescription adds the dataCollectionDescription to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionDescription(dataCollectionDescription *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionDescription(dataCollectionDescription)
	return o
}

// SetDataCollectionDescription adds the dataCollectionDescription to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionDescription(dataCollectionDescription *string) {
	o.DataCollectionDescription = dataCollectionDescription
}

// WithDataCollectionEmbeddingChunkSize adds the dataCollectionEmbeddingChunkSize to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionEmbeddingChunkSize(dataCollectionEmbeddingChunkSize *int64) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionEmbeddingChunkSize(dataCollectionEmbeddingChunkSize)
	return o
}

// SetDataCollectionEmbeddingChunkSize adds the dataCollectionEmbeddingChunkSize to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionEmbeddingChunkSize(dataCollectionEmbeddingChunkSize *int64) {
	o.DataCollectionEmbeddingChunkSize = dataCollectionEmbeddingChunkSize
}

// WithDataCollectionEmbeddingChunkType adds the dataCollectionEmbeddingChunkType to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionEmbeddingChunkType(dataCollectionEmbeddingChunkType *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionEmbeddingChunkType(dataCollectionEmbeddingChunkType)
	return o
}

// SetDataCollectionEmbeddingChunkType adds the dataCollectionEmbeddingChunkType to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionEmbeddingChunkType(dataCollectionEmbeddingChunkType *string) {
	o.DataCollectionEmbeddingChunkType = dataCollectionEmbeddingChunkType
}

// WithDataCollectionEmbeddingDimension adds the dataCollectionEmbeddingDimension to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionEmbeddingDimension(dataCollectionEmbeddingDimension *int64) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionEmbeddingDimension(dataCollectionEmbeddingDimension)
	return o
}

// SetDataCollectionEmbeddingDimension adds the dataCollectionEmbeddingDimension to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionEmbeddingDimension(dataCollectionEmbeddingDimension *int64) {
	o.DataCollectionEmbeddingDimension = dataCollectionEmbeddingDimension
}

// WithDataCollectionEmbeddingEnabled adds the dataCollectionEmbeddingEnabled to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionEmbeddingEnabled(dataCollectionEmbeddingEnabled *bool) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionEmbeddingEnabled(dataCollectionEmbeddingEnabled)
	return o
}

// SetDataCollectionEmbeddingEnabled adds the dataCollectionEmbeddingEnabled to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionEmbeddingEnabled(dataCollectionEmbeddingEnabled *bool) {
	o.DataCollectionEmbeddingEnabled = dataCollectionEmbeddingEnabled
}

// WithDataCollectionEmbeddingQuantization adds the dataCollectionEmbeddingQuantization to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionEmbeddingQuantization(dataCollectionEmbeddingQuantization *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionEmbeddingQuantization(dataCollectionEmbeddingQuantization)
	return o
}

// SetDataCollectionEmbeddingQuantization adds the dataCollectionEmbeddingQuantization to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionEmbeddingQuantization(dataCollectionEmbeddingQuantization *string) {
	o.DataCollectionEmbeddingQuantization = dataCollectionEmbeddingQuantization
}

// WithDataCollectionEmbeddingReRank adds the dataCollectionEmbeddingReRank to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionEmbeddingReRank(dataCollectionEmbeddingReRank *bool) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionEmbeddingReRank(dataCollectionEmbeddingReRank)
	return o
}

// SetDataCollectionEmbeddingReRank adds the dataCollectionEmbeddingReRank to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionEmbeddingReRank(dataCollectionEmbeddingReRank *bool) {
	o.DataCollectionEmbeddingReRank = dataCollectionEmbeddingReRank
}

// WithDataCollectionEntitiesUUID adds the dataCollectionEntitiesUUID to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionEntitiesUUID(dataCollectionEntitiesUUID *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionEntitiesUUID(dataCollectionEntitiesUUID)
	return o
}

// SetDataCollectionEntitiesUUID adds the dataCollectionEntitiesUuid to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionEntitiesUUID(dataCollectionEntitiesUUID *string) {
	o.DataCollectionEntitiesUUID = dataCollectionEntitiesUUID
}

// WithDataCollectionEntityCount adds the dataCollectionEntityCount to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionEntityCount(dataCollectionEntityCount *int64) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionEntityCount(dataCollectionEntityCount)
	return o
}

// SetDataCollectionEntityCount adds the dataCollectionEntityCount to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionEntityCount(dataCollectionEntityCount *int64) {
	o.DataCollectionEntityCount = dataCollectionEntityCount
}

// WithDataCollectionErrorsErrorCode adds the dataCollectionErrorsErrorCode to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionErrorsErrorCode(dataCollectionErrorsErrorCode *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionErrorsErrorCode(dataCollectionErrorsErrorCode)
	return o
}

// SetDataCollectionErrorsErrorCode adds the dataCollectionErrorsErrorCode to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionErrorsErrorCode(dataCollectionErrorsErrorCode *string) {
	o.DataCollectionErrorsErrorCode = dataCollectionErrorsErrorCode
}

// WithDataCollectionErrorsErrorMessage adds the dataCollectionErrorsErrorMessage to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionErrorsErrorMessage(dataCollectionErrorsErrorMessage *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionErrorsErrorMessage(dataCollectionErrorsErrorMessage)
	return o
}

// SetDataCollectionErrorsErrorMessage adds the dataCollectionErrorsErrorMessage to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionErrorsErrorMessage(dataCollectionErrorsErrorMessage *string) {
	o.DataCollectionErrorsErrorMessage = dataCollectionErrorsErrorMessage
}

// WithDataCollectionErrorsErrorTarget adds the dataCollectionErrorsErrorTarget to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionErrorsErrorTarget(dataCollectionErrorsErrorTarget *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionErrorsErrorTarget(dataCollectionErrorsErrorTarget)
	return o
}

// SetDataCollectionErrorsErrorTarget adds the dataCollectionErrorsErrorTarget to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionErrorsErrorTarget(dataCollectionErrorsErrorTarget *string) {
	o.DataCollectionErrorsErrorTarget = dataCollectionErrorsErrorTarget
}

// WithDataCollectionLastRefreshTime adds the dataCollectionLastRefreshTime to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionLastRefreshTime(dataCollectionLastRefreshTime *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionLastRefreshTime(dataCollectionLastRefreshTime)
	return o
}

// SetDataCollectionLastRefreshTime adds the dataCollectionLastRefreshTime to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionLastRefreshTime(dataCollectionLastRefreshTime *string) {
	o.DataCollectionLastRefreshTime = dataCollectionLastRefreshTime
}

// WithDataCollectionMessage adds the dataCollectionMessage to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionMessage(dataCollectionMessage *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionMessage(dataCollectionMessage)
	return o
}

// SetDataCollectionMessage adds the dataCollectionMessage to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionMessage(dataCollectionMessage *string) {
	o.DataCollectionMessage = dataCollectionMessage
}

// WithDataCollectionName adds the dataCollectionName to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionName(dataCollectionName *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionName(dataCollectionName)
	return o
}

// SetDataCollectionName adds the dataCollectionName to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionName(dataCollectionName *string) {
	o.DataCollectionName = dataCollectionName
}

// WithDataCollectionOwner adds the dataCollectionOwner to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionOwner(dataCollectionOwner *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionOwner(dataCollectionOwner)
	return o
}

// SetDataCollectionOwner adds the dataCollectionOwner to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionOwner(dataCollectionOwner *string) {
	o.DataCollectionOwner = dataCollectionOwner
}

// WithDataCollectionQueryExpression adds the dataCollectionQueryExpression to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionQueryExpression(dataCollectionQueryExpression *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionQueryExpression(dataCollectionQueryExpression)
	return o
}

// SetDataCollectionQueryExpression adds the dataCollectionQueryExpression to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionQueryExpression(dataCollectionQueryExpression *string) {
	o.DataCollectionQueryExpression = dataCollectionQueryExpression
}

// WithDataCollectionQueryUUID adds the dataCollectionQueryUUID to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionQueryUUID(dataCollectionQueryUUID *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionQueryUUID(dataCollectionQueryUUID)
	return o
}

// SetDataCollectionQueryUUID adds the dataCollectionQueryUuid to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionQueryUUID(dataCollectionQueryUUID *string) {
	o.DataCollectionQueryUUID = dataCollectionQueryUUID
}

// WithDataCollectionSize adds the dataCollectionSize to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionSize(dataCollectionSize *int64) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionSize(dataCollectionSize)
	return o
}

// SetDataCollectionSize adds the dataCollectionSize to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionSize(dataCollectionSize *int64) {
	o.DataCollectionSize = dataCollectionSize
}

// WithDataCollectionState adds the dataCollectionState to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionState(dataCollectionState *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionState(dataCollectionState)
	return o
}

// SetDataCollectionState adds the dataCollectionState to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionState(dataCollectionState *string) {
	o.DataCollectionState = dataCollectionState
}

// WithDataCollectionType adds the dataCollectionType to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionType(dataCollectionType *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionType(dataCollectionType)
	return o
}

// SetDataCollectionType adds the dataCollectionType to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionType(dataCollectionType *string) {
	o.DataCollectionType = dataCollectionType
}

// WithDataCollectionUUID adds the dataCollectionUUID to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionUUID(dataCollectionUUID *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionUUID(dataCollectionUUID)
	return o
}

// SetDataCollectionUUID adds the dataCollectionUuid to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionUUID(dataCollectionUUID *string) {
	o.DataCollectionUUID = dataCollectionUUID
}

// WithDataCollectionVersionJobState adds the dataCollectionVersionJobState to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionVersionJobState(dataCollectionVersionJobState *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionVersionJobState(dataCollectionVersionJobState)
	return o
}

// SetDataCollectionVersionJobState adds the dataCollectionVersionJobState to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionVersionJobState(dataCollectionVersionJobState *string) {
	o.DataCollectionVersionJobState = dataCollectionVersionJobState
}

// WithDataCollectionVersionJobUUID adds the dataCollectionVersionJobUUID to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionVersionJobUUID(dataCollectionVersionJobUUID *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionVersionJobUUID(dataCollectionVersionJobUUID)
	return o
}

// SetDataCollectionVersionJobUUID adds the dataCollectionVersionJobUuid to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionVersionJobUUID(dataCollectionVersionJobUUID *string) {
	o.DataCollectionVersionJobUUID = dataCollectionVersionJobUUID
}

// WithDataCollectionVersionUUID adds the dataCollectionVersionUUID to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionVersionUUID(dataCollectionVersionUUID *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionVersionUUID(dataCollectionVersionUUID)
	return o
}

// SetDataCollectionVersionUUID adds the dataCollectionVersionUuid to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionVersionUUID(dataCollectionVersionUUID *string) {
	o.DataCollectionVersionUUID = dataCollectionVersionUUID
}

// WithDataCollectionWorkspaceName adds the dataCollectionWorkspaceName to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionWorkspaceName(dataCollectionWorkspaceName *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionWorkspaceName(dataCollectionWorkspaceName)
	return o
}

// SetDataCollectionWorkspaceName adds the dataCollectionWorkspaceName to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionWorkspaceName(dataCollectionWorkspaceName *string) {
	o.DataCollectionWorkspaceName = dataCollectionWorkspaceName
}

// WithDataCollectionWorkspaceUUID adds the dataCollectionWorkspaceUUID to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDataCollectionWorkspaceUUID(dataCollectionWorkspaceUUID *string) *DatacollectionVersionCollectionGetParams {
	o.SetDataCollectionWorkspaceUUID(dataCollectionWorkspaceUUID)
	return o
}

// SetDataCollectionWorkspaceUUID adds the dataCollectionWorkspaceUuid to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDataCollectionWorkspaceUUID(dataCollectionWorkspaceUUID *string) {
	o.DataCollectionWorkspaceUUID = dataCollectionWorkspaceUUID
}

// WithDatacollectionUUID adds the datacollectionUUID to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithDatacollectionUUID(datacollectionUUID string) *DatacollectionVersionCollectionGetParams {
	o.SetDatacollectionUUID(datacollectionUUID)
	return o
}

// SetDatacollectionUUID adds the datacollectionUuid to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetDatacollectionUUID(datacollectionUUID string) {
	o.DatacollectionUUID = datacollectionUUID
}

// WithFields adds the fields to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithFields(fields []string) *DatacollectionVersionCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithMaxRecords(maxRecords *int64) *DatacollectionVersionCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithOrderBy(orderBy []string) *DatacollectionVersionCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithReturnRecords(returnRecords *bool) *DatacollectionVersionCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DatacollectionVersionCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithUUID(uuid *string) *DatacollectionVersionCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionVersionCollectionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection version collection get params
func (o *DatacollectionVersionCollectionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionVersionCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DataCollectionCreateTime != nil {

		// query param data_collection.create_time
		var qrDataCollectionCreateTime string

		if o.DataCollectionCreateTime != nil {
			qrDataCollectionCreateTime = *o.DataCollectionCreateTime
		}
		qDataCollectionCreateTime := qrDataCollectionCreateTime
		if qDataCollectionCreateTime != "" {

			if err := r.SetQueryParam("data_collection.create_time", qDataCollectionCreateTime); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionDescription != nil {

		// query param data_collection.description
		var qrDataCollectionDescription string

		if o.DataCollectionDescription != nil {
			qrDataCollectionDescription = *o.DataCollectionDescription
		}
		qDataCollectionDescription := qrDataCollectionDescription
		if qDataCollectionDescription != "" {

			if err := r.SetQueryParam("data_collection.description", qDataCollectionDescription); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionEmbeddingChunkSize != nil {

		// query param data_collection.embedding.chunk_size
		var qrDataCollectionEmbeddingChunkSize int64

		if o.DataCollectionEmbeddingChunkSize != nil {
			qrDataCollectionEmbeddingChunkSize = *o.DataCollectionEmbeddingChunkSize
		}
		qDataCollectionEmbeddingChunkSize := swag.FormatInt64(qrDataCollectionEmbeddingChunkSize)
		if qDataCollectionEmbeddingChunkSize != "" {

			if err := r.SetQueryParam("data_collection.embedding.chunk_size", qDataCollectionEmbeddingChunkSize); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionEmbeddingChunkType != nil {

		// query param data_collection.embedding.chunk_type
		var qrDataCollectionEmbeddingChunkType string

		if o.DataCollectionEmbeddingChunkType != nil {
			qrDataCollectionEmbeddingChunkType = *o.DataCollectionEmbeddingChunkType
		}
		qDataCollectionEmbeddingChunkType := qrDataCollectionEmbeddingChunkType
		if qDataCollectionEmbeddingChunkType != "" {

			if err := r.SetQueryParam("data_collection.embedding.chunk_type", qDataCollectionEmbeddingChunkType); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionEmbeddingDimension != nil {

		// query param data_collection.embedding.dimension
		var qrDataCollectionEmbeddingDimension int64

		if o.DataCollectionEmbeddingDimension != nil {
			qrDataCollectionEmbeddingDimension = *o.DataCollectionEmbeddingDimension
		}
		qDataCollectionEmbeddingDimension := swag.FormatInt64(qrDataCollectionEmbeddingDimension)
		if qDataCollectionEmbeddingDimension != "" {

			if err := r.SetQueryParam("data_collection.embedding.dimension", qDataCollectionEmbeddingDimension); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionEmbeddingEnabled != nil {

		// query param data_collection.embedding.enabled
		var qrDataCollectionEmbeddingEnabled bool

		if o.DataCollectionEmbeddingEnabled != nil {
			qrDataCollectionEmbeddingEnabled = *o.DataCollectionEmbeddingEnabled
		}
		qDataCollectionEmbeddingEnabled := swag.FormatBool(qrDataCollectionEmbeddingEnabled)
		if qDataCollectionEmbeddingEnabled != "" {

			if err := r.SetQueryParam("data_collection.embedding.enabled", qDataCollectionEmbeddingEnabled); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionEmbeddingQuantization != nil {

		// query param data_collection.embedding.quantization
		var qrDataCollectionEmbeddingQuantization string

		if o.DataCollectionEmbeddingQuantization != nil {
			qrDataCollectionEmbeddingQuantization = *o.DataCollectionEmbeddingQuantization
		}
		qDataCollectionEmbeddingQuantization := qrDataCollectionEmbeddingQuantization
		if qDataCollectionEmbeddingQuantization != "" {

			if err := r.SetQueryParam("data_collection.embedding.quantization", qDataCollectionEmbeddingQuantization); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionEmbeddingReRank != nil {

		// query param data_collection.embedding.re_rank
		var qrDataCollectionEmbeddingReRank bool

		if o.DataCollectionEmbeddingReRank != nil {
			qrDataCollectionEmbeddingReRank = *o.DataCollectionEmbeddingReRank
		}
		qDataCollectionEmbeddingReRank := swag.FormatBool(qrDataCollectionEmbeddingReRank)
		if qDataCollectionEmbeddingReRank != "" {

			if err := r.SetQueryParam("data_collection.embedding.re_rank", qDataCollectionEmbeddingReRank); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionEntitiesUUID != nil {

		// query param data_collection.entities.uuid
		var qrDataCollectionEntitiesUUID string

		if o.DataCollectionEntitiesUUID != nil {
			qrDataCollectionEntitiesUUID = *o.DataCollectionEntitiesUUID
		}
		qDataCollectionEntitiesUUID := qrDataCollectionEntitiesUUID
		if qDataCollectionEntitiesUUID != "" {

			if err := r.SetQueryParam("data_collection.entities.uuid", qDataCollectionEntitiesUUID); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionEntityCount != nil {

		// query param data_collection.entity_count
		var qrDataCollectionEntityCount int64

		if o.DataCollectionEntityCount != nil {
			qrDataCollectionEntityCount = *o.DataCollectionEntityCount
		}
		qDataCollectionEntityCount := swag.FormatInt64(qrDataCollectionEntityCount)
		if qDataCollectionEntityCount != "" {

			if err := r.SetQueryParam("data_collection.entity_count", qDataCollectionEntityCount); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionErrorsErrorCode != nil {

		// query param data_collection.errors.error.code
		var qrDataCollectionErrorsErrorCode string

		if o.DataCollectionErrorsErrorCode != nil {
			qrDataCollectionErrorsErrorCode = *o.DataCollectionErrorsErrorCode
		}
		qDataCollectionErrorsErrorCode := qrDataCollectionErrorsErrorCode
		if qDataCollectionErrorsErrorCode != "" {

			if err := r.SetQueryParam("data_collection.errors.error.code", qDataCollectionErrorsErrorCode); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionErrorsErrorMessage != nil {

		// query param data_collection.errors.error.message
		var qrDataCollectionErrorsErrorMessage string

		if o.DataCollectionErrorsErrorMessage != nil {
			qrDataCollectionErrorsErrorMessage = *o.DataCollectionErrorsErrorMessage
		}
		qDataCollectionErrorsErrorMessage := qrDataCollectionErrorsErrorMessage
		if qDataCollectionErrorsErrorMessage != "" {

			if err := r.SetQueryParam("data_collection.errors.error.message", qDataCollectionErrorsErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionErrorsErrorTarget != nil {

		// query param data_collection.errors.error.target
		var qrDataCollectionErrorsErrorTarget string

		if o.DataCollectionErrorsErrorTarget != nil {
			qrDataCollectionErrorsErrorTarget = *o.DataCollectionErrorsErrorTarget
		}
		qDataCollectionErrorsErrorTarget := qrDataCollectionErrorsErrorTarget
		if qDataCollectionErrorsErrorTarget != "" {

			if err := r.SetQueryParam("data_collection.errors.error.target", qDataCollectionErrorsErrorTarget); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionLastRefreshTime != nil {

		// query param data_collection.last_refresh_time
		var qrDataCollectionLastRefreshTime string

		if o.DataCollectionLastRefreshTime != nil {
			qrDataCollectionLastRefreshTime = *o.DataCollectionLastRefreshTime
		}
		qDataCollectionLastRefreshTime := qrDataCollectionLastRefreshTime
		if qDataCollectionLastRefreshTime != "" {

			if err := r.SetQueryParam("data_collection.last_refresh_time", qDataCollectionLastRefreshTime); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionMessage != nil {

		// query param data_collection.message
		var qrDataCollectionMessage string

		if o.DataCollectionMessage != nil {
			qrDataCollectionMessage = *o.DataCollectionMessage
		}
		qDataCollectionMessage := qrDataCollectionMessage
		if qDataCollectionMessage != "" {

			if err := r.SetQueryParam("data_collection.message", qDataCollectionMessage); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionName != nil {

		// query param data_collection.name
		var qrDataCollectionName string

		if o.DataCollectionName != nil {
			qrDataCollectionName = *o.DataCollectionName
		}
		qDataCollectionName := qrDataCollectionName
		if qDataCollectionName != "" {

			if err := r.SetQueryParam("data_collection.name", qDataCollectionName); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionOwner != nil {

		// query param data_collection.owner
		var qrDataCollectionOwner string

		if o.DataCollectionOwner != nil {
			qrDataCollectionOwner = *o.DataCollectionOwner
		}
		qDataCollectionOwner := qrDataCollectionOwner
		if qDataCollectionOwner != "" {

			if err := r.SetQueryParam("data_collection.owner", qDataCollectionOwner); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionQueryExpression != nil {

		// query param data_collection.query.expression
		var qrDataCollectionQueryExpression string

		if o.DataCollectionQueryExpression != nil {
			qrDataCollectionQueryExpression = *o.DataCollectionQueryExpression
		}
		qDataCollectionQueryExpression := qrDataCollectionQueryExpression
		if qDataCollectionQueryExpression != "" {

			if err := r.SetQueryParam("data_collection.query.expression", qDataCollectionQueryExpression); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionQueryUUID != nil {

		// query param data_collection.query.uuid
		var qrDataCollectionQueryUUID string

		if o.DataCollectionQueryUUID != nil {
			qrDataCollectionQueryUUID = *o.DataCollectionQueryUUID
		}
		qDataCollectionQueryUUID := qrDataCollectionQueryUUID
		if qDataCollectionQueryUUID != "" {

			if err := r.SetQueryParam("data_collection.query.uuid", qDataCollectionQueryUUID); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionSize != nil {

		// query param data_collection.size
		var qrDataCollectionSize int64

		if o.DataCollectionSize != nil {
			qrDataCollectionSize = *o.DataCollectionSize
		}
		qDataCollectionSize := swag.FormatInt64(qrDataCollectionSize)
		if qDataCollectionSize != "" {

			if err := r.SetQueryParam("data_collection.size", qDataCollectionSize); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionState != nil {

		// query param data_collection.state
		var qrDataCollectionState string

		if o.DataCollectionState != nil {
			qrDataCollectionState = *o.DataCollectionState
		}
		qDataCollectionState := qrDataCollectionState
		if qDataCollectionState != "" {

			if err := r.SetQueryParam("data_collection.state", qDataCollectionState); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionType != nil {

		// query param data_collection.type
		var qrDataCollectionType string

		if o.DataCollectionType != nil {
			qrDataCollectionType = *o.DataCollectionType
		}
		qDataCollectionType := qrDataCollectionType
		if qDataCollectionType != "" {

			if err := r.SetQueryParam("data_collection.type", qDataCollectionType); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionUUID != nil {

		// query param data_collection.uuid
		var qrDataCollectionUUID string

		if o.DataCollectionUUID != nil {
			qrDataCollectionUUID = *o.DataCollectionUUID
		}
		qDataCollectionUUID := qrDataCollectionUUID
		if qDataCollectionUUID != "" {

			if err := r.SetQueryParam("data_collection.uuid", qDataCollectionUUID); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionVersionJobState != nil {

		// query param data_collection.version.job.state
		var qrDataCollectionVersionJobState string

		if o.DataCollectionVersionJobState != nil {
			qrDataCollectionVersionJobState = *o.DataCollectionVersionJobState
		}
		qDataCollectionVersionJobState := qrDataCollectionVersionJobState
		if qDataCollectionVersionJobState != "" {

			if err := r.SetQueryParam("data_collection.version.job.state", qDataCollectionVersionJobState); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionVersionJobUUID != nil {

		// query param data_collection.version.job.uuid
		var qrDataCollectionVersionJobUUID string

		if o.DataCollectionVersionJobUUID != nil {
			qrDataCollectionVersionJobUUID = *o.DataCollectionVersionJobUUID
		}
		qDataCollectionVersionJobUUID := qrDataCollectionVersionJobUUID
		if qDataCollectionVersionJobUUID != "" {

			if err := r.SetQueryParam("data_collection.version.job.uuid", qDataCollectionVersionJobUUID); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionVersionUUID != nil {

		// query param data_collection.version.uuid
		var qrDataCollectionVersionUUID string

		if o.DataCollectionVersionUUID != nil {
			qrDataCollectionVersionUUID = *o.DataCollectionVersionUUID
		}
		qDataCollectionVersionUUID := qrDataCollectionVersionUUID
		if qDataCollectionVersionUUID != "" {

			if err := r.SetQueryParam("data_collection.version.uuid", qDataCollectionVersionUUID); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionWorkspaceName != nil {

		// query param data_collection.workspace.name
		var qrDataCollectionWorkspaceName string

		if o.DataCollectionWorkspaceName != nil {
			qrDataCollectionWorkspaceName = *o.DataCollectionWorkspaceName
		}
		qDataCollectionWorkspaceName := qrDataCollectionWorkspaceName
		if qDataCollectionWorkspaceName != "" {

			if err := r.SetQueryParam("data_collection.workspace.name", qDataCollectionWorkspaceName); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionWorkspaceUUID != nil {

		// query param data_collection.workspace.uuid
		var qrDataCollectionWorkspaceUUID string

		if o.DataCollectionWorkspaceUUID != nil {
			qrDataCollectionWorkspaceUUID = *o.DataCollectionWorkspaceUUID
		}
		qDataCollectionWorkspaceUUID := qrDataCollectionWorkspaceUUID
		if qDataCollectionWorkspaceUUID != "" {

			if err := r.SetQueryParam("data_collection.workspace.uuid", qDataCollectionWorkspaceUUID); err != nil {
				return err
			}
		}
	}

	// path param datacollection.uuid
	if err := r.SetPathParam("datacollection.uuid", o.DatacollectionUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDatacollectionVersionCollectionGet binds the parameter fields
func (o *DatacollectionVersionCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDatacollectionVersionCollectionGet binds the parameter order_by
func (o *DatacollectionVersionCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
