// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDatacollectionVersionDiffCollectionGetParams creates a new DatacollectionVersionDiffCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionVersionDiffCollectionGetParams() *DatacollectionVersionDiffCollectionGetParams {
	return &DatacollectionVersionDiffCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionVersionDiffCollectionGetParamsWithTimeout creates a new DatacollectionVersionDiffCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDatacollectionVersionDiffCollectionGetParamsWithTimeout(timeout time.Duration) *DatacollectionVersionDiffCollectionGetParams {
	return &DatacollectionVersionDiffCollectionGetParams{
		timeout: timeout,
	}
}

// NewDatacollectionVersionDiffCollectionGetParamsWithContext creates a new DatacollectionVersionDiffCollectionGetParams object
// with the ability to set a context for a request.
func NewDatacollectionVersionDiffCollectionGetParamsWithContext(ctx context.Context) *DatacollectionVersionDiffCollectionGetParams {
	return &DatacollectionVersionDiffCollectionGetParams{
		Context: ctx,
	}
}

// NewDatacollectionVersionDiffCollectionGetParamsWithHTTPClient creates a new DatacollectionVersionDiffCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionVersionDiffCollectionGetParamsWithHTTPClient(client *http.Client) *DatacollectionVersionDiffCollectionGetParams {
	return &DatacollectionVersionDiffCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DatacollectionVersionDiffCollectionGetParams contains all the parameters to send to the API endpoint

	for the datacollection version diff collection get operation.

	Typically these are written to a http.Request.
*/
type DatacollectionVersionDiffCollectionGetParams struct {

	/* ChangeType.

	   Filter by change_type
	*/
	ChangeType *string

	/* DataCollectionName.

	   Filter by data_collection.name
	*/
	DataCollectionName *string

	/* DataCollectionUUID.

	   Filter by data_collection.uuid
	*/
	DataCollectionUUID *string

	/* DataCollectionVersionUUID.

	   Filter by data_collection.version.uuid
	*/
	DataCollectionVersionUUID *string

	/* DataSourceName.

	   Filter by data_source.name
	*/
	DataSourceName *string

	/* DataSourceType.

	   Filter by data_source.type
	*/
	DataSourceType *string

	/* DataSourceUUID.

	   Filter by data_source.uuid
	*/
	DataSourceUUID *string

	/* DatacollectionUUID.

	   Unique identifier of the data collection.
	*/
	DatacollectionUUID string

	/* DatacollectionVersionUUID.

	   Unique identifier of the data collection version.
	*/
	DatacollectionVersionUUID string

	/* EntitiesEntityType.

	   Filter by entities.entity_type
	*/
	EntitiesEntityType *string

	/* EntitiesName.

	   Filter by entities.name
	*/
	EntitiesName *string

	/* EntitiesUUID.

	   Filter by entities.uuid
	*/
	EntitiesUUID *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* VersionBase.

	   Filter by version.base
	*/
	VersionBase *string

	/* VersionUUID.

	   Filter by version.uuid
	*/
	VersionUUID *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection version diff collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionVersionDiffCollectionGetParams) WithDefaults() *DatacollectionVersionDiffCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection version diff collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionVersionDiffCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DatacollectionVersionDiffCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithTimeout(timeout time.Duration) *DatacollectionVersionDiffCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithContext(ctx context.Context) *DatacollectionVersionDiffCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithHTTPClient(client *http.Client) *DatacollectionVersionDiffCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithChangeType adds the changeType to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithChangeType(changeType *string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetChangeType(changeType)
	return o
}

// SetChangeType adds the changeType to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetChangeType(changeType *string) {
	o.ChangeType = changeType
}

// WithDataCollectionName adds the dataCollectionName to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithDataCollectionName(dataCollectionName *string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetDataCollectionName(dataCollectionName)
	return o
}

// SetDataCollectionName adds the dataCollectionName to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetDataCollectionName(dataCollectionName *string) {
	o.DataCollectionName = dataCollectionName
}

// WithDataCollectionUUID adds the dataCollectionUUID to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithDataCollectionUUID(dataCollectionUUID *string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetDataCollectionUUID(dataCollectionUUID)
	return o
}

// SetDataCollectionUUID adds the dataCollectionUuid to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetDataCollectionUUID(dataCollectionUUID *string) {
	o.DataCollectionUUID = dataCollectionUUID
}

// WithDataCollectionVersionUUID adds the dataCollectionVersionUUID to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithDataCollectionVersionUUID(dataCollectionVersionUUID *string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetDataCollectionVersionUUID(dataCollectionVersionUUID)
	return o
}

// SetDataCollectionVersionUUID adds the dataCollectionVersionUuid to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetDataCollectionVersionUUID(dataCollectionVersionUUID *string) {
	o.DataCollectionVersionUUID = dataCollectionVersionUUID
}

// WithDataSourceName adds the dataSourceName to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithDataSourceName(dataSourceName *string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetDataSourceName(dataSourceName)
	return o
}

// SetDataSourceName adds the dataSourceName to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetDataSourceName(dataSourceName *string) {
	o.DataSourceName = dataSourceName
}

// WithDataSourceType adds the dataSourceType to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithDataSourceType(dataSourceType *string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetDataSourceType(dataSourceType)
	return o
}

// SetDataSourceType adds the dataSourceType to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetDataSourceType(dataSourceType *string) {
	o.DataSourceType = dataSourceType
}

// WithDataSourceUUID adds the dataSourceUUID to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithDataSourceUUID(dataSourceUUID *string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetDataSourceUUID(dataSourceUUID)
	return o
}

// SetDataSourceUUID adds the dataSourceUuid to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetDataSourceUUID(dataSourceUUID *string) {
	o.DataSourceUUID = dataSourceUUID
}

// WithDatacollectionUUID adds the datacollectionUUID to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithDatacollectionUUID(datacollectionUUID string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetDatacollectionUUID(datacollectionUUID)
	return o
}

// SetDatacollectionUUID adds the datacollectionUuid to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetDatacollectionUUID(datacollectionUUID string) {
	o.DatacollectionUUID = datacollectionUUID
}

// WithDatacollectionVersionUUID adds the datacollectionVersionUUID to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithDatacollectionVersionUUID(datacollectionVersionUUID string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetDatacollectionVersionUUID(datacollectionVersionUUID)
	return o
}

// SetDatacollectionVersionUUID adds the datacollectionVersionUuid to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetDatacollectionVersionUUID(datacollectionVersionUUID string) {
	o.DatacollectionVersionUUID = datacollectionVersionUUID
}

// WithEntitiesEntityType adds the entitiesEntityType to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithEntitiesEntityType(entitiesEntityType *string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetEntitiesEntityType(entitiesEntityType)
	return o
}

// SetEntitiesEntityType adds the entitiesEntityType to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetEntitiesEntityType(entitiesEntityType *string) {
	o.EntitiesEntityType = entitiesEntityType
}

// WithEntitiesName adds the entitiesName to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithEntitiesName(entitiesName *string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetEntitiesName(entitiesName)
	return o
}

// SetEntitiesName adds the entitiesName to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetEntitiesName(entitiesName *string) {
	o.EntitiesName = entitiesName
}

// WithEntitiesUUID adds the entitiesUUID to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithEntitiesUUID(entitiesUUID *string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetEntitiesUUID(entitiesUUID)
	return o
}

// SetEntitiesUUID adds the entitiesUuid to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetEntitiesUUID(entitiesUUID *string) {
	o.EntitiesUUID = entitiesUUID
}

// WithFields adds the fields to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithFields(fields []string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithMaxRecords(maxRecords *int64) *DatacollectionVersionDiffCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithOrderBy(orderBy []string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithReturnRecords(returnRecords *bool) *DatacollectionVersionDiffCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DatacollectionVersionDiffCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithVersionBase adds the versionBase to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithVersionBase(versionBase *string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetVersionBase(versionBase)
	return o
}

// SetVersionBase adds the versionBase to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetVersionBase(versionBase *string) {
	o.VersionBase = versionBase
}

// WithVersionUUID adds the versionUUID to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithVersionUUID(versionUUID *string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetVersionUUID(versionUUID)
	return o
}

// SetVersionUUID adds the versionUuid to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetVersionUUID(versionUUID *string) {
	o.VersionUUID = versionUUID
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionVersionDiffCollectionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection version diff collection get params
func (o *DatacollectionVersionDiffCollectionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionVersionDiffCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ChangeType != nil {

		// query param change_type
		var qrChangeType string

		if o.ChangeType != nil {
			qrChangeType = *o.ChangeType
		}
		qChangeType := qrChangeType
		if qChangeType != "" {

			if err := r.SetQueryParam("change_type", qChangeType); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionName != nil {

		// query param data_collection.name
		var qrDataCollectionName string

		if o.DataCollectionName != nil {
			qrDataCollectionName = *o.DataCollectionName
		}
		qDataCollectionName := qrDataCollectionName
		if qDataCollectionName != "" {

			if err := r.SetQueryParam("data_collection.name", qDataCollectionName); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionUUID != nil {

		// query param data_collection.uuid
		var qrDataCollectionUUID string

		if o.DataCollectionUUID != nil {
			qrDataCollectionUUID = *o.DataCollectionUUID
		}
		qDataCollectionUUID := qrDataCollectionUUID
		if qDataCollectionUUID != "" {

			if err := r.SetQueryParam("data_collection.uuid", qDataCollectionUUID); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionVersionUUID != nil {

		// query param data_collection.version.uuid
		var qrDataCollectionVersionUUID string

		if o.DataCollectionVersionUUID != nil {
			qrDataCollectionVersionUUID = *o.DataCollectionVersionUUID
		}
		qDataCollectionVersionUUID := qrDataCollectionVersionUUID
		if qDataCollectionVersionUUID != "" {

			if err := r.SetQueryParam("data_collection.version.uuid", qDataCollectionVersionUUID); err != nil {
				return err
			}
		}
	}

	if o.DataSourceName != nil {

		// query param data_source.name
		var qrDataSourceName string

		if o.DataSourceName != nil {
			qrDataSourceName = *o.DataSourceName
		}
		qDataSourceName := qrDataSourceName
		if qDataSourceName != "" {

			if err := r.SetQueryParam("data_source.name", qDataSourceName); err != nil {
				return err
			}
		}
	}

	if o.DataSourceType != nil {

		// query param data_source.type
		var qrDataSourceType string

		if o.DataSourceType != nil {
			qrDataSourceType = *o.DataSourceType
		}
		qDataSourceType := qrDataSourceType
		if qDataSourceType != "" {

			if err := r.SetQueryParam("data_source.type", qDataSourceType); err != nil {
				return err
			}
		}
	}

	if o.DataSourceUUID != nil {

		// query param data_source.uuid
		var qrDataSourceUUID string

		if o.DataSourceUUID != nil {
			qrDataSourceUUID = *o.DataSourceUUID
		}
		qDataSourceUUID := qrDataSourceUUID
		if qDataSourceUUID != "" {

			if err := r.SetQueryParam("data_source.uuid", qDataSourceUUID); err != nil {
				return err
			}
		}
	}

	// path param datacollection.uuid
	if err := r.SetPathParam("datacollection.uuid", o.DatacollectionUUID); err != nil {
		return err
	}

	// path param datacollection_version.uuid
	if err := r.SetPathParam("datacollection_version.uuid", o.DatacollectionVersionUUID); err != nil {
		return err
	}

	if o.EntitiesEntityType != nil {

		// query param entities.entity_type
		var qrEntitiesEntityType string

		if o.EntitiesEntityType != nil {
			qrEntitiesEntityType = *o.EntitiesEntityType
		}
		qEntitiesEntityType := qrEntitiesEntityType
		if qEntitiesEntityType != "" {

			if err := r.SetQueryParam("entities.entity_type", qEntitiesEntityType); err != nil {
				return err
			}
		}
	}

	if o.EntitiesName != nil {

		// query param entities.name
		var qrEntitiesName string

		if o.EntitiesName != nil {
			qrEntitiesName = *o.EntitiesName
		}
		qEntitiesName := qrEntitiesName
		if qEntitiesName != "" {

			if err := r.SetQueryParam("entities.name", qEntitiesName); err != nil {
				return err
			}
		}
	}

	if o.EntitiesUUID != nil {

		// query param entities.uuid
		var qrEntitiesUUID string

		if o.EntitiesUUID != nil {
			qrEntitiesUUID = *o.EntitiesUUID
		}
		qEntitiesUUID := qrEntitiesUUID
		if qEntitiesUUID != "" {

			if err := r.SetQueryParam("entities.uuid", qEntitiesUUID); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.VersionBase != nil {

		// query param version.base
		var qrVersionBase string

		if o.VersionBase != nil {
			qrVersionBase = *o.VersionBase
		}
		qVersionBase := qrVersionBase
		if qVersionBase != "" {

			if err := r.SetQueryParam("version.base", qVersionBase); err != nil {
				return err
			}
		}
	}

	if o.VersionUUID != nil {

		// query param version.uuid
		var qrVersionUUID string

		if o.VersionUUID != nil {
			qrVersionUUID = *o.VersionUUID
		}
		qVersionUUID := qrVersionUUID
		if qVersionUUID != "" {

			if err := r.SetQueryParam("version.uuid", qVersionUUID); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDatacollectionVersionDiffCollectionGet binds the parameter fields
func (o *DatacollectionVersionDiffCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDatacollectionVersionDiffCollectionGet binds the parameter order_by
func (o *DatacollectionVersionDiffCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
