// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionVersionDiffCollectionGetReader is a Reader for the DatacollectionVersionDiffCollectionGet structure.
type DatacollectionVersionDiffCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionVersionDiffCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDatacollectionVersionDiffCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionVersionDiffCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionVersionDiffCollectionGetOK creates a DatacollectionVersionDiffCollectionGetOK with default headers values
func NewDatacollectionVersionDiffCollectionGetOK() *DatacollectionVersionDiffCollectionGetOK {
	return &DatacollectionVersionDiffCollectionGetOK{}
}

/*
DatacollectionVersionDiffCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DatacollectionVersionDiffCollectionGetOK struct {
	Payload *models.DatacollectionVersionDiffResponse
}

// IsSuccess returns true when this datacollection version diff collection get o k response has a 2xx status code
func (o *DatacollectionVersionDiffCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection version diff collection get o k response has a 3xx status code
func (o *DatacollectionVersionDiffCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection version diff collection get o k response has a 4xx status code
func (o *DatacollectionVersionDiffCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection version diff collection get o k response has a 5xx status code
func (o *DatacollectionVersionDiffCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection version diff collection get o k response a status code equal to that given
func (o *DatacollectionVersionDiffCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the datacollection version diff collection get o k response
func (o *DatacollectionVersionDiffCollectionGetOK) Code() int {
	return 200
}

func (o *DatacollectionVersionDiffCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{datacollection_version.uuid}/diffs][%d] datacollectionVersionDiffCollectionGetOK %s", 200, payload)
}

func (o *DatacollectionVersionDiffCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{datacollection_version.uuid}/diffs][%d] datacollectionVersionDiffCollectionGetOK %s", 200, payload)
}

func (o *DatacollectionVersionDiffCollectionGetOK) GetPayload() *models.DatacollectionVersionDiffResponse {
	return o.Payload
}

func (o *DatacollectionVersionDiffCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DatacollectionVersionDiffResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionVersionDiffCollectionGetDefault creates a DatacollectionVersionDiffCollectionGetDefault with default headers values
func NewDatacollectionVersionDiffCollectionGetDefault(code int) *DatacollectionVersionDiffCollectionGetDefault {
	return &DatacollectionVersionDiffCollectionGetDefault{
		_statusCode: code,
	}
}

/*
DatacollectionVersionDiffCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionVersionDiffCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection version diff collection get default response has a 2xx status code
func (o *DatacollectionVersionDiffCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection version diff collection get default response has a 3xx status code
func (o *DatacollectionVersionDiffCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection version diff collection get default response has a 4xx status code
func (o *DatacollectionVersionDiffCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection version diff collection get default response has a 5xx status code
func (o *DatacollectionVersionDiffCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection version diff collection get default response a status code equal to that given
func (o *DatacollectionVersionDiffCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection version diff collection get default response
func (o *DatacollectionVersionDiffCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionVersionDiffCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{datacollection_version.uuid}/diffs][%d] datacollection_version_diff_collection_get default %s", o._statusCode, payload)
}

func (o *DatacollectionVersionDiffCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{datacollection_version.uuid}/diffs][%d] datacollection_version_diff_collection_get default %s", o._statusCode, payload)
}

func (o *DatacollectionVersionDiffCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionVersionDiffCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
